//========================================================================================
/**
 * @brief j[EBhE`NX( p )
 * @file app_tool_KawaigariMenuDrawer.h
 * @author takada_keisuke
 * @date 2012.05.21
 */
//========================================================================================
#ifndef __APPTOOL_KAWAIGARIMENUDRAWER_H__
#define __APPTOOL_KAWAIGARIMENUDRAWER_H__ 
#include <gflib.h>
#include <sound/SoundMiddleID.h>
#include "app_tool_MenuWindowDrawer.h"


namespace app {
  namespace tool {

    class MenuWindow;
    class MenuWindowController;


    class KawaigariMenuDrawer : public MenuWindowDrawer
    {
      GFL_FORBID_COPY_AND_ASSIGN( KawaigariMenuDrawer );


      public:
        //--------------------------------------------------------------------------------
        // RXgN^EfXgN^
        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         * @param heap             AvP[Vq[v
         * @param device_heap      foCXq[v
         * @param graphics_system  `ɎgpOtBbNXVXe
         * @param layout_system    `Ɏgp郌CAEgVXe
         */
        KawaigariMenuDrawer( 
            gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
            gfl::grp::GraphicsSystem* graphics_system, gfl::grp::g2d::LytSys* layout_system );

        /**
         * @brief fXgN^
         */
        virtual ~KawaigariMenuDrawer();



        //--------------------------------------------------------------------------------
        // 擾
        //--------------------------------------------------------------------------------
        /**
         * @brief II΂ꂽۂ̃AjIǂ𒲂ׂ
         * @param alt_index  ICfbNX
         * @retval true   I
         * @retval false  IĂȂ
         */
        virtual bool IsSelectAnimeEnd( u32 alt_index ) const;



        //--------------------------------------------------------------------------------
        // TEh
        //--------------------------------------------------------------------------------
        /**
         * @brief J[\ړ擾
         */
        virtual u32 GetCursorSE( void ) const { return SEQ_SE_SELECT1; }

        /**
         * @brief I擾
         */
        virtual u32 GetSelectSE( void ) const { return SEQ_SE_DECIDE1; }

        /**
         * @brief LZ擾
         */
        virtual u32 GetCancelSE( void ) const { return SEQ_SE_CANCEL1; }



      private: 


        // Aj[Vf[^
        enum AnimeDataIndex {
          ANIME_DATA_DUMMY_ACTIVE,
          ANIME_DATA_DUMMY_PASSIVE,
          ANIME_DATA_DUMMY_HOLD,
          ANIME_DATA_DUMMY_RELEASE,
          ANIME_DATA_DUMMY_CURSOR_BLINK,
          ANIME_DATA_DUMMY_CURSOR_SELECT,
          ANIME_DATA_DUMMY_CURSOR_OFF,
          ANIME_DATA_DUMMY_CURSOR_ON,
          ANIME_DATA_NUM,
        }; 


        // Aj[V
        enum AnimeIndex {
          ANIME_DUMMY_ACTIVE,
          ANIME_DUMMY_PASSIVE,
          ANIME_DUMMY_HOLD,
          ANIME_DUMMY_RELEASE,
          ANIME_DUMMY_CURSOR_BLINK,
          ANIME_DUMMY_CURSOR_SELECT,
          ANIME_DUMMY_CURSOR_OFF,
          ANIME_DUMMY_CURSOR_ON,
          // ȉ, LAj
          ANIME_ALT_ACTIVE,
          ANIME_ALT_PASSIVE       = ANIME_ALT_ACTIVE        + MAX_ALT_NUM,
          ANIME_ALT_HOLD          = ANIME_ALT_PASSIVE       + MAX_ALT_NUM,
          ANIME_ALT_RELEASE       = ANIME_ALT_HOLD          + MAX_ALT_NUM,
          ANIME_ALT_CURSOR_BLINK  = ANIME_ALT_RELEASE       + MAX_ALT_NUM,
          ANIME_ALT_CURSOR_SELECT = ANIME_ALT_CURSOR_BLINK  + MAX_ALT_NUM,
          ANIME_ALT_CURSOR_OFF    = ANIME_ALT_CURSOR_SELECT + MAX_ALT_NUM,
          ANIME_ALT_CURSOR_ON     = ANIME_ALT_CURSOR_OFF    + MAX_ALT_NUM,
          ANIME_NUM               = ANIME_ALT_CURSOR_ON     + MAX_ALT_NUM,  // 
          ANIME_NULL,  // l
        };


        // LAjԍ
        enum ShareAnime {
          SHARE_ANIME_ALT_ACTIVE,
          SHARE_ANIME_ALT_PASSIVE,
          SHARE_ANIME_ALT_HOLD,
          SHARE_ANIME_ALT_RELEASE,
          SHARE_ANIME_ALT_CURSOR_BLINK,
          SHARE_ANIME_ALT_CURSOR_SELECT,
          SHARE_ANIME_CURSOR_ON,
          SHARE_ANIME_CURSOR_OFF,
          SHARE_ANIME_NUM,
        }; 


        // LAj[VƂ̐ݒ
        struct ShareAnimeDesc {
          AnimeIndex start_anime_index;                   // o^CfbNX
          AnimeDataIndex anime_data_index;                // L̃Aj[Vԍ
          u32 max_share_num;                              // ő勤L
          gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
          gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
        };


        // IƂ̐ݒ
        struct AlternativeDesc { 
          gfl::grp::g2d::LytPaneIndex window_pane;      // EBhEyC̃CfbNX
          gfl::grp::g2d::LytPaneIndex mask_pane;        // EBhE}XÑyC
          gfl::grp::g2d::LytPaneIndex cursor_pane;      // J[\̃yC
          gfl::grp::g2d::LytPaneIndex label_pane;       // eLXgyC̃CfbNX
          gfl::grp::g2d::LytPaneIndex childicon_pane;   // qj[ACRyC̃CfbNX
          gfl::grp::g2d::LytPaneIndex returnicon_pane;  // ߂ACRyC̃CfbNX
          AnimeIndex active_anime;
          AnimeIndex passive_anime;
          AnimeIndex hold_anime;
          AnimeIndex release_anime;
          AnimeIndex cursor_blink_anime;
          AnimeIndex cursor_select_anime;
          AnimeIndex cursor_on_anime;
          AnimeIndex cursor_off_anime;
        }; 



        static const gfl::grp::g2d::LytWkSetUp LYT_SETUP_DATA;
        static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
        static const ShareAnimeDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
        static const AlternativeDesc ALT_DESC[ MAX_ALT_NUM ]; 
        static const f32 UP_SCALE = 1.3f;  // g̑ĨXP[

        gfl::grp::g2d::LytSys* m_layout_system;
        gfl::grp::g2d::LytWk* m_layout_work;
        gfl::grp::g2d::LytResID m_layout_resource_id;


        void CreateLayoutWork( 
            gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
            gfl::grp::g2d::LytSys* layout_system );
        void DeleteLayoutWork( void );
        void StartAnime( AnimeIndex anime );
        void StopAnime( AnimeIndex anime );

        virtual gfl::grp::g2d::LytWk* GetLayoutWork( void ) const;
        virtual gfl::grp::g2d::LytPaneIndex GetWindowPaneGroup( void ) const;
        virtual gfl::grp::g2d::LytPaneIndex GetWindowPaneIndex( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytWindow* GetWindowPane( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytWindow* GetMaskPane( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytWindow* GetCursorPane( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytTextBox* GetLabelPane( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytPane* GetChildIconPane( u32 alt_index ) const;
        virtual gfl::grp::g2d::LytPane* GetReturnIconPane( u32 alt_index ) const;
        virtual void StartActiveAnime( u32 alt_index );
        virtual void StartPassiveAnime( u32 alt_index );
        virtual void StartHoldAnime( u32 alt_index );
        virtual void StartReleaseAnime( u32 alt_index );
        virtual void StartCursorBlinkAnime( u32 alt_index );
        virtual void StartCursorSelectAnime( u32 alt_index );
        virtual void StartCursorOnAnime( u32 alt_index );
        virtual void StartCursorOffAnime( u32 alt_index );
        virtual void StopActiveAnime( u32 alt_index );
        virtual void StopPassiveAnime( u32 alt_index );
        virtual void StopHoldAnime( u32 alt_index );
        virtual void StopReleaseAnime( u32 alt_index );
        virtual void StopCursorBlinkAnime( u32 alt_index );
        virtual void StopCursorSelectAnime( u32 alt_index );
        virtual void StopCursorOnAnime( u32 alt_index );
        virtual void StopCursorOffAnime( u32 alt_index );
        virtual bool IsReleaseAnimeEnd( u32 alt_index ) const; 
        virtual void ScaleUpAlt( u32 alt_index );
        virtual void ScaleDownAlt( u32 alt_index );

    };


  }  // namespace tool
}  // namespace app 


#endif // __APPTOOL_KAWAIGARIMENUDRAWER_H__
