//========================================================================================
/**
 * @brief j[EBhE`NX( p )
 * @file app_tool_KawaigariMenuDrawer.cpp
 * @author takada_keisuke
 * @date 2012.05.21
 */
//========================================================================================
#include <nw.h>
#include "app_tool_MenuWindowDrawer.h"
#include "app_tool_KawaigariMenuDrawer.h"

#include <arc/arc_def.h>
#include <arc/menu_window.gaix>
#include "menu_app.h"
#include "menu_app_pane.h"
#include "menu_field.h"
#include "menu_field_pane.h"
#include "menu_kawaigari.h"
#include "menu_kawaigari_pane.h"


namespace app {
  namespace tool {



    // CAEg̃ZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp KawaigariMenuDrawer::LYT_SETUP_DATA =
    {
      gfl::math::VEC3(0,0,0),   // pos
      gfl::math::VEC2(1,1),     // scale
      gfl::math::VEC3(0,0,0),   // rotate
      1,                        // priority
    };



    // Ajf[^
    const gfl::grp::g2d::LytArcIndex KawaigariMenuDrawer::ANIME_DATA_TABLE[ ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_ACTIVE */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_ACTIVE_BCLAN,
      /* ANIME_DATA_DUMMY_PASSIVE */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_PASSIVE_BCLAN,
      /* ANIME_DATA_DUMMY_HOLD */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_RELEASE */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_BLINK */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_CURSOR_BLINK_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_SELECT */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_CUROSR_SELECT_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_OFF */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_CURSOR_OFF_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_ON */ LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_DUMMY_CURSOR_ON_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const KawaigariMenuDrawer::ShareAnimeDesc 
      KawaigariMenuDrawer::SHARE_ANIME_DESC[ KawaigariMenuDrawer::SHARE_ANIME_NUM ] =
      {
        /* SHARE_ANIME_ALT_ACTIVE */
        {
          ANIME_ALT_ACTIVE,
          ANIME_DATA_DUMMY_ACTIVE,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_MASK,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_PASSIVE */
        {
          ANIME_ALT_PASSIVE,
          ANIME_DATA_DUMMY_PASSIVE,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_MASK,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_HOLD */
        {
          ANIME_ALT_HOLD,
          ANIME_DATA_DUMMY_HOLD,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_RELEASE */
        {
          ANIME_ALT_RELEASE,
          ANIME_DATA_DUMMY_RELEASE,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_BLINK */
        {
          ANIME_ALT_CURSOR_BLINK,
          ANIME_DATA_DUMMY_CURSOR_BLINK,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_SELECT */
        {
          ANIME_ALT_CURSOR_SELECT,
          ANIME_DATA_DUMMY_CURSOR_SELECT,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_OFF */
        {
          ANIME_ALT_CURSOR_OFF,
          ANIME_DATA_DUMMY_CURSOR_OFF,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_ON */
        {
          ANIME_ALT_CURSOR_ON,
          ANIME_DATA_DUMMY_CURSOR_ON,
          MAX_ALT_NUM,
          PANENAME_MENU_KAWAIGARI_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // IƂ̐ݒ
    const KawaigariMenuDrawer::AlternativeDesc KawaigariMenuDrawer::ALT_DESC[ MAX_ALT_NUM ] = 
    {
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_00,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_00,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_00,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_00,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_00,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_00,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 0 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_01,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_01,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_01,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_01,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_01,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_01,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 1 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_02,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_02,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_02,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_02,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_02,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_02,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 2 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_03,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_03,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_03,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_03,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_03,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_03,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 3 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_04,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_04,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_04,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_04,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_04,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_04,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 4 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_05,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_05,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_05,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_05,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_05,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_05,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 5 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_06,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_06,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_06,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_06,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_06,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_06,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 6 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_07,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_07,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_07,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_07,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_07,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_07,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 7 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_08,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_08,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_08,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_08,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_08,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_08,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 8 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 8 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_09,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_09,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_09,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_09,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_09,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_09,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 9 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 9 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_10,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_10,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_10,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_10,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_10,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_10,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 10 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 10 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_11,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_11,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_11,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_11,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_11,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_11,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 11 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 11 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_12,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_12,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_12,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_12,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_12,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_12,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 12 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 12 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_13,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_13,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_13,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_13,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_13,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_13,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 13 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 13 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_14,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_14,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_14,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_14,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_14,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_14,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 14 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 14 ),
      },
      {
        PANENAME_MENU_KAWAIGARI_PANE_WIN_15,
        PANENAME_MENU_KAWAIGARI_PANE_MASK_15,
        PANENAME_MENU_KAWAIGARI_PANE_CURSOR_15,
        PANENAME_MENU_KAWAIGARI_PANE_LABEL_15,
        PANENAME_MENU_KAWAIGARI_PANE_LEFT_15,
        PANENAME_MENU_KAWAIGARI_PANE_RETURN_15,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 15 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 15 ),
      },
    };








    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap             AvP[Vq[v
     * @param device_heap      foCXq[v
     * @param graphics_system  `ɎgpOtBbNXVXe
     * @param layout_system    `Ɏgp郌CAEgVXe
     */
    //--------------------------------------------------------------------------------
    KawaigariMenuDrawer::KawaigariMenuDrawer( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
        gfl::grp::GraphicsSystem* graphics_system, gfl::grp::g2d::LytSys* layout_system ) :
      MenuWindowDrawer( heap, device_heap, graphics_system ),
      m_layout_system( layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 )
    {
      this->CreateLayoutWork( heap, device_heap, layout_system );
    } 


    /**
     * @brief CAEg[N𐶐
     * @param heap           gpAvP[Vq[v
     * @param device_heap    gpfoCXq[v
     * @param layout_system  CAEgVXe
     */
    void KawaigariMenuDrawer::CreateLayoutWork( 
        gfl::heap::HeapBase* heap, 
        gfl::heap::HeapBase* device_heap,
        gfl::grp::g2d::LytSys* layout_system )
    {
      gfl::heap::NwAllocator nw_device_allocator( device_heap );
      gfl::fs::ArcFile arc_file( heap, ARCID_MENU_WINDOW, gfl::fs::ArcFile::OPEN );
      m_layout_resource_id = layout_system->LoadLytRes( 
          &nw_device_allocator, &arc_file, GARC_menu_window_menu_kawaigari_LYTDAT ); 
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id, LYTRES_MENU_KAWAIGARI_MENU_KAWAIGARI_BCLYT, 
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LYT_SETUP_DATA, false );  // Aj[V̓oChȂ

      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].start_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      } 

      m_layout_work->SetAutoDrawFlag( false );
    }





    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    KawaigariMenuDrawer::~KawaigariMenuDrawer()
    {
      this->DeleteLayoutWork();
    } 

    /**
     * @brief CAEg[Nj
     */
    void KawaigariMenuDrawer::DeleteLayoutWork( void )
    {
      m_layout_system->RemoveLytWk( m_layout_work );
      m_layout_system->ReleaseLytRes( m_layout_resource_id );
    }




    /**
     * @brief CAEg[N擾
     */
    gfl::grp::g2d::LytWk* KawaigariMenuDrawer::GetLayoutWork( void ) const
    {
      return m_layout_work;
    }



    /**
     * @brief EBhEO[vCfbNX擾
     */
    gfl::grp::g2d::LytPaneIndex KawaigariMenuDrawer::GetWindowPaneGroup( void ) const
    {
      return PANENAME_MENU_KAWAIGARI_GROUP_WIN;
    }

    /**
     * @brief EBhẼyCCfbNX擾
     * @param alt_index  ĨCfbNX
     */
    gfl::grp::g2d::LytPaneIndex KawaigariMenuDrawer::GetWindowPaneIndex( u32 alt_index ) const
    {
      return ALT_DESC[ alt_index ].window_pane;
    }



    /**
     * @brief eyC擾
     * @param alt_index  ĨCfbNX
     */
    gfl::grp::g2d::LytWindow* KawaigariMenuDrawer::GetWindowPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].window_pane );
    }

    gfl::grp::g2d::LytWindow* KawaigariMenuDrawer::GetMaskPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].mask_pane );
    }

    gfl::grp::g2d::LytWindow* KawaigariMenuDrawer::GetCursorPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].cursor_pane );
    }

    gfl::grp::g2d::LytTextBox* KawaigariMenuDrawer::GetLabelPane( u32 alt_index ) const
    {
      return m_layout_work->GetTextBoxPane( ALT_DESC[ alt_index ].label_pane );
    }

    gfl::grp::g2d::LytPane* KawaigariMenuDrawer::GetChildIconPane( u32 alt_index ) const
    {
      return m_layout_work->GetPane( ALT_DESC[ alt_index ].childicon_pane );
    }

    gfl::grp::g2d::LytPane* KawaigariMenuDrawer::GetReturnIconPane( u32 alt_index ) const
    {
      return m_layout_work->GetPane( ALT_DESC[ alt_index ].returnicon_pane );
    }



    /**
     * @brief eAjJn
     * @param alt_index  ĨCfbNX
     */
    void KawaigariMenuDrawer::StartActiveAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].active_anime );
    }

    void KawaigariMenuDrawer::StartPassiveAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].passive_anime );
    }

    void KawaigariMenuDrawer::StartHoldAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].hold_anime );
    }

    void KawaigariMenuDrawer::StartReleaseAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].release_anime );
    }

    void KawaigariMenuDrawer::StartCursorBlinkAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_blink_anime );
    }

    void KawaigariMenuDrawer::StartCursorSelectAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_select_anime );
    }

    void KawaigariMenuDrawer::StartCursorOnAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_on_anime );
    }

    void KawaigariMenuDrawer::StartCursorOffAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_off_anime );
    }


    /**
     * @brief eAj~
     * @param alt_index  ĨCfbNX
     */
    void KawaigariMenuDrawer::StopActiveAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].active_anime );
    }

    void KawaigariMenuDrawer::StopPassiveAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].passive_anime );
    }

    void KawaigariMenuDrawer::StopHoldAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].hold_anime );
    }

    void KawaigariMenuDrawer::StopReleaseAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].release_anime );
    }

    void KawaigariMenuDrawer::StopCursorBlinkAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_blink_anime );
    }

    void KawaigariMenuDrawer::StopCursorSelectAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_select_anime );
    }

    void KawaigariMenuDrawer::StopCursorOnAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_on_anime );
    }

    void KawaigariMenuDrawer::StopCursorOffAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_off_anime );
    }




    /**
     * @brief Ig傷
     * @param alt_index  g傷ĨCfbNX
     */
    void KawaigariMenuDrawer::ScaleUpAlt( u32 alt_index )
    { 
#if 0
      gfl::grp::g2d::LytPane* pane =
        m_layout_work->GetPane( ALT_DESC[ alt_index ].window_pane );
      if( !pane ) {
        return;
      }

      gfl::math::VEC2 scale = pane->GetScale(); 
      if( scale.y == 1.0f ) 
      {
        // gÕTCY
        const nw::lyt::Size& small_size = pane->GetSize();

        // g̃TCY
        nw::lyt::Size big_size = small_size;
        big_size.height *= UP_SCALE;

        // yC̒S_ωȂ悤ɒ
        gfl::math::VEC3 pos = pane->GetTranslate();
        pos.y += ( big_size.height - small_size.height ) * 0.5f;
        pane->SetTranslate( pos );

        // g
        scale.y = UP_SCALE;
        pane->SetScale( scale );
      }
#endif
    }

    /**
     * @brief Ik
     * @param alt_index  g傷ĨCfbNX
     */
    void KawaigariMenuDrawer::ScaleDownAlt( u32 alt_index )
    { 
#if 0
      gfl::grp::g2d::LytPane* pane = 
        m_layout_work->GetPane( ALT_DESC[ alt_index ].window_pane );
      if( !pane ) {
        return;
      }

      gfl::math::VEC2 scale = pane->GetScale(); 
      if( scale.y == UP_SCALE ) 
      {
        // kÕTCY
        const nw::lyt::Size& big_size = pane->GetSize();

        // k̃TCY
        nw::lyt::Size small_size = big_size;
        small_size.height /= UP_SCALE;

        // yC̒S_ωȂ悤ɒ
        gfl::math::VEC3 pos = pane->GetTranslate();
        pos.y -= ( big_size.height - small_size.height ) * 0.5f;
        pane->SetTranslate( pos );

        // k
        scale.y = 1.0f;
        pane->SetScale( scale );
      }
#endif
    }



    //-------------------------------------------------------------------------
    /**
     * @brief II΂ꂽۂ̃AjIǂ𒲂ׂ
     * @param alt_index  ICfbNX
     * @retval true   I
     * @retval false  IĂȂ
     */
    //-------------------------------------------------------------------------
    bool KawaigariMenuDrawer::IsSelectAnimeEnd( u32 alt_index ) const
    {
      AnimeIndex anime = ALT_DESC[ alt_index ].cursor_select_anime;
      return !( 
          m_layout_work->IsAnime( anime ) &&
          m_layout_work->IsBindAnime( anime ) &&
          !m_layout_work->IsAnimeEnd( anime ) );
    } 

    /**
     * @brief Aj[VIǂ𒲂ׂ
     * @param alt_index  Ώۂ̑ICfbNX
     * @retval true   I( ܂͊JnĂȂ )
     * @retval false  IĂȂ( Đ )
     */
    bool KawaigariMenuDrawer::IsReleaseAnimeEnd( u32 alt_index ) const
    {
      AnimeIndex anime = ALT_DESC[ alt_index ].release_anime;
      return !( 
          m_layout_work->IsAnime( anime ) &&
          m_layout_work->IsBindAnime( anime ) &&
          !m_layout_work->IsAnimeEnd( anime ) );
    }

    /**
     * @brief Aj[VJn
     * @param anime  JnAj
     */
    void KawaigariMenuDrawer::StartAnime( AnimeIndex anime )
    {
      if( anime < ANIME_NUM ) {
        m_layout_work->BindAnime( anime );
        m_layout_work->SetAutoAnime( anime, true );
        m_layout_work->SetAnimeFrame( anime, 0 );
      }
    }

    /**
     * @brief Aj[V~
     * @param anime  ~Aj
     */
    void KawaigariMenuDrawer::StopAnime( AnimeIndex anime ) 
    {
      if( anime < ANIME_NUM ) {
        m_layout_work->UnBindAnime( anime );
      }
    }





  } // namespace tool
} // namespace app 
