//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_ProcManager.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_ProcManager.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param heap q[v
 * @param data_manager  f[^}l[W[
 * @param graphics  OtBbN}l[W[
 * @param start_proc_id JnPROC_ID
 */
ProcManager::ProcManager( app::util::Heap* heap, DataManager* data_manager, Graphics * graphics, ProcID start_proc_id ) :
  gfl::proc::Manager( heap->GetSystemHeap() ),
  m_heap( heap ),
  m_data_manager( data_manager ),
  m_graphics( graphics ),
  m_next_proc_id( start_proc_id ),
  m_is_end( false )
{
}
/**
 *  @brief  fXgN^
 */
ProcManager::~ProcManager()
{
}


//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void ProcManager::Update(void)
{
  m_status = this->gfl::proc::Manager::Main();

  //PProcIāA\񂪂Ύڂɂ
  if( m_status == gfl::proc::MAINSTATUS_NULL && m_is_end == false )
  {
    if( m_next_proc_id != PROC_ID_NULL )
    {
      IProc *proc = ProcManager::CreateCallProc();
      proc->SetGameProcManager( m_data_manager->GetGameProcManager() );
      this->CallProc( proc );
      m_next_proc_id = PROC_ID_NULL;
      GFL_PRINT( "ProcManagervZX\n", m_next_proc_id );
    }
  }
}


/**
 * @brief `
 */
void ProcManager::Draw(void)
{
  this->gfl::proc::Manager::Draw();
}

/**
 * @brief ProcNĂ邩`FbN
 * @retval  true  NĂȂ
 * @retval  false PłN
 */
bool ProcManager::IsEnd(void) const
{
  return m_is_end && m_status == gfl::proc::MAINSTATUS_NULL;
}

/**
 * @brief sProcݒ
 * @note  ݒ肹ProcIƃAT[gɂȂ܂
 */
void ProcManager::SetNextProc( ProcID proc_id )
{
  GFL_ASSERT( proc_id < PROC_ID_MAX );
  m_next_proc_id = proc_id;
}
/**
 * @brief I(SetNextProcĂĂI܂)
 */
void ProcManager::End( void )
{
  m_is_end = true;
}

//-----------------------------------------------------------------------
// Getter
//-----------------------------------------------------------------------
/**
 * @brief f[^}l[W[擾
 * @retval  f[^}l[W[
 */
DataManager * ProcManager::GetDataManager(void) const
{
  return m_data_manager;
}

/**
 * @brief OtBbN}l[W[擾
 * @retval  OtBbN}l[W[
 */
Graphics * ProcManager::GetGraphics(void) const
{
  return m_graphics;
}

//-----------------------------------------------------------------------
// private
//-----------------------------------------------------------------------
/**
 * @brief vZXNX쐬
 * @retval  vZXNX쐬
 *
 */
IProc * ProcManager::CreateCallProc(void)
{
  switch( m_next_proc_id )
  {
    //vZX@쐬
#undef ZUKAN_PROC_COMMAND
#define ZUKAN_PROC_COMMAND(_x_) case PROC_ID_##_x_: return GFL_NEW(m_heap->GetSystemHeap()) _x_( m_heap, this );
    ZUKAN_PROC_TABLE
  }
  GFL_ASSERT(0);
  return NULL;
}

GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
