//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_Graphics.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_Graphics.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param heap q[v
 * @param graphics_system OtBbNVXe
 */
Graphics::Graphics( app::util::Heap *heap, gfl::grp::GraphicsSystem * graphics_system, gfl::fs::FileReadManager * file_read_manager ) :
  m_heap( heap ),
  m_graphics_system( graphics_system ),
  m_file_read_manager( file_read_manager ),
  m_poke_model_system( NULL ),
  m_poke_model( NULL )
{
}


/**
 *  @brief  fXgN^
 */
Graphics::~Graphics()
{
}


//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 *  @brief  XV
 */
void Graphics::Update( void )
{
  if( m_g3d_util )
  {
    m_g3d_util->CalculateG3dScene();

    m_poke_model_system->UpdateSystem();
    m_poke_model_system->UpdateModel();
    m_poke_model_system->UpdateModelAnime();

    m_g3d_util->Update3D( false );
  }
}


/**
 *  @brief  `
 */
void Graphics::Draw( void )
{
  if( m_g3d_util )
  {
    m_g3d_util->Draw3D( m_graphics_system );
  }
}

//-----------------------------------------------------------------------
// }ӃC|Pf
//-----------------------------------------------------------------------
/**
 *  @brief  |Pf\Ȃ
 *  @param  mons_no 푰ԍ
 *  @param  form_no tHtO
 *  @param  sex   ʃtO
 *  @param  rare  AtO
 */
void Graphics::ChangePokeModel( MonsNo mons_no, pml::FormNo form_no, pml::Sex sex, int is_rare )
{
  if( m_poke_model )
  {
    this->DeletePokeModel();
  }
  this->CreatePokeModel( mons_no, form_no, sex, is_rare );
}

//-----------------------------------------------------------------------
// getter
//-----------------------------------------------------------------------
/**
 *  @brief  OtBbNVXe擾
 *  @retval OtBbNVXe
 */
gfl::grp::GraphicsSystem * Graphics::GetGraphicsSystem(void) const
{
  return m_graphics_system;
}


/**
 *  @brief  t@C[h}l[W[擾
 *  @retval t@C[h}l[W[
 */
gfl::fs::FileReadManager * Graphics::GetFileReadManager(void) const
{
  return m_file_read_manager;
}


/**
 *  @brief  |PfVXe擾
 *  @retval |PfVXe
 */
poke_tool::PokeModelSystem * Graphics::GetPokeModelSystem(void) const
{
  return m_poke_model_system;
}

/**
 *  @brief  |Pf擾
 *  @retval |Pf
 */
poke_tool::PokeModel * Graphics::GetPokeModel(void) const
{
  return m_poke_model;
}

/**
 *  @brief  ^b`o[擾
 *  @retval ^b`o[
 */
Touchbar * Graphics::GetTouchbar(void) const
{
  return m_touchbar;
}

/**
 *  @brief  G3DUtil擾
 *  @retval G3DUtil
 */
app::util::G3DUtil * Graphics::GetG3dUtil(void) const
{
  return m_g3d_util;
}



//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 *  @brief  OtBbNVXeݒ
 */
void Graphics::CreateGraphicsSystem( void )
{
  m_graphics_system->InitializeApplicationMemory( m_heap->GetDeviceAllocator() );
}

/**
 *  @brief  OtBbNVXej
 */
void Graphics::DeleteGraphicsSystem( void )
{
  m_graphics_system->FinalizeApplicationMemory();
}

/**
 *  @brief  3D쐬
 */
void Graphics::Create3d( void )
{
  m_g3d_util  = GFL_NEW( m_heap->GetSystemHeap() ) app::util::G3DUtil();

  m_g3d_util->CreateG3dSystem( m_heap );
  //m_g3d_util->CreateG3dScene( ARCID_POKE3SELECT, GARC_poke3select_res_environment_BCENV_LZ, m_heap, true );
  
  const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
  {
    {
      gfl::math::VEC3(0.0f,0.0f,1.0f),
      gfl::math::VEC3(0.0f,0.0f,0.0f),
      1.0f,
      1000.0f,
      gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
      0.0f,
      gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
      gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
      gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
    },
  };
  m_g3d_util->CreateG3dCamera( m_heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, dat, NULL );

  //m_g3d_util->CreateG3dLight( ARCID_POKE3SELECT, GARC_poke3select_res_Light1_BCENV_LZ, m_heap, true );

  m_g3d_util->CreateEdgeSystem( m_graphics_system, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, m_heap );
  m_g3d_util->SetupG3dScene();

	m_poke_model_system = GFL_NEW( m_heap->GetSystemHeap() ) poke_tool::PokeModelSystem();
	m_poke_model_system->InitSystem( m_heap->GetSystemAllocator(), m_heap->GetDeviceAllocator(), m_file_read_manager );

}

/**
 *  @brief  3Dj
 */
void Graphics::Delete3d( void )
{

  m_poke_model_system->ExitSystem();
	GFL_SAFE_DELETE(m_poke_model_system);
  m_g3d_util->DeleteEdgeSystem();
  m_g3d_util->DeleteG3dCamera();
  m_g3d_util->DeleteG3dScene();
  m_g3d_util->DeleteG3dSystem();

  GFL_SAFE_DELETE( m_g3d_util );
}

/**
 *  @brief  |Pj
 */
void Graphics::CreatePokeModel( MonsNo mons_no, pml::FormNo form_no, pml::Sex sex, int is_rare )
{
  poke_tool::PokeModel::SimpleParam simple_model;
  simple_model.monsNo = mons_no;
  simple_model.formNo = form_no;
  simple_model.sex  = sex;
  simple_model.isRare = is_rare;

  m_poke_model = m_poke_model_system->CreateModelSimple( &simple_model, m_heap->GetSystemAllocator(), m_heap->GetDeviceAllocator()  );

  m_poke_model->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

  proj::motion::BaseMotionCharacter* motion_data = m_poke_model->GetMotionData();
  if( motion_data ) {
    motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
  }
  //m_poke_model->SetPosition( poke_model_start_position[i].x, poke_model_start_position[i].y, poke_model_start_position[i].z );
  m_poke_model->ChangeAnime( poke_tool::MODEL_ANIME_KW_WAIT );
  m_poke_model->PlayAnime();

  //m_poke_model->SetScale( poke_model_start_position[i].scale );
  xy_system::PokemonShaderModel* shader_model = m_poke_model->GetShaderModel();
  shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
  shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 

  m_poke_model->AddScene( m_g3d_util->GetScene() );
}

/**
 *  @brief  |Pj
 */
void Graphics::DeletePokeModel( void )
{
  m_poke_model->RemoveScene( m_g3d_util->GetScene() );
  m_poke_model_system->DeleteModel( m_poke_model );
  m_poke_model = NULL;
}


GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
