//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		colosseum_main.cpp
 *	@brief  RVAAveXgp C
 *	@author	Katsuhiko=Ichiraku
 *	@date		2012.04.20
 *
 * namespace	app::colosseum
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "colosseum_main.h"
#include "field/event/EventVoiceTestCall.h"

// mine

GFL_NAMESPACE_BEGIN( app )
GFL_NAMESPACE_BEGIN( colosseum )

//=============================================================================
/**
 *      }N`
 */
//=============================================================================

//=============================================================================
/**
 *      ֐`
 */
//=============================================================================
//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 *
 *	@param	  p_param   Oݒp[^
 */
//-----------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM *p_param )
{
  m_view      = NULL;
  m_isFinish  = false;
  m_appParam  = p_param;
	m_fadeNextSeq = MAINSEQ_INIT;

  SetMainSequence( MAINSEQ_INIT );
}

//----------------------------------------------------------------------------
/**
 *	@brief    fXgN^
 */
//-----------------------------------------------------------------------------

MainSystem::~MainSystem( void )
{
  DeleteSubWork( );
}

//----------------------------------------------------------------------------
/**
 *	@brief    Abvf[g
 *
 *	@retval   TRUE:쒆
 *	@retval   FALSE:I
 */
//-----------------------------------------------------------------------------

bool MainSystem::Update( void )
{
  bool isRunning = DoSequenceProcess( );

  if( m_view != NULL &&
					m_seq == MAINSEQ_MAIN )
  {
    m_view->Update( );
  }

  return isRunning;
}

//----------------------------------------------------------------------------
/**
 *	@brief    `揈
 */
//-----------------------------------------------------------------------------

void MainSystem::Draw( void )
{
  if( m_view != NULL &&
          m_seq == MAINSEQ_MAIN )
  {
    m_view->Draw( );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  yCCxǧm
 *
 *	@param	paneId  ʒm󂯂yCID
 *
 * @return t[ł̑̓CxgȂtrueA
 *         ̃CxgrȂfalseԋp邱ƁB
 */
//-----------------------------------------------------------------------------

bool MainSystem::OnLayoutPaneEvent( const u32 paneId )
{
  // Aj͑얳I
  if( !IsEnableInput( ) )
  {
    return true;
  }
  GraphicWork::RESPONSE_PANE_ID response = GraphicWork::ChangePaneID2ResponseID( paneId );

  // ߂
  if( GraphicWork::RESPONSE_PANE_RETURN == response )
  {
    GoToBeforePage( );
    return false;
  }

  // y[W
  switch( m_view->GetCurrentPage( ) ){
  case GraphicWork::COLOSSEUM_PAGE_ID_TOP: ///< RVATOPy[W
    DoTopPageAction( response );
    return false;

  case GraphicWork::COLOSSEUM_PAGE_ID_SELECT_BOX:     ///< 키|PI
    DoSelectBoxPageAction( response );
    return false;

  case GraphicWork::COLOSSEUM_PAGE_ID_SELECT_POS:     ///< 키ꏊI(}`̂)
    DoSelectPosPageAction( response );
    return false;
  }
  return true;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief yCCxǧm
 *
 * @param  painId   ʒm󂯂yChc
 *
 * @return t[ł̑̓CxgȂtrueA
 *         ̃CxgrȂfalseԋp邱ƁB
 */
//--------------------------------------------------------------------------------------------
// @overwride

bool MainSystem::OnLayoutPaneLongPressEvent( const u32 painId )
{
  return true;
}

//----------------------------------------------------------------------------
/**
 *	@brief  L[͂̌m
 *
 *	@param	pKey    \L[
 *	@param	pStick  AiOXeBbN
 *
 * @return t[ł̑̓CxgȂtrueA
 *         ̃CxgrȂfalseԋp邱ƁB
 */
//-----------------------------------------------------------------------------
// @overwride

bool MainSystem::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick )
{
  // Aj͑얳I
  if( !IsEnableInput( ) )
  {
    return true;
  }

  if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    GoToBeforePage( );
    return false;
  }
  return true;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ^b`plCxǧm
 *
 *	@param	pTouchPanel ^b`pl
 *	@param	isTouch     ^b`ĂȂtrue, ȂȂfalse
 *
 * @return t[ł̑̓CxgȂtrueA
 *         ̃CxgrȂfalseԋp邱ƁB
 */
//-----------------------------------------------------------------------------
// @overwride

bool MainSystem::OnTouchEvent( gfl::ui::TouchPanel* pTouchPanel, bool isTouch )
{
  return true;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ^b`pl̃_uNbNCxǧm
 *
 *	@param	pTouchPanel ^b`pl
 *
 * @return t[ł̑̓CxgȂtrueA
 *         ̃CxgrȂfalseԋp邱ƁB
 */
//-----------------------------------------------------------------------------
// @overwride

bool MainSystem::OnDoubleClickEvent( gfl::ui::TouchPanel * pTouchPanel )
{
  return true;
}

//----------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 */
//----------------------------------------------------------------------------

void MainSystem::CreateSubWork( void )
{
  m_heap.Create( HEAPID_COLOSSEUM_APP, COLOSSEUM_APP_HEAP_SIZE, HEAPID_COLOSSEUM_DEVICE, COLOSSEUM_DEVICE_HEAP_SIZE );


  const bool isMultiBattle = ( m_appParam->m_ruleSetting.m_battleType == app::pss::pss_rule_select::BATTLE_TYPE_MULTI );
  m_view = GFL_NEW( m_heap.pHeap ) GraphicWork( &m_heap, isMultiBattle );
  m_view->SetInputListener( this );

  // RVAAvpʐM쐬
  {
#ifdef DEBUG_TEST
    // o^Ă邩
    m_isTest = m_appParam->isTest;
    ICHI_PRINT( "isTest %d \n", m_isTest );

    if( m_isTest == false )
#endif
    {
      // ʐMݒ
      gflnet::p2p::GameInitialize initialize;
      initialize.max          = 2;            // ڑMAX  4ł̂?
      initialize.pHeapSystem  = m_heap.pHeap; // ʐMŎgq[v
      // NetGameNX쐬
      m_netHandle = GFL_NEW( m_heap.pHeap ) gflnet::p2p::NetGame( &initialize, NULL );
      m_netHandle->Initialize( );

      ICHI_PRINT( "ʐMpnh쐬\n" );
    }
  }
}

//----------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 */
//----------------------------------------------------------------------------

void MainSystem::DeleteSubWork( void )
{
#ifdef DEBUG_TEST
  if( m_isTest == false )
#endif
  {
    m_netHandle->Finalize( );
    GFL_SAFE_DELETE( m_netHandle );
    ICHI_PRINT( "ʐMpnhj\n" );
  }
  GFL_SAFE_DELETE( m_view );
  m_heap.Delete( );
}

//----------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//----------------------------------------------------------------------------

void MainSystem::SetFadeIn( ENUM_MAINSEQ next )
{
  //gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
  //gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
  gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, COLOSSEUM_FADE_SYNC );
  m_fadeNextSeq = next;
  SetMainSequence( MAINSEQ_FADE );
}


//----------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//----------------------------------------------------------------------------

void MainSystem::SetFadeOut( ENUM_MAINSEQ next )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, COLOSSEUM_FADE_SYNC, false );
  m_fadeNextSeq = next;
  SetMainSequence( MAINSEQ_FADE );
}

//----------------------------------------------------------------------------
/**
 *	@brief    Oʂɖ߂
 */
//-----------------------------------------------------------------------------

void MainSystem::GoToBeforePage( void )
{
  // @todo 
  //
  switch( m_view->GetCurrentPage( ) ){
  case GraphicWork::COLOSSEUM_PAGE_ID_TOP:
    m_isFinish = true;
    m_appParam->m_resultCode = COLOSSEUM_RESULT_CANCEL;
    ICHI_PRINT( "TOPy[WŖ߂\n" );
    break;
  case GraphicWork::COLOSSEUM_PAGE_ID_SELECT_BOX:     ///< 키|PI
		m_view->ChangeTopPage_FromSelectBox();
    ICHI_PRINT( "|Py[WŖ߂\n" );
		break;
  case GraphicWork::COLOSSEUM_PAGE_ID_SELECT_POS:     ///< 키ꏊI(}`̂)
		m_view->ChangeTopPage_FromSelectPos();
    ICHI_PRINT( "ꏊy[WŖ߂\n" );
		break;
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  L[́E^b`̌m
 *
 *	@retval TRUE:m
 *	@retval FALSE:m֎~
 */
//-----------------------------------------------------------------------------

bool MainSystem::IsEnableInput( void )
{
  // Aj͑얳I
  return !( ( m_view == NULL ) || !m_view->IsAnimeEnd( ) );
}

//----------------------------------------------------------------------------
/**
 *	@brief  TOPy[WANVCxg
 *
 *	@param	targetPainID  ʒm󂯂yCID
 */
//-----------------------------------------------------------------------------

void MainSystem::DoTopPageAction( GraphicWork::RESPONSE_PANE_ID targetPainID )
{
  // @todo
  // Ƃ肠肾
  //
  switch( targetPainID ){
    // 
  case GraphicWork::RESPONSE_PANE_TOP_DECIDE:
#ifdef DEBUG_TEST
    if( m_isTest == false )
#endif
		{
			// |Pꗗ
      m_view->UpdateSelectBoxPokemon( m_appParam->m_pPokeParty );
      m_view->UpdateSelectBoxPokemon( m_appParam->m_pBattleBox );
		}

    m_view->ChangePage_SelectBox( );

    ICHI_PRINT( "|P\n" );
    break;

    // ꏊ
  case GraphicWork::RESPONSE_PANE_TOP_SELECT_POS:
    m_view->ChangePage_SelectPos( );
    ICHI_PRINT( "ꏊ\n" );
    break;

    // |PXg
  case GraphicWork::RESPONSE_PANE_TOP_POKELIST:
    m_isFinish = true;
    m_appParam->m_resultCode = COLOSSEUM_RESULT_POKELIST;
    ICHI_PRINT( "|PXg\n" );
    break;

    // obO
  case GraphicWork::RESPONSE_PANE_TOP_BAG:
    m_isFinish = true;
    m_appParam->m_resultCode = COLOSSEUM_RESULT_BAG;
    ICHI_PRINT( "obO\n" );
    break;

  default:
    return;
  }
}

/**
 * @breif	 |PIy[WANVCxg
 * @param targetPainID		ʒm󂯂yCID
 */
void MainSystem::DoSelectBoxPageAction( GraphicWork::RESPONSE_PANE_ID targetPainID )
{
  switch( targetPainID ){
  case GraphicWork::RESPONSE_PANE_SELECT_BOX_PARTY: // Ă
    // f[^Ăݒɂ
    m_appParam->m_resultBox = COLOSSEUM_BOX_PARTY;
		ICHI_PRINT("ĂݒɕύX\n");
    break;

  case GraphicWork::RESPONSE_PANE_SELECT_BOX_BTLBOX: // og{bNX
    // f[^og{bNXݒɂ
    m_appParam->m_resultBox = COLOSSEUM_BOX_BTLBOX;
		ICHI_PRINT("og{bNXݒɕύX\n");
    break;

  default:
    return;
  }

  // @todo NG`FbNNG̏ꍇ͎ɈڍsȂ 
  m_isFinish = true;
  m_appParam->m_resultCode = COLOSSEUM_RESULT_DECIDE;

  ICHI_PRINT( "|Py[WŌ\n" );
}

/**
 * @breif	 ꏊIy[WANVCxg
 * @param targetPainID		ʒm󂯂yCID
 */
void MainSystem::DoSelectPosPageAction( GraphicWork::RESPONSE_PANE_ID targetPainID )
{
  /*
  switch( targetPainID ){
  default:
    return;
  }
  */

  // TOPy[Wɖ߂Aj
	m_view->ChangeTopPage_FromSelectPos();
	ICHI_PRINT( "ꏊy[WŖ߂\n" );

  //@todo {^\؂ւ
}

//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXݒ
 *
 *	@param	seq   ؂ւΏۃV[PX
 */
//-----------------------------------------------------------------------------

void MainSystem::SetMainSequence( ENUM_MAINSEQ seq )
{
  this->m_seq = seq;
}

//----------------------------------------------------------------------------
/**
 *	@brief  V[PXʃvZX
 *
 *	@retval true:
 *	@retval false:ȊO
 */
//-----------------------------------------------------------------------------

bool MainSystem::DoSequenceProcess( void )
{
  switch( m_seq ){
  case MAINSEQ_INIT:  ///< 
    MainSeq_Init( );
    break;

  case MAINSEQ_ISINIT:  ///< ҂
    MainSeq_IsInit( );
    break;

  case MAINSEQ_FADE:    ///< tF[h
    MainSeq_Fade( );
    break;

  case MAINSEQ_MAIN:    ///< C
    MainSeq_Main( );
    break;

  case MAINSEQ_RELEASE: ///< j
    MainSeq_Release( );
    break;

  case MAINSEQ_END: ///< I
    return false;
  }
  return true;
}

//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXF
 */
//-----------------------------------------------------------------------------

void MainSystem::MainSeq_Init( void )
{
  CreateSubWork( );

#ifdef DEBUG_TEST
  if( m_isTest == false )
#endif
	{
		m_view->UpdateSelectBoxPokemon( m_appParam->m_pPokeParty );
	}

#ifdef DEBUG_TEST
  if( m_isTest == false )
#endif
  {
    SetMainSequence( MAINSEQ_ISINIT );
  }
#ifdef DEBUG_TEST
  else
  {
    SetFadeIn( MAINSEQ_MAIN );
  }
#endif
  ICHI_PRINT( "V[PX\n" );
}

//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXF
 */
//-----------------------------------------------------------------------------

void MainSystem::MainSeq_IsInit( void )
{
  if( m_netHandle->IsInitialize( ) == true )
  {
    {
      ICHI_PRINT( "RlNVl %d \n", m_netHandle->GetConnectionCount( ) );
      ICHI_PRINT( "NetID %d \n", m_netHandle->GetNetID( ) );
    }

    SetMainSequence( MAINSEQ_MAIN );
    ICHI_PRINT( "ʐM҂V[PX\n" );
  }
}
//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXF
 */
//-----------------------------------------------------------------------------

void MainSystem::MainSeq_Release( void )
{
  //DeleteSubWork();
  SetMainSequence( MAINSEQ_END );
  ICHI_PRINT( "V[PX\n" );
}

//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXFtF[h҂
 */
//-----------------------------------------------------------------------------

void MainSystem::MainSeq_Fade( void )
{
  if( gfl::grp::Fade_IsEnd( ) == true )
  {
    SetMainSequence( m_fadeNextSeq );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  CV[PXFC
 */
//-----------------------------------------------------------------------------

void MainSystem::MainSeq_Main( void )
{
  m_view->SetInputEnabled( m_view->IsAnimeEnd( ) );

  if( m_isFinish ||
          GFL_SINGLETON_INSTANCE( gamesystem::ForcedReturnManager )->IsReturn( gamesystem::ForcedReturnManager::FORCERETURN_APP ) )
  {
    m_view->SetInputEnabled( false );

    // I
    SetFadeOut( MAINSEQ_RELEASE );
		ICHI_PRINT("ItF[hAEg\n");
  }
}

GFL_NAMESPACE_END( colosseum )
GFL_NAMESPACE_END( app )


