//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		colosseum_graphic.cpp
 *	@brief  RVAAveXgp OtBbN
 *	@author	Katsuhiko=Ichiraku
 *	@date		2012.04.20
 *
 * namespace	app::colosseum
 *
 * 5279-6982    Avpev[gt@C쐬ꂽƂp^O
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// system
#include <gflib.h>
#include <pmlib.h>
#include <grp/util/gfl_UtilDrawUtil.h>
#include <pml_PokeParty.h>

// resource
#include <arc/arc_def.h>
#include <arc/fieldmenu_pss_tex.gaix>
#include "field/subscreen/pss/fieldmenu_pss_matching.h"
#include "field/subscreen/pss/fieldmenu_pss_matching_pane.h"
#include "colosseum_res.h"
#include "colosseum_res_pane.h"

// msg
#include "arc/message.gaix"
#include <arc/fieldmenu_pss_tex.gaix>
#include <message/msg_pss_message.h>

// mine
#include "colosseum_graphic.h"
#include "common_res/poke_icon.h"

// mine
GFL_NAMESPACE_BEGIN( app )
GFL_NAMESPACE_BEGIN( colosseum )

//=============================================================================
/**
 *        f[^`
 */
//=============================================================================


// Ajf[^()
static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[] ={
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_A_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_A_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_B_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_B_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_B_IN2_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_B_OUT2_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_C_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_C_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_D_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_D_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_E_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_E_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_F_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_F_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_G_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_G_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_H_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_H_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_I_IN_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_I_OUT_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_J_ON1_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_J_ON2_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_J_ON3_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_K_ON_BCLAN,
  LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_TYPE_K_OFF_BCLAN,
};

// Ajf[^()
static const gfl::grp::g2d::LytArcIndex UpperAnmIndex[] ={
  LYTRES_COLOSSEUM_RES_PSS_COLOSSEUM_UPPER_1VS1_BCLAN,
  LYTRES_COLOSSEUM_RES_PSS_COLOSSEUM_UPPER_2VS2_BCLAN,
};

//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------
/// TOP
static const app::ui::ButtonInfo BUTTON_PANE_F[] ={
  // RVAgbv

  ///< |PXg
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_1,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_1,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< obO
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_2,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_2,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< Jn
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_3,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_3,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },

  // RVAgbv(}`)

  ///< 키ꏊI
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_1,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_1,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< |PXg
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_2,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_2,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< obO
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_3,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_3,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< Jn
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_4,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_4,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  // ߂
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
};

// 키|PI
static const app::ui::ButtonInfo BUTTON_PANE_H[] ={
  ///< og{bNX
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_0,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_0,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  ///< 莝
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_1,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_1,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
  // ߂
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
};

// 키ꏊI
static const app::ui::ButtonInfo BUTTON_PANE_I[] ={
  // ߂
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// picture_pane
    PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND,		// bound_pane
    app::tool::ButtonManager::ANIMATION_NULL,				// hold_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// release_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// select_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// active_anime_index
    app::tool::ButtonManager::ANIMATION_NULL,				// passive_anime_index
  },
};

// {^j[pyC
static const app::ui::ButtonInfo* BUTTON_PANE_LIST[ GraphicWork::COLOSSEUM_PAGE_ID_MAX ] ={
  BUTTON_PANE_F,  ///< RVATOP
  BUTTON_PANE_H,  ///< 키|PI
  BUTTON_PANE_I,  ///< 키ꏊI
};

//{^j[pyC̃oEh{bNX
static const u32 BUTTON_PANE_BOUNDBOX_NUM[GraphicWork::COLOSSEUM_PAGE_ID_MAX ] ={
  ( sizeof (BUTTON_PANE_F ) / sizeof (app::ui::ButtonInfo ) ),
  ( sizeof (BUTTON_PANE_H ) / sizeof (app::ui::ButtonInfo ) ),
  ( sizeof (BUTTON_PANE_I ) / sizeof (app::ui::ButtonInfo ) ),
};


//-----------------------------------------------------------------------------
/**
 *				|PpyC\
 */
//-----------------------------------------------------------------------------

typedef struct
{
  gfl::grp::g2d::LytPaneIndex		poke;			///< |PACR
  gfl::grp::g2d::LytPaneIndex		item;			///< ACeACR
  gfl::grp::g2d::LytPaneIndex		lv;				///< LvACR
  gfl::grp::g2d::LytPaneIndex		lv_val;		///< x
  gfl::grp::g2d::LytPaneIndex		sex;			///< 
} POKEMON_PANE;

static const POKEMON_PANE PokePane[] ={
	// og{bNXp
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_00,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_00,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_00,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_00,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_00,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_01,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_01,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_01,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_01,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_01,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_02,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_02,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_02,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_02,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_02,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_03,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_03,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_03,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_03,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_03,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_04,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_04,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_04,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_04,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_04,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_05,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_05,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_05,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_05,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_05,
  },
	// 莝p
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_06,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_06,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_06,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_06,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_06,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_07,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_07,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_07,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_07,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_07,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_08,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_08,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_08,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_08,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_08,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_09,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_09,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_09,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_09,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_09,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_10,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_10,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_10,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_10,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_10,
  },
  {
    PANENAME_PSS_BATTLE_LOWER_PANE_POKE_ICON_11,
    PANENAME_PSS_BATTLE_LOWER_PANE_ITEM_ICON_11,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_ICON_11,
    PANENAME_PSS_BATTLE_LOWER_PANE_LEVEL_11,
    PANENAME_PSS_BATTLE_LOWER_PANE_SEIBETU_11,
  },
};

//=============================================================================
/**
 *        ֐`
 */
//=============================================================================
//----------------------------------------------------------------------------
/**
 * @brief   RXgN^
 *
 *	@param	  heap        q[v
 *	@param    layout      CAEgVXeBNULLȂVK쐬
 *  @param    messageData p郁bZ[Wf[^BNULLȂVK쐬
 *  @param    wordset     p郏[hZbgBNULLȂVK쐬
 *  @param    info        QƂݒ
 */
//----------------------------------------------------------------------------

GraphicWork::GraphicWork( app::util::Heap *heap, const bool isMultiBattle ) : app::ui::UIView( heap )
{
  //m_setting     = info;
  m_currentPage = COLOSSEUM_PAGE_ID_TOP;
  m_isSetAnime  = false;
  m_heap        = heap;
  m_isMultiBattle = isMultiBattle;

#ifdef PM_DEBUG
  if( m_isMultiBattle == true ) GFL_PRINT( "}`[h" );
  else													GFL_PRINT( "VO[h" );
#endif

  CreateGraphicsSystem( heap );
  Initialize2D( heap );


  // {^}l[W
  u32        paneNum;
  const app::ui::ButtonInfo* boundboxList = GetBoundboxPaneList( COLOSSEUM_PAGE_ID_TOP, &paneNum );
  CreateButtonManager( heap, GetLayoutWork( COLOSSEUM_LAYOUT_ID_LOWER ), boundboxList, paneNum );

  // eLXgyC̏
  InitTextPane();

  // }`Ή
  if( IsMultiBattle() == true )
  {
    StartAnime( E_ANMID_COLOSSEUM_MULTI_IN );
    StartUpperAnime( E_ANMID_2V2 );
  }
  else
  {
    StartAnime( E_ANMID_COLOSSEUM_2VS2_IN );
    StartUpperAnime( E_ANMID_1V1 );
  }

  // @todo
  // og{bNXȂꍇ͂|P\Ȃ
}

//----------------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//----------------------------------------------------------------------------

GraphicWork::~GraphicWork( void )
{
  this->Finalize2D();
  DeleteGraphicsSystem();
}

//----------------------------------------------------------------------------
/**
 * @brief   Abvf[g
 *
 * @param   none
 *
 * @return  none
 */
//----------------------------------------------------------------------------

void GraphicWork::Update( void )
{
  app::ui::UIView::Update();

  if( m_isSetAnime )
  {
    if( IsAnimeEnd() )
    {
      StartAnime( m_nextAnime );
      m_isSetAnime = false;
    }
  }
}

//----------------------------------------------------------------------------
/**
 * @brief   `
 *
 * @param   none
 *
 * @return  none
 */
//----------------------------------------------------------------------------

void GraphicWork::Draw( void )
{
  m_g2dUtil->Draw2D( m_graphicSystem, COLOSSEUM_LAYOUT_ID_UPPER );
  m_g2dUtil->Draw2D( m_graphicSystem, COLOSSEUM_LAYOUT_ID_LOWER );
}

//----------------------------------------------------------------------------
/**
 *	@brief  Aj[V̊Jn
 *
 *	@param	animeId   Aj[VID
 */
//-----------------------------------------------------------------------------

void GraphicWork::StartUpperAnime( u32 animeId )
{
  m_g2dUtil->StopAnime( COLOSSEUM_LAYOUT_ID_UPPER, animeId, false );
  m_g2dUtil->StartAnime( COLOSSEUM_LAYOUT_ID_UPPER, animeId );
}

//----------------------------------------------------------------------------
/**
 *	@brief  Aj[V̊Jn
 *
 *	@param	animeId   Aj[VID
 */
//-----------------------------------------------------------------------------

void GraphicWork::StartAnime( u32 animeId )
{
  m_currentAnime = animeId;
  m_g2dUtil->StopAnime( COLOSSEUM_LAYOUT_ID_LOWER, animeId, false );
  m_g2dUtil->StartAnime( COLOSSEUM_LAYOUT_ID_LOWER, animeId );
}

//----------------------------------------------------------------------------
/**
 *	@brief  Aj[V̊Jn
 *
 *	@param	startAnimeId  JnAj[VID
 *	@param	nextAnimeId   ɊJnAj[VID
 */
//-----------------------------------------------------------------------------

void GraphicWork::StartAnime( u32 startAnimeId, u32 nextAnimeId )
{
  m_nextAnime   = nextAnimeId;
  m_isSetAnime  = true;

  StartAnime( startAnimeId );
}


//----------------------------------------------------------------------------
/**
 *	@brief  yCAj[V̏I
 *
 *	@retval TRUE:AjI
 *	@retval FALSE:Aj
 */
//-----------------------------------------------------------------------------

bool GraphicWork::IsAnimeEnd( void )
{
  return m_g2dUtil->IsAnimeEnd( COLOSSEUM_LAYOUT_ID_LOWER, m_currentAnime );
}

//----------------------------------------------------------------------------
/**
 *	@brief  키|PIy[Wւ̐؂ւ
 */
//-----------------------------------------------------------------------------

void GraphicWork::ChangePage_SelectBox( void )
{
  // }`Ή
  u32 animeId = IsMultiBattle() == true ? E_ANMID_COLOSSEUM_MULTI_OUT : E_ANMID_COLOSSEUM_2VS2_OUT;

  StartAnime( animeId, E_ANMID_SELECT_BOX_IN );

  // y[W
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_MSG_BAR_TEXT0,  msg_pss_03_11_01 );  // |P

  SetCurrentPage( COLOSSEUM_PAGE_ID_SELECT_BOX );
}

//----------------------------------------------------------------------------
/**
 *	@brief  키ꏊIy[Wւ̐؂ւ
 */
//-----------------------------------------------------------------------------

void GraphicWork::ChangePage_SelectPos( void )
{
  // }`Ή
  StartAnime( E_ANMID_COLOSSEUM_MULTI_OUT, E_ANMID_SELECT_POSITION_IN );

  // y[W
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_MSG_BAR_TEXT0,  msg_pss_03_12_01 );  // ΂

  SetCurrentPage( COLOSSEUM_PAGE_ID_SELECT_POS );
}

/**
 * @brief 키|PIy[WTOPy[Wւ̐؂ւ
 */
void GraphicWork::ChangeTopPage_FromSelectBox( void )
{
  // }`Ή
  u32 animeId = IsMultiBattle() == true ? E_ANMID_COLOSSEUM_MULTI_IN : E_ANMID_COLOSSEUM_2VS2_IN;

  StartAnime( E_ANMID_SELECT_BOX_OUT, animeId );

  // y[W
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_MSG_BAR_TEXT0,  msg_pss_03_10_01 );  // RVA

  SetCurrentPage( COLOSSEUM_PAGE_ID_TOP );
}

/**
 * @brief 키ꏊIy[WTOPy[Wւ̐؂ւ
 */
void GraphicWork::ChangeTopPage_FromSelectPos( void )
{
  // }`Ή
  u32 animeId = IsMultiBattle() == true ? E_ANMID_COLOSSEUM_MULTI_IN : E_ANMID_COLOSSEUM_2VS2_IN;

  StartAnime( E_ANMID_SELECT_POSITION_OUT, animeId );

  // y[W
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_MSG_BAR_TEXT0,  msg_pss_03_10_01 );  // RVA

  SetCurrentPage( COLOSSEUM_PAGE_ID_TOP );
}

//----------------------------------------------------------------------------
/**
 * @brief |Pꗗ̍XV 
 * @param p_pokeParty		莝|P
 */
//----------------------------------------------------------------------------

void GraphicWork::UpdateSelectBoxPokemon( const pml::PokeParty* p_pokeParty )
{
  u32 cnt = p_pokeParty->GetMemberCount();	// 莝擾
  int i;
	const int diff = 6;		// 0IWł͂Ȃ̂

  // 莝\
  // @note WBł̓^}S\Ă̂ŕ\
  for ( i = 0; i < cnt; i++ )
  {
    const pml::pokepara::PokemonParam *pp = p_pokeParty->GetMemberPointerConst( i );

    SetPokemon( i, i + diff, pp );
  }
  for ( ; i < pml::PokeParty::MAX_MEMBERS; i++ )
  {
    // \
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i + diff].poke, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i + diff].item, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i + diff].lv, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i + diff].lv_val, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i + diff].sex, false );
  }

  ICHI_PRINT( "莝\ %d\n", cnt );
}

//----------------------------------------------------------------------------
/**
 * @brief |Pꗗ̍XV 
 * @param p_battleBox		og{bNX
 */
//----------------------------------------------------------------------------

void GraphicWork::UpdateSelectBoxPokemon( const savedata::BattleBox* p_battleBox )
{
  u32 cnt = 0;
  int i;

  // 莝\
  // @note WBł̓^}S\Ă̂ŕ\
  for ( i = 0; i < cnt; i++ )
  {
    //const pml::pokepara::PokemonParam *pp = p_pokeParty->GetMemberPointerConst(i);

    //SetPokemon( i, i, pp );
  }
  for ( ; i < pml::PokeParty::MAX_MEMBERS; i++ )
  {
    // \
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i].poke, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i].item, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i].lv, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i].lv_val, false );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[i].sex, false );
  }

  ICHI_PRINT( "og{bNX\\n" );
}

/**
 * @brief 키ꏊ̃{^eLXgXV
 */
void GraphicWork::UpdateSelectPosButtonText( void )
{


}


//----------------------------------------------------------------------------
/**
 * @brief   Jgy[W̎擾
 *
 * @param   none
 *
 * @return  page ݒ肳Ăy[WID
 */
//----------------------------------------------------------------------------

GraphicWork::COLOSSEUM_PAGE_ID GraphicWork::GetCurrentPage( void )
{
  return m_currentPage;
}

//----------------------------------------------------------------------------
/**
 *	@brief  CAEgGfB^̃yCIDGraphicWork::RESPONSE_PANE_ID֕ϊ
 *
 *	@param	paneId  CAEgGfB^̃yCID
 *
 *	@return RESPONSE_PANE_ID
 */
//-----------------------------------------------------------------------------

GraphicWork::RESPONSE_PANE_ID GraphicWork::ChangePaneID2ResponseID( u32 paneId )
{
  switch( paneId ){
  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_1:
    return RESPONSE_PANE_TOP_SELECT_POS; ///< 키ꏊ(}`̂)

  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_1:
  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_2:
    return RESPONSE_PANE_TOP_POKELIST;   ///< |PXg

  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_2:
  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_3:
    return RESPONSE_PANE_TOP_BAG;        ///< obO

  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_F_3:
  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_G_4:
    return RESPONSE_PANE_TOP_DECIDE;     ///< Jn
    //
  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_0:
    return RESPONSE_PANE_SELECT_BOX_BTLBOX; ///< og{bNX

  case PANENAME_PSS_BATTLE_LOWER_PANE_BAR_BOUND_H_1:
    return RESPONSE_PANE_SELECT_BOX_PARTY;  ///< 莝
    //
  case PANENAME_PSS_BATTLE_LOWER_PANE_RETURN_BOUND:
    return RESPONSE_PANE_RETURN;         ///< ߂

  default:
    return RESPONSE_UNKNOWN;
  }
}

//----------------------------------------------------------------------------
/**
 * @brief   2D֘A쐬
 *
 * @param   heap    q[v
 *
 * @return  none
 */
//----------------------------------------------------------------------------

void GraphicWork::Initialize2D( app::util::Heap * heap )
{
  // A[JCuIDe[u
  static const gfl::fs::ArcFile::ARCID arcTbl[] = {
    ARCID_COLOSSEUM,				// 00: RVAʂ̃\[X
    ARCID_PSS_MATCHING,			// 01: ʃ\[X

    ARCID_COMMON_MSGWINDOW,	// 02: ʃ\[XF@bZ[WEBhE
    ARCID_COMMON_POKELIST,	// 03: ʃ\[XF@|PXg
  };

  // CAEgf[^
  static const app::util::G2DUtil::LYTWK_DATA layoutData[] ={
    { // 
      0,
      LYTRES_COLOSSEUM_RES_PSS_COLOSSEUM_UPPER_BCLYT,     // resID̃CAEgf[^ID
      UpperAnmIndex,                      // Aj[Vf[^IDe[u AĵȂꍇNULL
      GFL_NELEMS( UpperAnmIndex ),          // Aj[Vf[^IDe[u AĵȂꍇ0
      GFL_NELEMS( UpperAnmIndex ),          // o^Aj[Vő吔
      false,                              // \yCɍsvZs
      app::util::G2DUtil::SETUP_UPPER,    // fBXvC
      true,                               // \ݒ
    },
    {	// 
      1,
      LYTRES_FIELDMENU_PSS_MATCHING_PSS_BATTLE_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS( LowerAnmIndex ),
      GFL_NELEMS( LowerAnmIndex ),
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };


  Create2D( heap, NULL, COLOSSEUM_LAYOUT_ID_MAX,
            arcTbl, GFL_NELEMS( arcTbl ),
            layoutData, GFL_NELEMS( layoutData ),
            GARC_message_pss_message_DAT );

  // |PACR\[X
  m_pPokeIcon = GFL_NEW( heap->pHeap ) common::resource::PokeIcon( heap->pHeap, heap->pDevHeap, 6 );

  ICHI_PRINT( "Initialize2D \n" );
}

//----------------------------------------------------------------------------
/**
 * @brief		2D֘A폜
 */
//----------------------------------------------------------------------------

void GraphicWork::Finalize2D( void )
{
  GFL_DELETE m_pPokeIcon;
  Delete2D();
}

//----------------------------------------------------------------------------
/**
 *	@brief  eLXgyC̏ݒ
 */
//-----------------------------------------------------------------------------

void GraphicWork::InitTextPane( void )
{
  // ^Cg
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_MSG_BAR_TEXT0,  msg_pss_03_10_01 );  // RVA

  // VO(type_f)
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_F_1_0,  msg_pss_03_13_01 );  // |PXg
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_F_2_0,  msg_pss_03_14_01 );  // obO
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_F_3_0,  msg_pss_03_15_01 );  // 傤Ԃ

  // }`(type g)
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_G_1_0,  msg_pss_03_12_01 );  // ꏊ
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_G_1_1,  msg_pss_03_12_06 );  // HHH
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_G_2_0,  msg_pss_03_13_01 );  // |PXg
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_G_3_0,  msg_pss_03_14_01 );  // obO
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_G_4_0,  msg_pss_03_15_01 );  // 傤Ԃ

  // ꏊ(type_i)
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_POKELIST_TEXT_0, msg_pss_03_12_02 );  // 1
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_POKELIST_TEXT_1, msg_pss_03_12_03 );  // 2
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_POKELIST_TEXT_2, msg_pss_03_12_04 );  // 3
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_POKELIST_TEXT_3, msg_pss_03_12_05 );  // 4


  // |Py[W(type h)
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_H_0_0,  msg_pss_03_11_02 );  // og{bNX
  SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PANENAME_PSS_BATTLE_LOWER_PANE_PSS_TEXT_H_1_0,  msg_pss_03_11_03 );  // Ă

}

//----------------------------------------------------------------------------
/**
 *	@brief  |P̕\
 *	@param	icon_index			ǂݍޏꏊ
 *  @param	pane_index			|P\yC\̂̃CfbNX
 *	@aram	m	pp							|Pp[^
 */
//-----------------------------------------------------------------------------

void GraphicWork::SetPokemon( const u8 icon_index, const u8 pane_index, const pml::pokepara::PokemonParam *pp )
{
  gfl::grp::g2d::LytWk* layout_work = GetG2DUtil()->GetLayoutWork( COLOSSEUM_LAYOUT_ID_LOWER );


  // SyC̕\
  GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].poke, true );
  GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].item, true );
  GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].lv, true );
  GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].lv_val, true );
  GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].sex, true );

  // |PACR
  {
    gfl::grp::g2d::LytPicture *pane = layout_work->GetPicturePane( PokePane[ pane_index ].poke );

    m_pPokeIcon->ReplacePaneTexture( icon_index, pp, 0, pane );
  }

  // ACeACR
  {
    u32	itemno = pp->GetItem();
    bool visible = ( itemno != ITEM_DUMMY_DATA );
    GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].item, visible );
  }

  // xݒ
  GetG2DUtil()->SetTextBoxPaneNumber( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].lv_val, pp->GetLevel(), 3 );

  // 
  {
    pml::Sex sex = pp->GetSex();

    if( sex == pml::SEX_UNKNOWN )
    {
      // ʕsȂACR\
      GetG2DUtil()->SetPaneVisible( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].sex, false );
    }
    else
    {
      u32 msg_id;

      switch( sex ){
      case pml::SEX_MALE:		msg_id = msg_pss_03_11_04; break;	// 
      case pml::SEX_FEMALE:	msg_id = msg_pss_03_11_05; break;	// 
      default:							msg_id = msg_pss_03_11_06; break;	// H
      }

      SetTextboxPaneMessage( COLOSSEUM_LAYOUT_ID_LOWER, PokePane[ pane_index ].sex, msg_id );
    }
  }
}

//----------------------------------------------------------------------------
/**
 * @brief   Jgy[W̐؂ւ
 *
 * @param   page ݒ̃y[WID
 *
 * @return  none
 */
//----------------------------------------------------------------------------

void GraphicWork::SetCurrentPage( COLOSSEUM_PAGE_ID pageId )
{
  m_currentPage = pageId;

  // {^}l[W[̍Đݒ
  u32         paneNum;
  const app::ui::ButtonInfo*  boundboxList = GetBoundboxPaneList( pageId, &paneNum );

  ReloadButtonManager( m_heap, GetLayoutWork( COLOSSEUM_LAYOUT_ID_LOWER ), boundboxList, paneNum );
}

//----------------------------------------------------------------------------
/**
 *	@brief  ButtonManagerpBoundboxXg̎擾
 *
 *	@param	pageID  Jgy[WID
 *	@param  listNum Xgvfi[ϐ
 *
 *	@return Boundbox  Xgւ̃|C^
 */
//-----------------------------------------------------------------------------

const app::ui::ButtonInfo* GraphicWork::GetBoundboxPaneList( COLOSSEUM_PAGE_ID pageID, u32 *listNum ) const
{
  *listNum = BUTTON_PANE_BOUNDBOX_NUM[ pageID ];
  GFL_PRINT( "ButtonManager List %d \n", *listNum );
  return BUTTON_PANE_LIST[ pageID ];
}



GFL_NAMESPACE_END( colosseum )
GFL_NAMESPACE_END( app )

