//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		sv_zukan.cpp
 *	@brief  }ӃZ[uf[^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <personal/pml_PersonalData.h>
#include <savedata/sv_zukan.h>

GFL_NAMESPACE_BEGIN(savedata)

//=============================================================================
//@brief \[X`
//=============================================================================
// tHe[u
static const u16 FormTable[][2] =
{
	// |Pԍ, tH
	{ MONSNO_ANNOON, FORMNO_ANNOON_MAX },						// Am[

	{ MONSNO_DEOKISISU, FORMNO_DEOKISISU_MAX },			// fILVX

	{ MONSNO_SHEIMI, FORMNO_SHEIMI_MAX },						// VFC~
	{ MONSNO_GIRATHINA, FORMNO_GIRATHINA_MAX },			// MeBi
	{ MONSNO_ROTOMU, FORMNO_ROTOMU_MAX },						// g
	{ MONSNO_KARANAKUSI, FORMNO_KARANAKUSI_MAX },		// JiNV
	{ MONSNO_TORITODON, FORMNO_TORITODON_MAX },			// ggh
	{ MONSNO_MINOMUTTI, FORMNO_MINOMUTTI_MAX },			// ~mb`
	{ MONSNO_MINOMADAMU, FORMNO_MINOMADAMU_MAX },		// ~m}_

	{ MONSNO_POWARUN, FORMNO_POWARUN_MAX },					// | 
	{ MONSNO_THERIMU, FORMNO_THERIMU_MAX },					// `F 

	{ MONSNO_511, FORMNO_511_MAX },				        // VLWJ VK
	{ MONSNO_527, FORMNO_527_MAX },				        // AgX VK
	{ MONSNO_655, FORMNO_655_MAX },								// fBA VK
	{ MONSNO_HIHIDARUMA, FORMNO_HIHIDARUMA_MAX },		// qq_} VK
	{ MONSNO_BASURAO, FORMNO_BASURAO_MAX },					// oXI VK

  //XVKtHe[u
	{ MONSNO_KYUREMU, FORMNO_KYUREMU_MAX },					// L XVK
	{ MONSNO_KERUDHIO, FORMNO_KERUDHIO_MAX },				// PfBI XVK
	{ MONSNO_BORUTOROSU, FORMNO_BORUTOROSU_MAX },	  // {gX XVK
	{ MONSNO_TORUNEROSU, FORMNO_TORUNEROSU_MAX },		// glX XVK
	{ MONSNO_RANDOROSU, FORMNO_RANDOROSU_MAX },		  // hX XVK

  //@todo
	{ 0, 0 },
};

//=============================================================================
//@brief RXgN^EfXgN^
//=============================================================================
/**
 * @brief RXgN^
 */
ZukanData::ZukanData()
{
  this->Clear(NULL);
}

/**
 * @brief fXgN^
 */
ZukanData::~ZukanData()
{
}

//=============================================================================
//@brief 擾E
//=============================================================================
/**
 * @brief		S}Ӄ[hZbg
 * @param		is_flag S[hǂ
 * @return	none
 */
void ZukanData::SetZenkokuZukanFlag( bool is_flag )
{
  this->IncorrectZukan();
  m_data.zenkoku_flag = is_flag;
}


/**
 * @brief		S񃂁[hǂH̖₢킹
 * @retval	"true = S}Ӊ"
 * @retval	"false = ȊO"
 */
bool ZukanData::GetZenkokuZukanFlag( void ) const
{
  this->IncorrectZukan();
  return m_data.zenkoku_flag;
}


/**
 *	@brief  nXg[hZbg
 *	@param	is_flag nXg[h
 */
void ZukanData::SetHabitatListFlag( bool is_flag )
{
  this->IncorrectZukan();
  m_data.habitat_flag = is_flag;
}


/**
 * @brief	nXg[hJς݂ǂH̖₢킹
 * @retval	"true = nXg"
 * @retval	"false = ȊO"
 */
bool ZukanData::GetHabitatListFlag( void ) const
{
  this->IncorrectZukan();
  return m_data.habitat_flag;
}


/**
 * @brief  OtBbNo[Wp@\gtOݒ
 * @param		is_flag true ON@false OFF
 */
void ZukanData::SetGraphicVersionUpFlag( bool is_flag )
{
  this->IncorrectZukan();
  m_data.ver_up_flg = is_flag;
}


/**
 * @brief		OtBbNo[Wp@\gtO擾
 * @retval	"true = o[WAbvς"
 * @retval	"false = ȊO"
 */
bool ZukanData::GetGraphicVersionUpFlag( void ) const
{
  this->IncorrectZukan();
  return m_data.ver_up_flg;
}


/**
 * @brief		{̐}Ӄ[hݒ
 * @param		mode	}Ӄ[h 
 */
void ZukanData::SetZukanMode( ZukanData::Mode mode )
{
  this->IncorrectZukan();
  m_data.zukan_mode = mode;
}


/**
 * @brief		{̐}Ӄ[h擾
 * @retval	}Ӄ[h
 */
ZukanData::Mode ZukanData::GetZukanMode( void ) const
{
  this->IncorrectZukan();
  return static_cast<Mode>(m_data.zukan_mode);
}


/**
 * @brief		{̃|Pԍݒ
 * @param		mons	|Pԍ
 */
void ZukanData::SetDefaultMons( MonsNo mons )
{
  this->IncorrectZukan();
	m_data.defaultMonsNo = mons;
}


/**
 * @brief		{̃|Pԍ擾
 * @return	|Pԍ
 */
u16 ZukanData::GetDefaultMons( void ) const
{
  this->IncorrectZukan();
	return m_data.defaultMonsNo;
}


/**
 * @brief		{f[^ݒ
 * @param		mons		|Pԍ
 * @param		sex			
 * @param		rare		AtO true = RARE
 * @param		form		tH
 */
void ZukanData::SetDrawData( MonsNo mons, pml::Sex sex, bool rare, FormNo form )
{
	{	// {tHf[^
		s32	cnt = 0;
		s32	i = 0;

		while( FormTable[i][0] != 0 ){
			if( FormTable[i][0] == mons ){
				u32	j;
				for( j=0; j<FormTable[i][1]; j++ ){
					this->ResetBit( reinterpret_cast<u8 *>(m_data.draw_form[0]), cnt+j );
					this->ResetBit( reinterpret_cast<u8 *>(m_data.draw_form[1]), cnt+j );
				}
				// o^łȂtH̏ꍇ
				if( form >= FormTable[i][1] ){
					form = 0;
				}
				if( rare == true ){
					this->SetBit( reinterpret_cast<u8 *>(m_data.draw_form[COLOR_RARE]), cnt+form );
				}else{
					this->SetBit( reinterpret_cast<u8 *>(m_data.draw_form[COLOR_NORMAL]), cnt+form );
				}
				break;
			}
			cnt += FormTable[i][1];
			i++;
		}
	}

	{	// {ʏf[^
		u32	i;

		for( i=0; i<SEE_FLAG_MAX; i++ ){
			this->ResetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[i]), mons );
		}
		if( sex == pml::SEX_MALE ){
			if( rare == true ){
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_M_RARE]), mons );
			}else{
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_MALE]), mons );
			}
		}else if( sex == pml::SEX_FEMALE ){
			if( rare == true ){
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_F_RARE]), mons );
			}else{
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_FEMALE]), mons );
			}
		}else{
			// ʂȂꍇ́̃tO𗧂Ă
			if( rare == true ){
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_M_RARE]), mons );
			}else{
				this->SetBitMons( reinterpret_cast<u8 *>(m_data.draw_sex[SEE_FLAG_MALE]), mons );
			}
		}
	}
}


/**
 * @brief		őtH擾
 * @param		mons		|Pԍ
 * @return	őtH
 */
u32	ZukanData::GetFormMax( MonsNo mons ) const
{
	s32	pos = this->GetPokeFormTablePos( mons );

	if( pos != -1 ){
		return FormTable[pos][1];
	}
	return 1;
}


/**
 * @brief		\tHf[^擾
 * @param		mons		|Pԍ
 * @param		sex			
 * @param		rare		AtO true = RARE
 * @param		form		tH
 */
void ZukanData::GetDrawData( MonsNo mons, pml::Sex * sex, bool * rare, FormNo * form )
{
	s32	tp;
	s32	bit;
	u32	i;

	tp = this->GetPokeFormTablePos( mons );

	if( tp != -1 ){
		bit = this->GetPokeFormBit( mons );
		for( i=0; i<FormTable[tp][1]; i++ ){
			if( this->CheckBit( m_data.draw_form[COLOR_NORMAL], bit+i ) ){
				*form = i;
				*rare = false;
				break;
			}
			if( this->CheckBit( m_data.draw_form[COLOR_RARE], bit+i ) ){
				*form = i;
				*rare = true;
				break;
			}
		}
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_MALE]), mons ) ||
				this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_M_RARE]), mons ) ){
			*sex  = pml::SEX_MALE;
		}
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_FEMALE]), mons ) ||
				this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_F_RARE]), mons ) ){
			*sex  = pml::SEX_FEMALE;
		}
	}else{
		*form = 0;
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_MALE]), mons ) ){
			*sex  = pml::SEX_MALE;
			*rare = false;
		}
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_FEMALE]), mons ) ){
			*sex  = pml::SEX_FEMALE;
			*rare = false;
		}
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_M_RARE]), mons ) ){
			*sex  = pml::SEX_MALE;
			*rare = true;
		}
		if( this->CheckBitMons( reinterpret_cast<const u8 *>(m_data.draw_sex[SEE_FLAG_F_RARE]), mons ) ){
			*sex  = pml::SEX_FEMALE;
			*rare = true;
		}
	}

  pml::personal::LoadPersonalData( mons, *form );

  if( pml::personal::GetPersonalParam( pml::personal::PARAM_ID_sex ) == pml::personal::SEX_VECTOR_UNKNOWN ) {
		*sex  = pml::SEX_UNKNOWN;
	}
}


/**
 * @brief		ߊlf[^Zbg
 * @param		pp		ߊl|Pf[^
 */
void ZukanData::SetPokeGet( const pml::pokepara::CoreParam & param )
{
	bool	fast;
	bool	rare;
  u32 rand;
	FormNo	form;
  u32 lang;
  pml::Sex sex;
  MonsNo mons;

  this->IncorrectZukan();

	fast = param.StartFastMode();
	// ^}SȂo^Ȃ
	if( param.IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ){
    param.EndFastMode( fast );
		return;
	}
	mons = param.GetMonsNo();
	rand = param.GetPersonalRnd();
	form = param.GetFormNo();
  lang = param.GetCountryCode();
	sex  = param.GetSex();
  rare = param.IsRare();
  param.EndFastMode( fast );

  if( this->IncorrectMonsNo(mons) ){
    return;
  }

	// ƂȂꍇ
	if( this->GetPokeSeeFlag( mons ) == false ){
		this->SetDrawData( mons, sex, rare, form );
	}

	// ő̗
	this->SetZukanRandom( mons, rand );
	// ʏ
	this->SetNormalSeeFlag( mons, sex, rare );
	// tH
	this->SetFormSeeFlag( mons, sex, rare, form );
	// R[hZbg
	this->SetZukanTextVersionUp( mons, lang );
	// ߊltOZbg
  this->SetGetBit( mons );
}


/**
 * @brief		ߊl`FbN
 * @param		monsno	|Pԍ
 * @retval	"true = ߊlς"
 * @retval	"false = ȊO"
 */
bool ZukanData::GetPokeGetFlag( MonsNo monsno ) const
{
  this->IncorrectZukan();

  if( this->IncorrectMonsNo(monsno) ) {
    return false;
  }
  if( this->CheckGetBit(monsno) ){
    return true;
  }
	return false;
}


/**
 * @brief		݂̐}Ӄ[h̃|Pߊl擾
 * @param		heap	q[v
 * @return	ߊl
 */
u16 ZukanData::GetZukanPokeGetCount( gfl::heap::HeapBase *heap )
{
  if( this->GetZenkokuZukanFlag() ){
    return this->GetPokeGetCount();
  }
  return this->GetLocalPokeGetCount( heap );
}


/**
 * @brief		|Pߊl擾iSj
 * @return	ߊl
 */
u16 ZukanData::GetPokeGetCount( void ) const
{
  int count;

  this->IncorrectZukan();

  count= 0;
  for( int i=1; i<=MONSNO_END; i++ ){
    if( this->GetPokeGetFlag( static_cast<MonsNo>(i) ) == true ){
      count++;
    }
  }
  return count;
}


/**
 * @brief		|Pߊl擾inj
 * @param		heap	q[v
 * @return	ߊl
 */
u16 ZukanData::GetLocalPokeGetCount( gfl::heap::HeapBase *heap )
{
  u16 * buf;
  u16 num=0;

  this->IncorrectZukan();

  buf = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, NULL );
  num = 0;

  for( int i=1; i<=MONSNO_END; i++ ){
    if( this->GetPokeGetFlag( static_cast<MonsNo>(i) ) == true ){
      // n}ӂɂ邩`FbN
      if( buf[i] != pml::personal::CHIHOU_NO_NONE ){
        num++;
      }
    }
  }

  GflHeapFreeMemory( buf );

  return num;
}


/**
 * @brief		f[^Zbg
 * @param		pp		|P̃f[^
 */
void ZukanData::SetPokeSee( const pml::pokepara::CoreParam & param )
{
	bool	fast;
	bool	rare;
  u32 rand;
	FormNo	form;
  pml::Sex sex;
  MonsNo mons;

  this->IncorrectZukan();

	fast = param.StartFastMode();
	// ^}SȂo^Ȃ
	if( param.IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ){
    param.EndFastMode( fast );
		return;
	}
	mons = param.GetMonsNo();
	rand = param.GetPersonalRnd();
	form = param.GetFormNo();
	sex  = param.GetSex();
  rare = param.IsRare();
  param.EndFastMode( fast );

  if( this->IncorrectMonsNo(mons) ){
    return;
  }

	// ƂȂꍇ
	if( this->GetPokeSeeFlag( mons ) == false ){
		this->SetDrawData( mons, sex, rare, form );
	}

	// ő̗
	this->SetZukanRandom( mons, rand );
	// ʏ
	this->SetNormalSeeFlag( mons, sex, rare );
	// tH
	this->SetFormSeeFlag( mons, sex, rare, form );
}


/**
 * @brief		`FbN
 * @param		monsno	|Pԍ
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
bool ZukanData::GetPokeSeeFlag( MonsNo monsno ) const
{
	u32	i;

  this->IncorrectZukan();
  if( this->IncorrectMonsNo(monsno) ){
    return false;
  }
	for( i=0; i<SEE_FLAG_MAX; i++ ){
		if( this->CheckSeeBit(monsno,static_cast<SeeFlag>(i)) ){
			return true;
		}
	}
	return false;
}


/**
 * @brief		݂̐}Ӄ[h̃|P擾
 * @param		heap	q[v
 * @return	
 */
u16 ZukanData::GetZukanPokeSeeCount( gfl::heap::HeapBase *heap )
{
  if( this->GetZenkokuZukanFlag() ){
    return this->GetPokeSeeCount();
  }
  return this->GetLocalPokeSeeCount( heap );
}


/**
 * @brief		|P擾iSj
 * @return	
 */
u16 ZukanData::GetPokeSeeCount( void ) const
{
  int count;

  this->IncorrectZukan();

  count= 0;
  for( int i=1; i<=MONSNO_END; i++ ){
    if( this->GetPokeSeeFlag( static_cast<MonsNo>(i) ) == true ){
      count++;
    }
  }
  return count;
}


/**
 * @brief		|P擾inj
 * @param		heap	q[v
 *
 * @return	
 */
u16 ZukanData::GetLocalPokeSeeCount( gfl::heap::HeapBase *heap )
{
  u16 * buf;
  u16 num=0;

  this->IncorrectZukan();

  buf = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, NULL );
  num = 0;

  for( int i=1; i<=MONSNO_END; i++ ){
    if( this->GetPokeSeeFlag( static_cast<MonsNo>(i) ) == true ){
      // n}ӂɂ邩`FbN
      if( buf[i] != pml::personal::CHIHOU_NO_NONE ){
        num++;
      }
    }
  }

  GflHeapFreeMemory( buf );

  return num;
}


/**
 * @brief		w^Cṽ|P
 * @param		monsno	|Pԍ
 * @param		sex			
 * @param		rare		A
 * @param		form		tH
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckPokeSeeForm( MonsNo monsno, pml::Sex sex, bool rare, FormNo form ) const
{
  this->IncorrectZukan();

  if( this->IncorrectMonsNo(monsno) ){
    return false;
  }

	{	// tH
		s32	pos = this->GetPokeFormBit( monsno );
		if( pos != -1 ){
			return this->CheckBit( reinterpret_cast<const u8*>(m_data.form_flag[rare]), pos+form );
		}
	}

	// ʏ
	if( sex == pml::SEX_MALE ){
		if( rare == true ){
			return this->CheckSeeBit( monsno, SEE_FLAG_M_RARE );
		}else{
			return this->CheckSeeBit( monsno, SEE_FLAG_MALE );
		}
	}else if( sex == pml::SEX_FEMALE ){
		if( rare == true ){
			return this->CheckSeeBit( monsno, SEE_FLAG_F_RARE );
		}else{
			return this->CheckSeeBit( monsno, SEE_FLAG_FEMALE );
		}
	}else{
		if( rare == true ){
			if( this->CheckSeeBit( monsno, SEE_FLAG_M_RARE ) == true ||
					this->CheckSeeBit( monsno, SEE_FLAG_F_RARE ) == true ){
				return true;
			}
		}else{
			if( this->CheckSeeBit( monsno, SEE_FLAG_MALE ) == true ||
					this->CheckSeeBit( monsno, SEE_FLAG_FEMALE ) == true ){
				return true;
			}
		}
	}

	return false;
}


/**
 * @brief		|P̌擾
 * @param		monsno	|Pԍ
 * @return	
 */
u32 ZukanData::GetPokeRandomFlag( MonsNo monsno ) const
{
  u32 random;

  this->IncorrectZukan();

	// pb`[̂
	if( monsno == MONSNO_PATTIIRU ){
		return m_data.PachiRandom;
	}
	GFL_ASSERT_MSG( 0, "monsno = %d\n", monsno );
	return 0;
}


/**
 * @brief		S}ӊ`FbN
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckZenkokuComp( void ) const
{
  u16 num;

  // [RN}ӊɕKvȃ|PC߂܂
  num = this->GetZenkokuGetCompCount();

  if( num >= ZENKOKU_COMP_NUM ){
    return true;
  }
  return false;
}


/**
 * @brief		n}ӊ`FbNiߊlj
 * @param		heap	q[v
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckLocalGetComp( gfl::heap::HeapBase *heap )
{
  u16 num;

  // n}ӊɕKvȃ|PC߂܂
  num = this->GetLocalGetCompCount( heap );

  if( num >= LOCAL_COMP_NUM ){
    return true;
  }
  return false;
}


/**
 * @brief		n}ӊ`FbNij
 * @param		heap	q[v
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckLocalSeeComp( gfl::heap::HeapBase *heap )
{
  u16 num;

  // n}ӊɕKvȃ|PC߂܂
  num = this->GetLocalSeeCompCount( heap );

  if( num >= LOCAL_COMP_NUM ){
    return true;
  }
  return false;
}


/**
 * @brief		S}ӊɕKvȃ|P̕ߊl
 * @return	ߊl
 */
u16 ZukanData::GetZenkokuGetCompCount( void ) const
{
  u16 num;

  num = 0;
  for( int i=1; i<=ZENKOKU_MONSMAX; i++ ){
    if( this->GetPokeGetFlag( static_cast<MonsNo>(i) ) == true ){
      if( this->CheckZenkokuCompMonsno( static_cast<MonsNo>(i) ) == true ){
        num ++;
      }
    }
  }
  return num;
}


/**
 * @brief		n}ӊɕKvȃ|P̕ߊl
 * @param		heap	q[v
 * @return	ߊl
 */
u16 ZukanData::GetLocalGetCompCount( gfl::heap::HeapBase *heap )
{
  u16 * buf;
  u16 num=0;

  buf = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, NULL );

  for( int i=1; i<=ZENKOKU_MONSMAX; i++ ){
    if( this->GetPokeGetFlag( static_cast<MonsNo>(i) ) == true ){
      if( buf[i] != pml::personal::CHIHOU_NO_NONE ){
        if( this->CheckLocalCompMonsno( static_cast<MonsNo>(i) ) == true ){
          num++;
        }
      }
    }
  }

  GflHeapFreeMemory( buf );

  return num;
}


/**
 * @brief		n}ӊɕKvȃ|P
 * @param		heap	q[v
 * @return	
 */
u16 ZukanData::GetLocalSeeCompCount( gfl::heap::HeapBase *heap )
{
  u16 * buf;
  u16 num=0;

  buf = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, NULL );

  for( int i=1; i<=ZENKOKU_MONSMAX; i++ ){
    if( this->GetPokeSeeFlag( static_cast<MonsNo>(i) ) == true ){
      if( buf[i] != pml::personal::CHIHOU_NO_NONE ){
        if( this->CheckLocalCompMonsno( static_cast<MonsNo>(i) ) == true ){
          num++;
        }
      }
    }
  }

  GflHeapFreeMemory( buf );

  return num;
}

/**
 * @brief		}ӃeLXgo[W`FbN
 * @param		monsno				|Pԍ
 * @param		country_code	R[h
 * @retval	"true = \"
 * @retval	"false = ȊO"
 */
bool ZukanData::GetTextVersionUpFlag( MonsNo monsno, u32 country_code ) const
{
  this->IncorrectZukan();

	// R[hő or ԃR[h
	if( (country_code > 8) || (country_code == 6) || (country_code == 0) ){
		return false;
	}

	// UԂԂȂ̂ŁAXyCȍ~-1
	if( country_code >= LANG_SPAIN ){
		country_code -= 1;
	}

	return this->CheckBit( m_data.TextVersionUp, (monsno-1)*TEXTVER_VER_MAX+(country_code-1) );
}

//=============================================================================
//@brief SaveDataInterface
//=============================================================================
/**
 *  @brief    ǂݍ񂾃f[^Zbg֐
  * @param    pData   擪̃|C^
 */
void ZukanData::SetData(void* data)
{
   gfl::std::MemCopy(data, &m_data, sizeof(m_data) );
}

/**
 *  @brief    f[^̐擪|C^𓾂֐
  * @return   擪̃|C^
 */
void* ZukanData::GetData(void)
{
  return reinterpret_cast<void*>(&m_data);
}

/**
 *  @brief    f[^TCY
 *  @retval   oCg
 */
size_t ZukanData::GetDataSize(void)
{
  return sizeof( ZukanCoreData );
}

/**
 * @brief Z[uf[^̃NA
 * @param heap@NAɎgpe|q[v(gpĂȂ)
 */
void ZukanData::Clear( gfl::heap::HeapBase * heap )
{
GFL_UNUSED(heap);
  gfl::std::MemClear( &m_data, this->GetDataSize() );
  m_data.zukan_magic = MAGIC_NUMBER;
}

//============================================================================================
//	֐
//============================================================================================
/**
 * @brief		񃏁[N̐`FbN
 */
void ZukanData::IncorrectZukan( void ) const
{
  GFL_ASSERT(m_data.zukan_magic == MAGIC_NUMBER);
}

/**
 * @brief		|Pio[͈̔̓`FbN
 * @param		monsno		|Pԍ
 * @retval	"true = ͈͊O"
 * @retval	"false = ȊO"
 */
bool ZukanData::IncorrectMonsNo(MonsNo monsno) const
{
  if (monsno == 0 || monsno > MONSNO_END) {
    GFL_PRINT( "|Pio[ُF%d\n", monsno);
    return true;
  } else {
    return false;
  }
}

/**
 * @brief		ėprbg`FbN
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 * @retval	"true = ON"
 * @retval	"false = OFF"
 */
bool ZukanData::CheckBit(const u8 * array, u16 flag_id) const
{
  return 0 != (array[flag_id >> 3] & (1 << (flag_id & 7)));
}

/**
 * @brief		ėprbg`FbNitO = |Pԍj
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 * @retval	"true = ON"
 * @retval	"false = OFF"
 */
bool ZukanData::CheckBitMons(const u8 * array, MonsNo flag_id) const
{
	return this->CheckBit( array, static_cast<int>(flag_id)-1 );
}

/**
 * @brief		ėprbgZbg
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 */
void ZukanData::SetBit(u8 * array, u16 flag_id)
{
  array[flag_id >> 3] |= 1 << (flag_id & 7);
}

/**
 * @brief		ėprbgZbgitO = |Pԍj
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 */
void ZukanData::SetBitMons(u8 * array, MonsNo flag_id)
{
	this->SetBit( array, flag_id-1 );
}

/**
 * @brief		ėprbgZbg
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 */
void ZukanData::ResetBit( u8 * array, u16 flag_id )
{
  array[flag_id >> 3] &= (1 << (flag_id & 7)) ^ 0xff;
}

/**
 * @brief		ėprbgZbgitO = |Pԍj
 * @param		array			rbge[u
 * @param		flag_id		tOhc
 */
void ZukanData::ResetBitMons( u8 * array, MonsNo flag_id )
{
	this->ResetBit( array, flag_id-1 );
}

/**
 * @brief		݂rbgݒ
 * @param		flag_id		|Pԍ
 * @param		type			
 */
void ZukanData::SetSeeBit( MonsNo flag_id, ZukanData::SeeFlag type )
{
	this->SetBitMons( reinterpret_cast<u8*>(m_data.sex_flag[type]), flag_id );
}

/**
 * @brief		܂rbgݒ
 * @param		flag_id		|Pԍ
 */
void ZukanData::SetGetBit( MonsNo flag_id )
{
  this->SetBitMons( reinterpret_cast<u8*>(m_data.get_flag), flag_id );
}

/**
 * @brief		݂rbgON/OFF`FbN
 * @param		monsno		|Pԍ
 * @param		type			
 * @retval	"true = ON"
 * @retval	"false = OFF"
 */
bool ZukanData::CheckSeeBit( MonsNo monsno, ZukanData::SeeFlag type ) const
{
	return CheckBitMons( reinterpret_cast<const u8*>(m_data.sex_flag[type]), monsno );
}

/**
 * @brief		܂rbgON/OFF`FbN
 * @param		monsno		|Pԍ
 * @retval	"true = ON"
 * @retval	"false = OFF"
 */
bool ZukanData::CheckGetBit( MonsNo monsno ) const
{
  return this->CheckBitMons(reinterpret_cast<const u8*>(m_data.get_flag), monsno );
}

/**
 * @brief		ő̗ݒ
 * @param		monsno		|Pԍ
 * @param		rand			
 */
void ZukanData::SetZukanRandom( MonsNo monsno, u32 rand )
{
  if( monsno == MONSNO_PATTIIRU && m_data.PachiRandom == 0 ){
    m_data.PachiRandom = rand;
  }
}

/**
 * @brief		eLXgo[WtOݒ
 * @param		monsno		|Pԍ
 * @param		lang			R[h
 */
void ZukanData::SetZukanTextVersionUp( MonsNo monsno, u32 lang )
{
	// R[hő or ԃR[h
	if( (lang > 8) || (lang == 6) || (lang == 0) ){
		return;
	}

	// UԂԂȂ̂ŁAXyCȍ~-1
	if( lang >= LANG_SPAIN ){
		lang -= 1;
	}

	this->SetBit( m_data.TextVersionUp, (monsno-1)*TEXTVER_VER_MAX+(lang-1) );
}

/**
 * @brief		S}ӊɕKvȃ|P`FbN
 * @param		monsno		|Pԍ
 * @retval	"true = Kv"
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckZenkokuCompMonsno( MonsNo monsno ) const
{
  int i;
  /*
   * ̃e[uҏWꍇA
   * swan/tools/hash/special_mons_tbl.rb->$monsname_maboroshi_tbl
   * ꏏɕҏWĂ 11.11.18
   */
  static const u16 cut_check_monsno[] = {
    MONSNO_MYUU,				// ~E
    MONSNO_SEREBHI,			// ZrB
    MONSNO_ZIRAATI,			// W[`
    MONSNO_DEOKISISU,		// fILVX
    MONSNO_FIONE,				// tBIl
    MONSNO_MANAFI,			// }itB
    MONSNO_DAAKURAI,		// _[NC
    MONSNO_SHEIMI,			// VFC~
    MONSNO_ARUSEUSU,		// AZEX
		MONSNO_654,					// PfBI
		MONSNO_655,					// Gb^
		MONSNO_656,					// QmZNg
		MONSNO_657,					// rNeBj
  };

  //@todo

  // `FbNO|P`FbN
  for( i=0; i<GFL_NELEMS(cut_check_monsno); i++ ){
    if( cut_check_monsno[i] == monsno ){
      return false;
    }
  }
  return true;
}

/**
 * @brief		n}ӊɕKvȃ|P`FbN
 * @param		monsno		|Pԍ
 * @retval	"true = Kv"
 * @retval	"false = ȊO"
 */
bool ZukanData::CheckLocalCompMonsno( MonsNo monsno ) const
{
  int i;
  /*
   * ̃e[uҏWꍇA
   * swan/tools/hash/special_mons_tbl.rb->$monsname_maboroshi_loacl_tbl
   * ꏏɕҏWĂ 11.11.18
   */
  static const u16 cut_check_monsno[] = {
		MONSNO_654,			// PfBI
		MONSNO_655,			// Gb^
		MONSNO_656,			// QmZNg
		MONSNO_657,			// rNeBj
  };

  //@todo

  // `FbNO|P`FbN
  for( i=0; i<GFL_NELEMS(cut_check_monsno); i++ ){
    if( cut_check_monsno[i] == monsno ){
      return false;
    }
  }
  return true;
}

/**
 * @brief		tHݒrbg擾
 * @param		mons			|Pԍ
 * @retval	"-1 != tHݒrbg"
 * @retval	"-1 = ʃtHȂ|P"
 */
s32 ZukanData::GetPokeFormBit( MonsNo mons ) const
{
	s32	cnt = 0;
	s32	i = 0;

	while( FormTable[i][0] != 0 ){
		if( FormTable[i][0] == mons ){
			return cnt;
		}
		cnt += FormTable[i][1];
		i++;
	}
	return -1;
}

/**
 * @brief		tHe[uʒu擾
 * @param		mons			|Pԍ
 * @retval	"-1 != tHe[uʒu"
 * @retval	"-1 = ʃtHȂ|P"
 */
s32 ZukanData::GetPokeFormTablePos( MonsNo mons ) const
{
	s32	i = 0;

	while( FormTable[i][0] != 0 ){
		if( FormTable[i][0] == mons ){
			return i;
		}
		i++;
	}
	return -1;
}

/**
 * @brief		ʏ̌tOݒ
 * @param		mons		|Pԍ
 * @param		sex			
 * @param		rare		AtO true = RARE
 */
void ZukanData::SetNormalSeeFlag( MonsNo mons, pml::Sex sex, bool rare )
{
	if( sex == pml::SEX_MALE ){
		if( rare == true ){
			this->SetSeeBit( mons, SEE_FLAG_M_RARE );
		}else{
			this->SetSeeBit( mons, SEE_FLAG_MALE );
		}
	}else if( sex == pml::SEX_FEMALE ){
		if( rare == true ){
			this->SetSeeBit( mons, SEE_FLAG_F_RARE );
		}else{
			this->SetSeeBit( mons, SEE_FLAG_FEMALE );
		}
	}else{
		// ʂȂꍇ́̃tO𗧂Ă
		if( rare == true ){
			this->SetSeeBit( mons, SEE_FLAG_M_RARE );
		}else{
			this->SetSeeBit( mons, SEE_FLAG_MALE );
		}
	}
}

/**
 * @brief		tH݂tOݒ
 * @param		mons		|Pԍ
 * @param		sex			
 * @param		rare		AtO true = RARE
 * @param		form		tH
 */
void ZukanData::SetFormSeeFlag( MonsNo mons, pml::Sex sex, bool rare, FormNo form )
{
	s32	pos = this->GetPokeFormBit( mons );

	if( pos != -1 ){
		u16	max;
		u16	i;
		// ꕔ̃|P͑SẴtHONɂ
		// |
		if( mons == MONSNO_POWARUN ){
			form = 0;
			max  = FORMNO_POWARUN_MAX;
		// `F
		}else if( mons == MONSNO_THERIMU ){
			form = 0;
			max  = FORMNO_THERIMU_MAX;
		// qq_}
		}else if( mons == MONSNO_HIHIDARUMA ){
			form = 0;
			max  = FORMNO_HIHIDARUMA_MAX;
		// fBA
		}else if( mons == MONSNO_655 ){
			form = 0;
			max  = FORMNO_655_MAX;
		}else{
			// o^łȂtH̏ꍇ
			if( form >= this->GetFormMax( mons ) ){
				form = 0;
			}
			max  = 1;
		}
    //@todo

		if( rare == true ){
			for( i=0; i<max; i++ ){
				this->SetBit( m_data.form_flag[COLOR_RARE], pos+form+i );
			}
		}else{
			for( i=0; i<max; i++ ){
				this->SetBit( m_data.form_flag[COLOR_NORMAL], pos+form+i );
			}
		}
	}
}


GFL_NAMESPACE_END(savedata)
