//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		sv_zukan.h
 *	@brief  }ӃZ[uf[^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __SV_ZUKAN_H__
#define __SV_ZUKAN_H__
#pragma once

#include <gflib.h>
#include <pmlib.h>
#include <savedata/SaveDataInterface.h>

#include <monsno_def.h>
#include <monsnum_def.h>

GFL_NAMESPACE_BEGIN(savedata)
class ZukanData : public SaveDataInterface
{
  GFL_FORBID_COPY_AND_ASSIGN(ZukanData);
public:
  //=============================================================================
  //@brief 萔
  //=============================================================================
  /**
   *  @brief }Ӄ[h
   */
  enum Mode
  {
    MODE_LOCAL,   ///<n
    MODE_ZENKOKU, ///<S
    MODE_HABITAT, ///<z
  };
  // S}Ӎő
  static const int ZENKOKU_MONSMAX   = MONSNO_END;

  // n}Ӎő吔
  static const int LOCAL_MONSMAX = ZUKANNO_ISSHU_END;

  // [RN}ӊɕKvȃ|P̐
  static const int ZENKOKU_COMP_NOPOKE_NUM = 13;  // sKvȃ|P
  static const int ZENKOKU_COMP_NUM  = ZENKOKU_MONSMAX - ZENKOKU_COMP_NOPOKE_NUM;

  // CbV}ӊɕKvȃ|P̐
  static const int LOCAL_COMP_NOPOKE_NUM = 4;  // sKvȃ|P
  static const int LOCAL_COMP_NUM  = LOCAL_MONSMAX - LOCAL_COMP_NOPOKE_NUM;

public:
  //=============================================================================
  //@brief RXgN^EfXgN^
  //=============================================================================
  /**
   * @brief RXgN^
   */
  ZukanData();
  /**
   * @brief fXgN^
   */
  ~ZukanData();
public:
  //=============================================================================
  //@brief 擾E
  //=============================================================================
  /**
   * @brief		S}Ӄ[hZbg
   * @param		is_flag S[hǂ
   * @return	none
   */
  void SetZenkokuZukanFlag( bool is_flag );

  /**
   * @brief		S񃂁[hǂH̖₢킹
   * @retval	"true = S}Ӊ"
   * @retval	"false = ȊO"
   */
  bool GetZenkokuZukanFlag( void ) const;

  /**
   *	@brief  nXg[hZbg
   *	@param	is_flag nXg[h
   */
  void SetHabitatListFlag( bool is_flag );
  
  /**
   * @brief	nXg[hJς݂ǂH̖₢킹
   * @retval	"true = nXg"
   * @retval	"false = ȊO"
   */
  bool GetHabitatListFlag( void ) const;
  
  /**
   * @brief  OtBbNo[Wp@\gtOݒ
   * @param		is_flag true ON@false OFF
   */
  void SetGraphicVersionUpFlag( bool is_flag );
  
  /**
   * @brief		OtBbNo[Wp@\gtO擾
   * @retval	"true = o[WAbvς"
   * @retval	"false = ȊO"
   */
  bool GetGraphicVersionUpFlag( void ) const;
  
  /**
   * @brief		{̐}Ӄ[hݒ
   * @param		mode	}Ӄ[h 
   */
  void SetZukanMode( Mode mode );
  
  /**
   * @brief		{̐}Ӄ[h擾
   * @retval	}Ӄ[h
   */
  Mode GetZukanMode( void ) const;
  
  /**
   * @brief		{̃|Pԍݒ
   * @param		mons	|Pԍ
   */
  void SetDefaultMons( MonsNo mons );
  
  /**
   * @brief		{̃|Pԍ擾
   * @return	|Pԍ
   */
  u16 GetDefaultMons( void ) const;
  
  /**
   * @brief		{f[^ݒ
   * @param		mons		|Pԍ
   * @param		sex			
   * @param		rare		AtO true = RARE
   * @param		form		tH
   */
  void SetDrawData( MonsNo mons, pml::Sex sex, bool rare, FormNo form );
  
  /**
   * @brief		őtH擾
   * @param		mons		|Pԍ
   * @return	őtH
   */
  u32	GetFormMax( MonsNo mons ) const;
  
  /**
   * @brief		\tHf[^擾
   * @param		mons		|Pԍ
   * @param		sex			
   * @param		rare		AtO true = RARE
   * @param		form		tH
   */
  void GetDrawData( MonsNo mons, pml::Sex * sex, bool * rare, FormNo * form );
  
  /**
   * @brief		ߊlf[^Zbg
   * @param		pp		ߊl|Pf[^
   */
  void SetPokeGet( const pml::pokepara::CoreParam & param );
  
  /**
   * @brief		ߊl`FbN
   * @param		monsno	|Pԍ
   * @retval	"true = ߊlς"
   * @retval	"false = ȊO"
   */
  bool GetPokeGetFlag( MonsNo monsno ) const;
  
  /**
   * @brief		݂̐}Ӄ[h̃|Pߊl擾
   * @param		heap	q[v
   * @return	ߊl
   */
  u16 GetZukanPokeGetCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		|Pߊl擾iSj
   * @return	ߊl
   */
  u16 GetPokeGetCount( void ) const;
  
  /**
   * @brief		|Pߊl擾inj
   * @param		heap	q[v
   * @return	ߊl
   */
  u16 GetLocalPokeGetCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		f[^Zbg
   * @param		pp		|P̃f[^
   */
  void SetPokeSee( const pml::pokepara::CoreParam & param );
  
  /**
   * @brief		`FbN
   * @param		monsno	|Pԍ
   * @retval	"true = "
   * @retval	"false = ȊO"
   */
  bool GetPokeSeeFlag( MonsNo monsno ) const;
  
  /**
   * @brief		݂̐}Ӄ[h̃|P擾
   * @param		heap	q[v
   * @return	
   */
  u16 GetZukanPokeSeeCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		|P擾iSj
   * @return	
   */
  u16 GetPokeSeeCount( void ) const;
  
  /**
   * @brief		|P擾inj
   * @param		heap	q[v
   *
   * @return	
   */
  u16 GetLocalPokeSeeCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		w^Cṽ|P
   * @param		monsno	|Pԍ
   * @param		sex			
   * @param		rare		A
   * @param		form		tH
   * @retval	"true = "
   * @retval	"false = ȊO"
   */
  bool CheckPokeSeeForm( MonsNo monsno, pml::Sex sex, bool rare, FormNo form ) const;
  
  /**
   * @brief		|P̌擾
   * @param		monsno	|Pԍ
   * @return	
   */
  u32 GetPokeRandomFlag( MonsNo monsno ) const;
  
  /**
   * @brief		S}ӊ`FbN
   * @retval	"true = "
   * @retval	"false = ȊO"
   */
  bool CheckZenkokuComp( void ) const;
  
  /**
   * @brief		n}ӊ`FbNiߊlj
   * @param		heap	q[v
   * @retval	"true = "
   * @retval	"false = ȊO"
   */
  bool CheckLocalGetComp( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		n}ӊ`FbNij
   * @param		heap	q[v
   * @retval	"true = "
   * @retval	"false = ȊO"
   */
  bool CheckLocalSeeComp( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		S}ӊɕKvȃ|P̕ߊl
   * @return	ߊl
   */
  u16 GetZenkokuGetCompCount( void ) const;
  
  /**
   * @brief		n}ӊɕKvȃ|P̕ߊl
   * @param		heap	q[v
   * @return	ߊl
   */
  u16 GetLocalGetCompCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		n}ӊɕKvȃ|P
   * @param		heap	q[v
   * @return	
   */
  u16 GetLocalSeeCompCount( gfl::heap::HeapBase *heap );
  
  /**
   * @brief		}ӃeLXgo[W`FbN
   * @param		monsno				|Pԍ
   * @param		country_code	R[h
   * @retval	"true = \"
   * @retval	"false = ȊO"
   */
  bool GetTextVersionUpFlag( MonsNo monsno, u32 country_code ) const;

  //=============================================================================
  //@brief SaveDataInterface
  //=============================================================================
 public:
  /**
   *  @brief    ǂݍ񂾃f[^Zbg֐
    * @param    pData   擪̃|C^
   */
  virtual void SetData(void* data);
  /**
   *  @brief    f[^̐擪|C^𓾂֐
    * @return   擪̃|C^
   */
  virtual void* GetData(void);
  /**
   *  @brief    f[^TCY
   *  @retval   oCg
   */
  virtual size_t GetDataSize(void);
  /**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
   */
  virtual void Clear( gfl::heap::HeapBase * heap ); 

  //=============================================================================
  //@brief ȉprivate
  //=============================================================================
private:
  enum SeeFlag
  {
    SEE_FLAG_MALE = 0,		// 
    SEE_FLAG_FEMALE,			// 
    SEE_FLAG_M_RARE,			// A
    SEE_FLAG_F_RARE,			// A
    SEE_FLAG_MAX,
  };

	// F`
  enum Color
  {
	  COLOR_NORMAL = 0,		// ʏJ[	
  	COLOR_RARE,					// AJ[
	  COLOR_MAX,
  };

  //@todo |PƂtHƂvH
  static const int POKEZUKAN_ARRAY_LEN = 23; ///<|P}ӃtOẑ 23 * 32 = 736܂őv
  static const int FORM_ARRAY_LEN = 11;		///< tHtOz̑傫 11 * 8 = 88܂őv 

  static const int MAGIC_NUMBER = 0x2f120f17;

	static const int TEXTVER_VER_MAX = 7;				///< ސ		/p/////

	static const int TEXTVER_ARRAY_LEN = 632;		///< tO		|P * ꐔ / 8 = 721 * 7 / 8 = 432

  struct ZukanCoreData
  {
    u32 zukan_magic;					///< }WbNio[
    u32	zenkoku_flag:1;				///< S}ӕێtO
    u32	habitat_flag:1;				///< nXgtO
    u32	ver_up_flg:8;				  ///< o[VAbvtO
    u32	zukan_mode:2;					///< {̐}Ӄ[h
    u32	defaultMonsNo:10;			///< {̃|Pԍ
    u32	dummy:10;		///< xo^ꂽ|Pԍiɂ薢gpj
    u32 get_flag[POKEZUKAN_ARRAY_LEN];    ///< ߂܂tOp[N
    u32 sex_flag[SEE_FLAG_MAX][POKEZUKAN_ARRAY_LEN];		///< IXXtOp[N
    u32	draw_sex[SEE_FLAG_MAX][POKEZUKAN_ARRAY_LEN];		///< {IXXtO
    u8	form_flag[COLOR_MAX][FORM_ARRAY_LEN];						///< tHtOp[N
    u8	draw_form[COLOR_MAX][FORM_ARRAY_LEN];						///< {tHtO
    u8 TextVersionUp[TEXTVER_ARRAY_LEN];	///< o[WAbv}XN
    u32 PachiRandom;            ///< pb`[pێ[N
  };

private:
  void IncorrectZukan( void ) const;
  bool IncorrectMonsNo( MonsNo monsno ) const;
  bool CheckBit(const u8 * array, u16 flag_id) const;
  bool CheckBitMons(const u8 * array, MonsNo flag_id) const;
  void SetBit(u8 * array, u16 flag_id);
  void SetBitMons(u8 * array, MonsNo flag_id);
  void ResetBit( u8 * array, u16 flag_id );
  void ResetBitMons( u8 * array, MonsNo flag_id );
  void SetSeeBit( MonsNo flag_id, SeeFlag type );
  void SetGetBit( MonsNo flag_id );
  bool CheckSeeBit( MonsNo monsno, ZukanData::SeeFlag type ) const;
  bool CheckGetBit( MonsNo monsno ) const;
  void SetZukanRandom( MonsNo monsno, u32 rand );
  void SetZukanTextVersionUp( MonsNo monsno, u32 lang );
  bool CheckZenkokuCompMonsno( MonsNo monsno ) const;
  bool CheckLocalCompMonsno( MonsNo monsno ) const;
  s32 GetPokeFormBit( MonsNo mons ) const;
  s32 GetPokeFormTablePos( MonsNo mons ) const;
  void SetNormalSeeFlag( MonsNo mons, pml::Sex sex, bool rare );
  void SetFormSeeFlag( MonsNo mons, pml::Sex sex, bool rare, FormNo form );

private:
  ZukanCoreData m_data;
};

GFL_NAMESPACE_END(savedata)

#endif		// __SV_ZUKAN_H__
