//=============================================================================
/**
 * @file	btlv_ui_poke_list.h
 * @brief	ZYʃV[PX
 * @author	ito_isao
 * @data 2012.05.15
 */
//=============================================================================

#ifndef __BTLV_UI_POKE_LIST_H__
#define __BTLV_UI_POKE_LIST_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN(btl)

GFL_NAMESPACE_BEGIN(app)
// O錾
class IBattleParameterAccessor;
class AppBase;
GFL_NAMESPACE_END(app)

class BtlvUiWazaWasure
{
public:
  // ݒ
  struct Setting
  {
    const BTL_POKEPARAM* poke;  // Ώۂ̃|P
    WazaID id;                  // ꂩoZ
  };
  // 
  enum Result
  {
    RESULT_WAZA0,   // oĂZ1Iꂽ
    RESULT_WAZA1,   // oĂZ2Iꂽ
    RESULT_WAZA2,   // oĂZ3Iꂽ
    RESULT_WAZA3,   // oĂZ4Iꂽ
    RESULT_WAZA4,   // VoZIꂽ
    RESULT_CANCEL,  // ߂{^B{^Ŕ
    
    RESULT_DECIDE,  // ̌ʂ͓Ŏgp܂AʂƂċA邱Ƃ͂܂
    RESULT_NONE,    // ̌ʂ͓Ŏgp܂AʂƂċA邱Ƃ͂܂
  };
  
  // ݂̃V[PX
  enum Sequence
  {
    SEQ_LIST,
    SEQ_INFO,
  };
  
public:
  
  // con, des
  BtlvUiWazaWasure();
  ~BtlvUiWazaWasure();
  
  
  // 쐬
  void Create( const Setting& setting, gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, gfl::grp::g2d::LytSys* layout);
  
  // 폜
  void Delete( void );
  
  // Iǂ𒲂ׂ
  bool IsFinished( void );
  
  // XV
  void Update( void );
  
  
  // ʂ擾
  Result GetResult( void );
  
//--------------------------------------------------------------------
// ȉAgp
//--------------------------------------------------------------------
private:
  // SettingɁAZXgʂ쐬
  void CreateWazaList();
  // SettingɁAZʂ쐬
  void CreateWazaInfo(int waza_index);
  
  void DeleteWazaList();
  void DeleteWazaInfo();
  
  void OnAppFinished_List();
  void OnAppFinished_Info();
  
private:
  gfl::heap::HeapBase* m_heap;
  gfl::heap::HeapBase* m_device_heap;
  gfl::grp::g2d::LytSys* m_layout;
  btl::app::IBattleParameterAccessor* m_accessor;
  
  
  Setting m_setting;
  bool m_finish;
  Result m_result;
  Result m_selected;
  Sequence m_seq;
  
  btl::app::AppBase* m_app;
};

GFL_NAMESPACE_END(btl)

#endif //__BTLV_UI_POKE_LIST_H__

