
#include "btlv_ui_wazawasure.h"

#include "app/AppBase.h"
#include "app/WazaWasureList.h"
#include "app/WazaWasureInfo.h"


GFL_NAMESPACE_BEGIN(btl)


//--------------------------------------------------------------------
// con,des
//--------------------------------------------------------------------
BtlvUiWazaWasure::BtlvUiWazaWasure() : 
  m_heap(NULL),
  m_device_heap(NULL),
  m_layout(NULL),
  m_accessor(NULL),
  m_finish(false),
  m_result(RESULT_NONE),
  m_seq(SEQ_LIST),
  m_app(NULL)
{
}

BtlvUiWazaWasure::~BtlvUiWazaWasure()
{
}


//--------------------------------------------------------------------
// Create, Destroy
//--------------------------------------------------------------------
void BtlvUiWazaWasure::Create( const Setting& setting, gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, gfl::grp::g2d::LytSys* layout)
{
  GFL_PRINT("Create()\n");
  m_layout = layout;
  m_heap = heap;
  m_device_heap = device_heap;
  m_setting = setting;
  this->CreateWazaList();
  m_finish = false;
  m_result = RESULT_NONE;
}

void BtlvUiWazaWasure::Delete()
{
  GFL_PRINT("Delete()\n");
  this->DeleteWazaInfo();
  this->DeleteWazaList();
}

//--------------------------------------------------------------------
// Updaten
//--------------------------------------------------------------------
bool BtlvUiWazaWasure::IsFinished()
{
  return m_finish;
}

void BtlvUiWazaWasure::Update()
{
  if(m_app == NULL){return;}
  
  m_app->Update();
  
  if(m_app->IsFinished())
  {
    switch(m_seq)
    {
    case SEQ_LIST:
      this->OnAppFinished_List();
      break;
    case SEQ_INFO:
      this->OnAppFinished_Info();
      break;
    }
  }
}

BtlvUiWazaWasure::Result BtlvUiWazaWasure::GetResult()
{
  return m_result;
}

//--------------------------------------------------------------------
// ȉAgp
//--------------------------------------------------------------------
// ZXgʂ̍쐬
void BtlvUiWazaWasure::CreateWazaList()
{
  GFL_PRINT("CreateWazaList()\n");
  GFL_ASSERT(m_app == NULL);
  m_app = GFL_NEW(m_heap) btl::app::WazaWasureList(m_heap, m_device_heap, m_layout, m_accessor, m_setting.poke, m_setting.id);
  m_seq = SEQ_LIST;
  m_app->SetAutoDrawFlag(true);
  m_app->Start();
}

// Zڍ׉ʂ̍쐬
void BtlvUiWazaWasure::CreateWazaInfo(int waza_index)
{
  GFL_PRINT("CreateWazaInfo()\n");
  GFL_ASSERT(m_app == NULL);
  m_app = GFL_NEW(m_heap) btl::app::WazaWasureInfo(m_heap, m_device_heap, m_layout, m_accessor, waza_index, m_setting.poke, m_setting.id);
  m_seq = SEQ_INFO;
  m_app->SetAutoDrawFlag(true);
  m_app->Start();
}

// 폜
void BtlvUiWazaWasure::DeleteWazaList()
{
  GFL_PRINT("DeleteWazaList()\n");
  if(m_app != NULL)
  {
    GFL_DELETE(m_app);
    m_app = NULL;
  }
}
void BtlvUiWazaWasure::DeleteWazaInfo()
{
  GFL_PRINT("DeleteWazaInfo()\n");
  if(m_app != NULL)
  {
    GFL_DELETE(m_app);
    m_app = NULL;
  }
}


// eʂ𔲂
void BtlvUiWazaWasure::OnAppFinished_List()
{
  GFL_PRINT("OnAppFinished_List()\n");
  Result ret = ((btl::app::WazaWasureList*)m_app)->GetResult2();
  switch(ret)
  {
  case RESULT_WAZA0:
  case RESULT_WAZA1:
  case RESULT_WAZA2:
  case RESULT_WAZA3:
  case RESULT_WAZA4:
    GFL_PRINT("selected()\n");
    m_selected = ret;
    this->DeleteWazaList();
    this->CreateWazaInfo((int)ret);
    break;
  case RESULT_CANCEL:
    GFL_PRINT("canceled()\n");
    m_finish = true;
    m_result = RESULT_CANCEL;
    this->DeleteWazaList();
    break;
  }
}
void BtlvUiWazaWasure::OnAppFinished_Info()
{
  GFL_PRINT("OnAppFinished_Info()\n");
  switch(((btl::app::WazaWasureInfo*)m_app)->GetResult2())
  {
  case RESULT_DECIDE:
    GFL_PRINT("selected()\n");
    m_result = m_selected;
    m_finish = true;
    this->DeleteWazaInfo();
    break;
  case RESULT_CANCEL:
    GFL_PRINT("canceled()\n");
    this->DeleteWazaInfo();
    this->CreateWazaList();
    break;
  }
}


GFL_NAMESPACE_END(btl)
