//=======================================================================================
/**
 * @file WazaWasureList.h
 * @briefu킴݂v
 * @author obata_toshihiro
 * @date 2011.09.05
 */
//=======================================================================================
#ifndef __WAZAWASURELIST_H__
#define __WAZAWASURELIST_H__
#include <gflib.h>
#include <print/xy_msgWin.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "IWazaList.h"
#include "battle/btlv/btlv_ui_wazawasure.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class WazaWasureList : public IWazaList
    {
      GFL_FORBID_COPY_AND_ASSIGN( WazaWasureList );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      WazaWasureList( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          gfl::grp::g2d::LytSys* lytsys, IBattleParameterAccessor* accessor,
          const BTL_POKEPARAM* param,
          WazaID waza);

      /**
       * @brief fXgN^
       */
      virtual ~WazaWasureList(); 


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting );

      // gp֎~
      IWazaList::Result GetResult( void ) const{GFL_ASSERT(0);return IWazaList::RESULT_NULL;}
      
      BtlvUiWazaWasure::Result GetResult2( void ){return m_result2;}

      // override
      const BTL_POKEPARAM* GetBtlParam() const;
      
      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Start( void );

      /**
       * @brief I[g`tOZbg
       */
      virtual void SetAutoDrawFlag( bool flag );





      private:


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^ԍ
      enum ButtonIndex {
        BUTTON_WAZA0,   // 莝Z1
        BUTTON_WAZA1,   // 莝Z2
        BUTTON_WAZA2,   // 莝Z3
        BUTTON_WAZA3,   // 莝Z4
        BUTTON_WAZA4,   // ꂩoZ
        BUTTON_RETURN,  // ߂{^
        BUTTON_NUM,
      };

      // Z{^ԍ
      enum WazaButtonIndex {
        WAZA_BUTTON_0,
        WAZA_BUTTON_1,
        WAZA_BUTTON_2,
        WAZA_BUTTON_3,
        WAZA_BUTTON_4,
        WAZA_BUTTON_NUM,
        WAZA_BUTTON_NULL,
      };


      // ^CvACR̔ԍ
      enum {
        TYPEICON_POKETYPE1,  // |P̃^Cv1
        TYPEICON_POKETYPE2,  // |P̃^Cv2
        TYPEICON_WAZA0,      // Z0̃^Cv
        TYPEICON_WAZA1,      // Z1̃^Cv
        TYPEICON_WAZA2,      // Z2̃^Cv
        TYPEICON_WAZA3,      // Z3̃^Cv
        TYPEICON_WAZA4,      // Z4̃^Cv
        TYPEICON_NUM,
      };



      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_POKE_SICK,
        ANIMATION_DATA_POKE_DEAD,
        ANIMATION_DATA_DUMMY_TYPE_ICON,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_CURSOR_FLUCTUATE,
        ANIMATION_DATA_CURSOR_ON_RETURN,
        ANIMATION_DATA_CURSOR_ON_WAZA0,
        ANIMATION_DATA_CURSOR_ON_WAZA1,
        ANIMATION_DATA_CURSOR_ON_WAZA2,
        ANIMATION_DATA_CURSOR_ON_WAZA3,
        ANIMATION_DATA_CURSOR_ON_WAZA4,
        ANIMATION_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_POKE_SICK,
        ANIMATION_POKE_DEAD,
        ANIMATION_DUMMY_TYPE_ICON,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BUTTON_RELEASE,
        ANIMATION_DUMMY_BUTTON_SELECT,
        ANIMATION_CURSOR_FLUCTUATE,
        ANIMATION_CURSOR_ON_RETURN,
        ANIMATION_CURSOR_ON_WAZA0,
        ANIMATION_CURSOR_ON_WAZA1,
        ANIMATION_CURSOR_ON_WAZA2,
        ANIMATION_CURSOR_ON_WAZA3,
        ANIMATION_CURSOR_ON_WAZA4,
        // ȉ, LAj[V
        ANIMATION_TYPEICON,
        ANIMATION_BUTTON_HOLD = ANIMATION_TYPEICON + TYPEICON_NUM,
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + BUTTON_NUM,
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + BUTTON_NUM,
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + BUTTON_NUM,
        ANIMATION_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_TYPEICON,
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        BtlvUiWazaWasure::Result result;                 // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation;            // ꂽۂ̃Aj[V
        AnimationIndex release_animation;         // ꂽۂ̃Aj[V
        AnimationIndex select_animation;          // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation;          // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation;         // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation;          // J[\ZbgAj[V
        WazaButtonIndex waza_button_index;        // ΉZ{^̃CfbNX
        u32 select_se;                            // {^Îrd
      };


      // Z{^Ƃ̐ݒ
      struct WazaButtonDesc {
        u8 waza_index;                               // Ԗڂ̋ZH
        gfl::grp::g2d::LytPaneIndex waza_name_pane;  // ZpyC
        gfl::grp::g2d::LytPaneIndex pp_label_pane;   // PPxpyC
        gfl::grp::g2d::LytPaneIndex pp_value_pane;   // PPݒlpyC
        gfl::grp::g2d::LytPaneIndex pp_max_pane;     // PPőlpyC
        AnimationIndex typeicon_animation;           // ^CvACRAj[V
        AnimationIndex exist_animation;              // Z݂ꍇ̃Aj[V
        AnimationIndex not_exist_animation;          // Z݂Ȃꍇ̃Aj[V
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 PP_PLACE_COUNT;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const WazaButtonDesc WAZA_BUTTON_DESC[ WAZA_BUTTON_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation_index;
      BtlvUiWazaWasure::Result m_result2;
      const BTL_POKEPARAM* m_param;
      WazaID m_waza;


      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );

      void StopAllCursorAnime( void );
      void InitializeCursorPos( void );

      void SetupStaticStrings( void );
      void SetupPokeParamDisplay( void );
      void SetupPokeParamDisplay_Name( void );
      void SetupPokeParamDisplay_Sex( void );
      void SetupPokeParamDisplay_Type( void );
      void SetupPokeParamDisplay_Status( void );
      void SetupPokeParamDisplay_Item( void );
      void SetupLeftButton( void );
      void SetupRightButton( void );
      void SetupWazaButton( WazaButtonIndex button_index );
      void SetWazaButtonDisplay_Exist( WazaButtonIndex button_index );
      void SetWazaButtonDisplay_NotExist( WazaButtonIndex button_index );
      void SetWazaButtonDisplay_Info( WazaButtonIndex button_index );

      void UpdateSequence( void );
      void ChangeSequence( Sequence seq, Sequence next_seq = SEQ_NULL );
      bool IsButtonTouched_TRIGGER( void ) const;
      ButtonIndex GetTouchedButton_TRIGGER( void ) const; 
      void SetCursorPos( ButtonIndex new_pos );
      void OnButtonSelectedByKey( ButtonIndex selected_button ); 
      bool IsButtonTouched_HOLD( void ) const;
      bool IsButtonSelectedByTouch( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultBySelectedButton( ButtonIndex cursor_pos ); 
      bool IsWaitAnimeEnd( void ) const;
      void OnCursorMoved( ButtonIndex new_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __WAZAWASURELIST_H__ 
