//=======================================================================================
/**
 * @file WazaWasureList.cpp
 * @briefu킴݂v
 * @author obata_toshihiro
 * @date 2011.09.05
 */
//=======================================================================================
#include <gflib.h>
#include <sound/sound.h>
#include <print/xy_msgWin.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include "IWazaList.h"
#include "WazaWasureList.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "waza_list.h"
#include "waza_list_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 WazaWasureList::APP_HEAPSIZE    =  0x1000;
    const u32 WazaWasureList::DEVICE_HEAPSIZE = 0x60000;

    // ľ
    const u32 WazaWasureList::PP_PLACE_COUNT = 2;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp WazaWasureList::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex WazaWasureList::ANIMATION_DATA_TABLE[ WazaWasureList::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_POKE_SICK */ LYTRES_WAZA_LIST_WAZA_LIST_POKE_SICK_BCLAN,
      /* ANIMATION_DATA_POKE_DEAD */ LYTRES_WAZA_LIST_WAZA_LIST_POKE_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_TYPE_ICON */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_TYPE_ICON_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_FLUCTUATE_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_RETURN */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_RETURN_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA0 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA0_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA1 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA1_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA2 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA2_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA3 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA3_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA4 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA4_BCLAN,
    };




    // LAj[VƂ̐ݒ
    const WazaWasureList::ShareAnimationDesc 
      WazaWasureList::SHARE_ANIMATION_DESC[ WazaWasureList::SHARE_ANIMATION_NUM ] = 
      {
        /* SHARE_ANIMATION_TYPEICON */
        {
          ANIMATION_TYPEICON, 
          ANIMATION_DATA_DUMMY_TYPE_ICON,
          TYPEICON_NUM,
          PANENAME_WAZA_LIST_GROUP_TYPE_ICON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_HOLD */
        {
          ANIMATION_BUTTON_HOLD, 
          ANIMATION_DATA_DUMMY_BUTTON_HOLD,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_RELEASE */
        {
          ANIMATION_BUTTON_RELEASE, 
          ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_SELECT */
        {
          ANIMATION_BUTTON_SELECT, 
          ANIMATION_DATA_DUMMY_BUTTON_SELECT,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // {^Ƃ̐ݒ
    const WazaWasureList::ButtonDesc WazaWasureList::BUTTON_DESC[ WazaWasureList::BUTTON_NUM ] = 
    {
      /* BUTTON_WAZA0 */ 
      {
        BtlvUiWazaWasure::RESULT_WAZA0,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_00,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA0,
        WAZA_BUTTON_0,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_WAZA1 */ 
      {
        BtlvUiWazaWasure::RESULT_WAZA1,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_01,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA1,
        WAZA_BUTTON_1,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_WAZA2 */ 
      {
        BtlvUiWazaWasure::RESULT_WAZA2,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_02,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA2,
        WAZA_BUTTON_2,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_WAZA3 */ 
      {
        BtlvUiWazaWasure::RESULT_WAZA3,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_03,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA3,
        WAZA_BUTTON_3,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_WAZA4 */ 
      {
        BtlvUiWazaWasure::RESULT_WAZA4,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_04,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA4 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA4 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA4 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA4,
        WAZA_BUTTON_4,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_RETURN */ 
      {
        BtlvUiWazaWasure::RESULT_CANCEL,
        PANENAME_WAZA_LIST_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_RETURN,
        WAZA_BUTTON_NULL,
        SEQ_SE_CANCEL2,
      },
    };




    // Z{^Ƃ̐ݒ
    const WazaWasureList::WazaButtonDesc WazaWasureList::WAZA_BUTTON_DESC[ WazaWasureList::WAZA_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_0 */ 
      {
        0,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_00,
        PANENAME_WAZA_LIST_PANE_PP_00,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_00,
        PANENAME_WAZA_LIST_PANE_PP_MAX_00,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* WAZA_BUTTON_1 */ 
      {
        1,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_01,
        PANENAME_WAZA_LIST_PANE_PP_01,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_01,
        PANENAME_WAZA_LIST_PANE_PP_MAX_01,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* WAZA_BUTTON_2 */ 
      {
        2,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_02,
        PANENAME_WAZA_LIST_PANE_PP_02,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_02,
        PANENAME_WAZA_LIST_PANE_PP_MAX_02,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* WAZA_BUTTON_3 */ 
      {
        3,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_03,
        PANENAME_WAZA_LIST_PANE_PP_03,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_03,
        PANENAME_WAZA_LIST_PANE_PP_MAX_03,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* WAZA_BUTTON_3 */ 
      {
        4,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_04,
        PANENAME_WAZA_LIST_PANE_PP_04,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_04,
        PANENAME_WAZA_LIST_PANE_PP_MAX_04,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA4 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };





    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      WazaWasureList::CURSOR_MOVE_DATA[ WazaWasureList::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_WAZA0,  { BUTTON_WAZA0,  BUTTON_WAZA2,  BUTTON_WAZA0,  BUTTON_WAZA1 } },
        { BUTTON_WAZA1,  { BUTTON_WAZA1,  BUTTON_WAZA3,  BUTTON_WAZA0,  BUTTON_WAZA1 } },
        { BUTTON_WAZA2,  { BUTTON_WAZA0,  BUTTON_WAZA4,  BUTTON_WAZA2,  BUTTON_WAZA3 } },
        { BUTTON_WAZA3,  { BUTTON_WAZA1,  BUTTON_RETURN, BUTTON_WAZA2,  BUTTON_WAZA3 } },
        { BUTTON_WAZA4,  { BUTTON_WAZA2,  BUTTON_WAZA4,  BUTTON_WAZA4,  BUTTON_RETURN } },
        { BUTTON_RETURN, { BUTTON_WAZA3,  BUTTON_RETURN, BUTTON_WAZA4,  BUTTON_RETURN } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    WazaWasureList::WazaWasureList( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::grp::g2d::LytSys* lytsys,
        IBattleParameterAccessor* accessor,
        const BTL_POKEPARAM* param,
        WazaID waza) :
      IWazaList( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, lytsys, accessor ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL ),
      m_param(param),
      m_waza(waza)
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
      this->SetupPokeParamDisplay();
      this->SetupStaticStrings();  // @todo xݒ肵ȍ~͕KvȂ
      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>( i );
        this->SetupWazaButton( button_index );
      }

#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_WAZA_LIST: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void WazaWasureList::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void WazaWasureList::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void WazaWasureList::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( heap, ARCID_BATTLE_APP, gfl::fs::ArcFile::OPEN );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_waza_list_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_LIST_WAZA_LIST_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
      
      // E{^E悳݂{^AZ4{^\
      // E
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_LIST_PANE_RIGHT_BUTTON );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      // 
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_LIST_PANE_LEFT_BUTTON );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      // 悳݂
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_LIST_PANE_STATUS_BUTTON );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      // Z4
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_LIST_MATERIAL_WAZA_BUTTON_04 );
        GFL_ASSERT( pane );
        pane->SetVisible( true );
      }
    }


    // LAj[V𐶐
    void WazaWasureList::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void WazaWasureList::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void WazaWasureList::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void WazaWasureList::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) 
      {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ

        m_button_manager->SetButtonSelectSE( i, BUTTON_DESC[i].select_se );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    WazaWasureList::~WazaWasureList()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }



    // J[\ǗIuWFNgj
    void WazaWasureList::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void WazaWasureList::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void WazaWasureList::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void WazaWasureList::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void WazaWasureList::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 

      this->SetupStaticStrings();  // @todo xݒ肵ȍ~͕KvȂ
      this->SetupPokeParamDisplay();
      this->SetupLeftButton();
      this->SetupRightButton();

      this->SetupStaticStrings();  // @todo xݒ肵ȍ~͕KvȂ
      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>( i );
        this->SetupWazaButton( button_index );
      }
    }



    // Œ蕶̃ZbgAbv
    void WazaWasureList::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message_data = AppBase::GetBtlAppMsgData();

      this->SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_LIST_PANE_STATUS_LABEL, message_data, STR_VIEW_STATUS );

      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        this->SetTextboxPaneMessage( 
            m_layout_work, WAZA_BUTTON_DESC[i].pp_label_pane, message_data, STR_PP );
      }
    }


    // {^̃ZbgAbv
    void WazaWasureList::SetupLeftButton( void )
    {
    }


    // E{^̃ZbgAbv
    void WazaWasureList::SetupRightButton( void )
    {
    }


    // |Pp[^\̃ZbgAbv
    void WazaWasureList::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Type();
      this->SetupPokeParamDisplay_Status();
      this->SetupPokeParamDisplay_Item();
    }


    // |Pp[^\̃ZbgAbv( O )
    void WazaWasureList::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_LIST_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void WazaWasureList::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      AppBase::SetTextboxPaneSex( m_layout_work, PANENAME_WAZA_LIST_PANE_POKE_SEX, sex );
    }


    // |Pp[^\̃ZbgAbv( ^Cv )
    void WazaWasureList::SetupPokeParamDisplay_Type( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      pml::PokeType type1 = pokeparam->GetType1();
      pml::PokeType type2 = pokeparam->GetType2();

      // ^Cv1
      AnimationIndex type1_anime = 
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKETYPE1 );
      this->StartAnimation( m_layout_work, type1_anime );
      this->PauseAnimation( m_layout_work, type1_anime, false );
      this->SetAnimationFrame( m_layout_work, type1_anime, type1 );

      // ^Cv2
      if( type1 == type2 ) {
        this->SetPaneInvisible( m_layout_work, PANENAME_WAZA_LIST_PANE_TYPE_ICON2 );
      }
      else {
        AnimationIndex type2_anime = 
          static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKETYPE2 );
        this->SetPaneVisible( m_layout_work, PANENAME_WAZA_LIST_PANE_TYPE_ICON2 );
        this->StartAnimation( m_layout_work, type2_anime );
        this->PauseAnimation( m_layout_work, type2_anime, false );
        this->SetAnimationFrame( m_layout_work, type2_anime, type2 );
      }
    }


    // |Pp[^\̃ZbgAbv( Ԉُ )
    void WazaWasureList::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        this->StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        this->StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        this->PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }


    // |Pp[^\̃ZbgAbv( ACe )
    void WazaWasureList::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool icon_visible = ( itemno != ITEM_DUMMY_DATA );
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_LIST_PANE_ITEM_ICON, icon_visible );
    }




    // Z{^̃ZbgAbv
    void WazaWasureList::SetupWazaButton( WazaButtonIndex waza_button_index )
    {
        const BTL_POKEPARAM* btlparam = this->GetBtlParam();
        const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
        WazaNo wazano;
        if(waza_button_index != WAZA_BUTTON_4)
        {
          const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ waza_button_index ];
          wazano = pokeparam->GetWazaNo( desc.waza_index );
        }
        else
        {
          wazano = m_waza;
        }

        if( wazano == WAZANO_NULL )
        {
          GFL_ASSERT(0);
        }
        else
        {
          ButtonIndex button_index = 
            static_cast<ButtonIndex>( BUTTON_WAZA0 + waza_button_index );
          m_button_manager->SetButtonActive( button_index );
          //this->SetWazaButtonDisplay_Exist( waza_button_index );
          this->SetWazaButtonDisplay_Info( waza_button_index );
        }
    }


    // Z݂Ԃɂ
    void WazaWasureList::SetWazaButtonDisplay_Exist( WazaButtonIndex button_index )
    {
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];
      this->StopAnimation( m_layout_work, desc.not_exist_animation );
      this->StartAnimation( m_layout_work, desc.exist_animation );
    }


    // Z݂ȂԂɂ
    void WazaWasureList::SetWazaButtonDisplay_NotExist( WazaButtonIndex button_index )
    {
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];
      this->StopAnimation( m_layout_work, desc.exist_animation );
      this->StartAnimation( m_layout_work, desc.not_exist_animation );
    }



    // Z{^̏Zbg
    void WazaWasureList::SetWazaButtonDisplay_Info( WazaButtonIndex button_index )
    {
      WazaNo wazano;
      u8 now_pp;
      u8 max_pp;
       const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];
      if(button_index != WAZA_BUTTON_4)
      {
        const BTL_POKEPARAM* btlparam = this->GetBtlParam();
        const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
        wazano = btlparam->WAZA_GetID( desc.waza_index );
        now_pp = btlparam->WAZA_GetPP( desc.waza_index );
        max_pp = pokeparam->GetWazaMaxPP( desc.waza_index );
      }
      else
      {
        wazano = m_waza;
        now_pp = pml::wazadata::GetMaxPP(wazano, 0);
        max_pp = now_pp;
      }

      // Z
      this->SetTextboxPaneWazaName( m_layout_work, desc.waza_name_pane, wazano );
      // oo
      this->SetTextboxPaneNumber( 
          m_layout_work, desc.pp_value_pane, now_pp, PP_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, desc.pp_max_pane, max_pp, PP_PLACE_COUNT );

      // ^Cv
      pml::PokeType type = pml::wazadata::GetType( wazano );
      this->StartAnimation( m_layout_work, desc.typeicon_animation );
      this->PauseAnimation( m_layout_work, desc.typeicon_animation, false );
      this->SetAnimationFrame( m_layout_work, desc.typeicon_animation, type );
    }





    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void WazaWasureList::Start( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_result2 = btl::BtlvUiWazaWasure::RESULT_CANCEL;
      this->ChangeSequence( SEQ_INPUT_WAIT );
      m_wait_animation_index = ANIMATION_NULL;
      this->StopAllCursorAnime();
      this->InitializeCursorPos();
    }

    /**
     * @brief SẴJ[\Aj~
     */
    void WazaWasureList::StopAllCursorAnime( void ) 
    {
      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        this->StopAnimation( 
            m_layout_work, BUTTON_DESC[i].cursor_animation );
      }
    }

    /**
     * @brief J[\ʒu
     */
    void WazaWasureList::InitializeCursorPos( void )
    {
      ButtonIndex init_button = BUTTON_RETURN; 
      switch( this->GetInitCursorPos() ) {
        case INIT_CURSOR_POS_WAZA0:  init_button = BUTTON_WAZA0; break;
        case INIT_CURSOR_POS_WAZA1:  init_button = BUTTON_WAZA1; break;
        case INIT_CURSOR_POS_WAZA2:  init_button = BUTTON_WAZA2; break;
        case INIT_CURSOR_POS_WAZA3:  init_button = BUTTON_WAZA3; break;
        case INIT_CURSOR_POS_RETURN: init_button = BUTTON_RETURN; break;
      }
      m_cursor_manager->SetPos( init_button );
      this->StartAnimation( 
          m_layout_work, BUTTON_DESC[ init_button ].cursor_animation );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void WazaWasureList::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void WazaWasureList::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void WazaWasureList::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonTouched_TRIGGER() ) {
          ButtonIndex touched_button = this->GetTouchedButton_TRIGGER();
          this->SetCursorPos( touched_button );
          this->OnCursorMoved( touched_button );
        }
        else if( this->IsButtonSelectedByTouch() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultBySelectedButton( selected_button );
            m_wait_animation_index = BUTTON_DESC[ selected_button ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( this->IsButtonTouched_HOLD() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          if( this->IsSelectEnable( BUTTON_RETURN ) ) {
            this->OnButtonSelectedByKey( BUTTON_RETURN );
            this->SetResultBySelectedButton( BUTTON_RETURN );
            m_wait_animation_index = BUTTON_DESC[ BUTTON_RETURN ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->OnButtonSelectedByKey( cursor_pos );
            this->SetResultBySelectedButton( cursor_pos );
            m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->OnCursorMoved( new_cursor_pos );
          xy_snd::PlaySE( SEQ_SE_SELECT2 );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsWaitAnimeEnd() ) {
        this->ChangeSequence( m_next_seq );
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        //GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }


    /**
     * @brief gK^b`ꂽ{^邩ǂ𒲂ׂ
     * @retval true   gK^b`ꂽ{^
     * @retval false  gK^b`ꂽ{^Ȃ
     */
    bool WazaWasureList::IsButtonTouched_TRIGGER( void ) const
    {
      return ( m_button_manager->IsButtonTrigger() );
    }

    /**
     * @brief gK^b`ꂽ{^擾
     * @return gK^b`ꂽ{^̔ԍ
     */
    WazaWasureList::ButtonIndex 
      WazaWasureList::GetTouchedButton_TRIGGER( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetTriggerButtonId() );
    }

    /**
     * @brief J[\ʒuZbg
     * @param new_pos  ZbgJ[\ʒu
     */
    void WazaWasureList::SetCursorPos( ButtonIndex new_pos ) 
    {
      m_cursor_manager->SetPos( new_pos );
    }





    // {^Ă邩ǂ𒲂ׂ
    bool WazaWasureList::IsButtonTouched_HOLD( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // ^b`͂ɂ{^Iꂽǂ𒲂ׂ
    bool WazaWasureList::IsButtonSelectedByTouch( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    WazaWasureList::ButtonIndex WazaWasureList::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }

    /**
     * @brief L[͂ɂ{^Iꂽۂ̏
     * @param selected_button  Iꂽ{^
     */
    void WazaWasureList::OnButtonSelectedByKey( ButtonIndex selected_button )
    {
      m_button_manager->StartSelectedAct( selected_button );
    }




    // J[\̓XV
    bool WazaWasureList::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    WazaWasureList::ButtonIndex WazaWasureList::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // J[\ړۂ̏
    void WazaWasureList::OnCursorMoved( ButtonIndex new_pos )
    {
      this->StopAllCursorAnime();
      this->StartAnimation( 
          m_layout_work, BUTTON_DESC[ new_pos ].cursor_animation );
    }






    // I\ǂ𒲂ׂ
    bool WazaWasureList::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // Iꂽ{^, 쌋ʂZbg
    void WazaWasureList::SetResultBySelectedButton( ButtonIndex selected_button )
    {
      //this->SetResult( BUTTON_DESC[ selected_button ].result );
      m_result2 = BUTTON_DESC[ selected_button ].result;
      
      WazaButtonIndex waza_button_index = BUTTON_DESC[ selected_button ].waza_button_index;
      if( waza_button_index != WAZA_BUTTON_NULL ) {
        u8 waza_index = WAZA_BUTTON_DESC[ waza_button_index ].waza_index;
        this->SetSelectedWazaIndex( waza_index );
      }
    } 




    // ҋ@Aj[VIǂ𒲂ׂ
    bool WazaWasureList::IsWaitAnimeEnd( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return this->IsAnimationEnd( m_layout_work, m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }


    /**
     * @brief V[PXύX
     * @param seq       ZbgV[PX
     * @param next_seq  seq ̎̃V[PX
     */
    void WazaWasureList::ChangeSequence( Sequence seq, Sequence next_seq )
    {
      switch( seq ) {
      case SEQ_INPUT_WAIT:
        m_button_manager->UnlockButtonControl();
        break; 
      case SEQ_ANIME_WAIT:
      case SEQ_FINISH: 
        m_button_manager->LockButtonControl();
        break; 
      } 
      m_seq = seq;
      m_next_seq = next_seq;
    }


    const BTL_POKEPARAM* WazaWasureList::GetBtlParam() const
    {
      return m_param;
    }


  }  // namespace app
}  // namespace btl
