//=======================================================================================
/**
 * @file WazaWasureInfo.cpp
 * @brief ZYł́uZ̏ڍ׏v
 * @author ito_isao
 * @date 2012.05.15
 */
//=======================================================================================
#include <gflib.h>
#include <sound/sound.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include "IWazaInfo.h"
#include "WazaWasureInfo.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "waza_info.h"
#include "waza_info_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 WazaWasureInfo::APP_HEAPSIZE    =  0x1000;
    const u32 WazaWasureInfo::DEVICE_HEAPSIZE = 0x50000; 

    // ľ
    const u32 WazaWasureInfo::PP_PLACE_COUNT = 2;
    const u32 WazaWasureInfo::WAZAPARAM_PLACE_COUNT = 3;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp WazaWasureInfo::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex WazaWasureInfo::ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_CURSOR_ON_DECIDE */ LYTRES_WAZA_INFO_WAZA_INFO_CURSOR_ON_WASURE_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_CANCEL */ LYTRES_WAZA_INFO_WAZA_INFO_CURSOR_ON_RETURN_BCLAN,
      
      /* ANIMATION_DATA_POKE_SICK */ LYTRES_WAZA_INFO_WAZA_INFO_POKE_SICK_BCLAN,
      /* ANIMATION_DATA_POKE_DEAD */ LYTRES_WAZA_INFO_WAZA_INFO_POKE_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_TYPE_ICON */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_TYPE_ICON_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_WAZA_INFO_WAZA_INFO_CURSOR_FLUCTUATE_BCLAN,
      /* ANIMATION_DATA_WAZA_KIND */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_KIND_BCLAN,
    };


    

    // LAj[VƂ̐ݒ
    const WazaWasureInfo::ShareAnimationDesc WazaWasureInfo::SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_TYPE_ICON */
      {
        ANIMATION_TYPEICON, 
        ANIMATION_DATA_DUMMY_TYPE_ICON,
        TYPEICON_NUM,
        PANENAME_WAZA_INFO_GROUP_TYPE_ICON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_HOLD */
      {
        ANIMATION_BUTTON_HOLD, 
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        BUTTON_NUM,
        PANENAME_WAZA_INFO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_RELEASE */
      {
        ANIMATION_BUTTON_RELEASE, 
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        BUTTON_NUM,
        PANENAME_WAZA_INFO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_SELECT */
      {
        ANIMATION_BUTTON_SELECT, 
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        BUTTON_NUM,
        PANENAME_WAZA_INFO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // {^Ƃ̐ݒ
    const WazaWasureInfo::ButtonDesc WazaWasureInfo::BUTTON_DESC[ BUTTON_NUM ] = 
    {
      /* BUTTON_DECIDE */ 
      {
        BtlvUiWazaWasure::RESULT_DECIDE,
        PANENAME_WAZA_INFO_PANE_WASURE_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_DECIDE ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_DECIDE ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_DECIDE ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_DECIDE,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_RETURN */ 
      {
        BtlvUiWazaWasure::RESULT_CANCEL,
        PANENAME_WAZA_INFO_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_CANCEL,
        SEQ_SE_CANCEL2,
      },
    };




    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      WazaWasureInfo::CURSOR_MOVE_DATA[ WazaWasureInfo::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_DECIDE,  { BUTTON_DECIDE,  BUTTON_DECIDE,  BUTTON_DECIDE,  BUTTON_RETURN } },
        { BUTTON_RETURN, { BUTTON_RETURN,  BUTTON_RETURN, BUTTON_DECIDE,  BUTTON_RETURN } },
      };





    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    WazaWasureInfo::WazaWasureInfo( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::grp::g2d::LytSys* lytsys,
        IBattleParameterAccessor* accessor,
        int waza_index,
        const BTL_POKEPARAM* param,
        WazaID waza ) :
      IWazaInfo( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, lytsys, accessor ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL ),
      m_param(param),
      m_waza(waza)
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
      
      
      this->SetupStaticStrings(waza_index);
      this->SetupPokeParamDisplay();
      this->SetupWazaDisplay(waza_index);

#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_WAZA_INFO: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void WazaWasureInfo::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void WazaWasureInfo::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void WazaWasureInfo::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( heap, ARCID_BATTLE_APP, gfl::fs::ArcFile::OPEN );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_waza_info_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_INFO_WAZA_INFO_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
      
      // ʒu{^\ɁAY{^\
      // ʒu{^
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WPOS_FRAME );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_00 );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_01 );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_02 );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_03 );
        GFL_ASSERT( pane );
        pane->SetVisible( false );
      }
      // 킷{^
      {
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( PANENAME_WAZA_INFO_PANE_WASURE_BUTTON );
        GFL_ASSERT( pane );
        pane->SetVisible( true );
      }
    }


    // LAj[V𐶐
    void WazaWasureInfo::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }

    // J[\ǗIuWFNg𐶐
    void WazaWasureInfo::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }

    // {^}l[W𐶐
    void WazaWasureInfo::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void WazaWasureInfo::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) 
      {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ

        m_button_manager->SetButtonSelectSE( i, BUTTON_DESC[i].select_se );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    WazaWasureInfo::~WazaWasureInfo()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }


    // J[\ǗIuWFNgj
    void WazaWasureInfo::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }

    // {^}l[Wj
    void WazaWasureInfo::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void WazaWasureInfo::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void WazaWasureInfo::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void WazaWasureInfo::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->SetupStaticStrings(0);
      this->SetupPokeParamDisplay();
      this->SetupWazaDisplay(0);
      this->SetupWazaPosButtons();
    }



    // Œ蕶̃ZbgAbv
    void WazaWasureInfo::SetupStaticStrings( int waza_index )
    {
      gfl::str::MsgData* message_data = AppBase::GetBtlAppMsgData();
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP, message_data, STR_PP );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_KIND, message_data, STR_WAZA_KIND );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_POWER, message_data, STR_WAZA_POWER );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_HIT, message_data, STR_WAZA_HIT );
      
      // 킷{^
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_WASURE, message_data, str_btl_yesno_04 );
    }




    // |Pp[^\̃ZbgAbv
    void WazaWasureInfo::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Type();
      this->SetupPokeParamDisplay_Status();
      this->SetupPokeParamDisplay_Item();
    }


    // |Pp[^\̃ZbgAbv( O )
    void WazaWasureInfo::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void WazaWasureInfo::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      AppBase::SetTextboxPaneSex( m_layout_work, PANENAME_WAZA_INFO_PANE_POKE_SEX, sex );
    }


    // |Pp[^\̃ZbgAbv( ^Cv )
    void WazaWasureInfo::SetupPokeParamDisplay_Type( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      pml::PokeType type1 = pokeparam->GetType1();
      pml::PokeType type2 = pokeparam->GetType2();

      // ^Cv1
      AnimationIndex type1_anime = 
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKE1 );
      this->StartAnimation( m_layout_work, type1_anime );
      this->PauseAnimation( m_layout_work, type1_anime, false );
      this->SetAnimationFrame( m_layout_work, type1_anime, type1 );

      // ^Cv2
      if( type1 == type2 ) {
        this->SetPaneInvisible( m_layout_work, PANENAME_WAZA_INFO_PANE_TYPE_ICON2 );
      }
      else {
        AnimationIndex type2_anime = 
          static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKE2 );
        this->SetPaneVisible( m_layout_work, PANENAME_WAZA_INFO_PANE_TYPE_ICON2 );
        this->StartAnimation( m_layout_work, type2_anime );
        this->PauseAnimation( m_layout_work, type2_anime, false );
        this->SetAnimationFrame( m_layout_work, type2_anime, type2 );
      }
    }


    // |Pp[^\̃ZbgAbv( Ԉُ )
    void WazaWasureInfo::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        this->StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        this->StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        this->PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }


    // |Pp[^\̃ZbgAbv( ACe )
    void WazaWasureInfo::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool icon_visible = ( itemno != ITEM_DUMMY_DATA );
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_ITEM_ICON, icon_visible );
    }







    // Z̕\ZbgAbv
    void WazaWasureInfo::SetupWazaDisplay( int waza_index )
    {
      WazaNo wazano;
      
      if(waza_index != 4)
      {
        const BTL_POKEPARAM* btlparam = this->GetBtlParam();
        const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
        wazano = pokeparam->GetWazaNo( waza_index );
      }
      else
      {
        wazano = m_waza;
      }

      this->SetupWazaDisplay_Name( wazano );
      this->SetupWazaDisplay_Type( wazano );
      this->SetupWazaDisplay_PP( waza_index );
      this->SetupWazaDisplay_Kind( wazano );
      this->SetupWazaDisplay_Power( wazano );
      this->SetupWazaDisplay_Hit( wazano );
      this->SetupWazaDisplay_Info( wazano );
    }


    // Z̕\ZbgAbv( O )
    void WazaWasureInfo::SetupWazaDisplay_Name( WazaNo wazano )
    {
      gfl::str::StrBuf* tempbuf = this->GetTempStrBuf();
      pml::wazadata::GetWazaName( wazano, tempbuf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_NAME, tempbuf );
    }


    // Z̕\ZbgAbv( ^Cv )
    void WazaWasureInfo::SetupWazaDisplay_Type( WazaNo wazano )
    {
      pml::PokeType type = pml::wazadata::GetType( wazano );
      AnimationIndex type_anime = static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA );
      this->StartAnimation( m_layout_work, type_anime );
      this->PauseAnimation( m_layout_work, type_anime, false );
      this->SetAnimationFrame( m_layout_work, type_anime, type );
    }


    // Z̕\ZbgAbv( PP )
    void WazaWasureInfo::SetupWazaDisplay_PP( u8 waza_index )
    {
      u8 now_pp;
      u8 max_pp;
      if(waza_index != 4)
      {
        const BTL_POKEPARAM* btlparam = this->GetBtlParam();
        const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
        now_pp = btlparam->WAZA_GetPP( waza_index );
        max_pp = pokeparam->GetWazaMaxPP( waza_index );
      }
      else
      {
        now_pp = pml::wazadata::GetMaxPP(m_waza, 0);
        max_pp = now_pp;
      }
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP_VALUE, now_pp, PP_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP_MAX, max_pp, PP_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaWasureInfo::SetupWazaDisplay_Kind( WazaNo wazano )
    { 
      pml::wazadata::WazaDamageType kind = pml::wazadata::GetDamageType( wazano );
      this->StartAnimation( m_layout_work, ANIMATION_WAZA_KIND );
      this->PauseAnimation( m_layout_work, ANIMATION_WAZA_KIND, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_WAZA_KIND, kind );

      u32 strid[] = 
      {
        STR_WAZA_KIND_HENKA,
        STR_WAZA_KIND_BUTURI,
        STR_WAZA_KIND_TOKUSYU,
      }; 
      gfl::str::MsgData* message_data = this->GetBtlAppMsgData();
      this->SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_KIND_NAME, message_data, strid[ kind ] );
    }


    // Z̕\ZbgAbv( З )
    void WazaWasureInfo::SetupWazaDisplay_Power( WazaNo wazano )
    {
      u16 power = pml::wazadata::GetPower( wazano );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_POWER_VALUE, power, WAZAPARAM_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaWasureInfo::SetupWazaDisplay_Hit( WazaNo wazano )
    {
      u16 hit = pml::wazadata::GetParam( wazano, pml::wazadata::PARAM_ID_HITPER );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_HIT_VALUE, hit, WAZAPARAM_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaWasureInfo::SetupWazaDisplay_Info( WazaNo wazano )
    {
      gfl::str::StrBuf* tempbuf = this->GetTempStrBuf();
      pml::wazadata::GetWazaInfo( wazano, tempbuf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_INFO, tempbuf );
    }






    // Z̈ʒu{^ZbgAbv
    void WazaWasureInfo::SetupWazaPosButtons( void )
    {
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void WazaWasureInfo::Start( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_result2 = btl::BtlvUiWazaWasure::RESULT_CANCEL;
      this->ChangeSequence( SEQ_INPUT_WAIT );
      m_wait_animation_index = ANIMATION_NULL;
      this->StopAllCursorAnime();
      this->InitializeCursorPos();
    }

    /**
     * @brief SẴJ[\Aj~
     */
    void WazaWasureInfo::StopAllCursorAnime( void ) 
    {
      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        this->StopAnimation( 
            m_layout_work, BUTTON_DESC[i].cursor_animation );
      }
    }

    /**
     * @brief J[\ʒu
     */
    void WazaWasureInfo::InitializeCursorPos( void )
    {
      ButtonIndex init_button = BUTTON_DECIDE; 
      m_cursor_manager->SetPos( init_button );
      this->StartAnimation( 
          m_layout_work, BUTTON_DESC[ init_button ].cursor_animation );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void WazaWasureInfo::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void WazaWasureInfo::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 


    /**
     * @brief V[PXXV
     */
    void WazaWasureInfo::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonTouched_TRIGGER() ) {
          ButtonIndex touched_button = this->GetTouchedButton_TRIGGER();
          this->SetCursorPos( touched_button );
          this->OnCursorMoved( touched_button );
        }
        else if( this->IsButtonSelectedByTouch() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultBySelectedButton( selected_button );
            m_wait_animation_index = BUTTON_DESC[ selected_button ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( this->IsButtonTouched_HOLD() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          if( this->IsSelectEnable( BUTTON_RETURN ) ) {
            this->OnButtonSelectedByKey( BUTTON_RETURN );
            this->SetResultBySelectedButton( BUTTON_RETURN );
            m_wait_animation_index = BUTTON_DESC[ BUTTON_RETURN ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->OnButtonSelectedByKey( cursor_pos );
            this->SetResultBySelectedButton( cursor_pos );
            m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
            this->ChangeSequence( SEQ_ANIME_WAIT, SEQ_FINISH );
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->OnCursorMoved( new_cursor_pos );
          xy_snd::PlaySE( SEQ_SE_SELECT2 );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsWaitAnimeEnd() ) {
        this->ChangeSequence( m_next_seq );
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        //GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }



    /**
     * @brief gK^b`ꂽ{^邩ǂ𒲂ׂ
     * @retval true   gK^b`ꂽ{^
     * @retval false  gK^b`ꂽ{^Ȃ
     */
    bool WazaWasureInfo::IsButtonTouched_TRIGGER( void ) const
    {
      return ( m_button_manager->IsButtonTrigger() );
    }

    /**
     * @brief gK^b`ꂽ{^擾
     * @return gK^b`ꂽ{^̔ԍ
     */
    WazaWasureInfo::ButtonIndex 
      WazaWasureInfo::GetTouchedButton_TRIGGER( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetTriggerButtonId() );
    }

    /**
     * @brief J[\ʒuZbg
     * @param new_pos  ZbgJ[\ʒu
     */
    void WazaWasureInfo::SetCursorPos( ButtonIndex new_pos ) 
    {
      m_cursor_manager->SetPos( new_pos );
    }





    // {^Ă邩ǂ𒲂ׂ
    bool WazaWasureInfo::IsButtonTouched_HOLD( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // ^b`͂ɂ{^Iꂽǂ𒲂ׂ
    bool WazaWasureInfo::IsButtonSelectedByTouch( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    WazaWasureInfo::ButtonIndex WazaWasureInfo::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }

    /**
     * @brief L[͂ɂ{^Iꂽۂ̏
     * @param selected_button  Iꂽ{^
     */
    void WazaWasureInfo::OnButtonSelectedByKey( ButtonIndex selected_button )
    {
      m_button_manager->StartSelectedAct( selected_button );
    }




    // J[\̓XV
    bool WazaWasureInfo::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    WazaWasureInfo::ButtonIndex WazaWasureInfo::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // J[\ړۂ̏
    void WazaWasureInfo::OnCursorMoved( ButtonIndex new_pos )
    {
      this->StopAllCursorAnime();
      this->StartAnimation( 
          m_layout_work, BUTTON_DESC[ new_pos ].cursor_animation );
    }






    // I\ǂ𒲂ׂ
    bool WazaWasureInfo::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // Iꂽ{^, 쌋ʂZbg
    void WazaWasureInfo::SetResultBySelectedButton( ButtonIndex selected_button )
    {
      //this->SetResult( BUTTON_DESC[ selected_button ].result );
      m_result2 = BUTTON_DESC[ selected_button ].result;
    } 




    // ҋ@Aj[VIǂ𒲂ׂ
    bool WazaWasureInfo::IsWaitAnimeEnd( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return this->IsAnimationEnd( m_layout_work, m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }


    /**
     * @brief V[PXύX
     * @param seq       ZbgV[PX
     * @param next_seq  seq ̎̃V[PX
     */
    void WazaWasureInfo::ChangeSequence( Sequence seq, Sequence next_seq )
    {
      switch( seq ) {
      case SEQ_INPUT_WAIT:
        m_button_manager->UnlockButtonControl();
        break; 
      case SEQ_ANIME_WAIT:
      case SEQ_FINISH: 
        m_button_manager->LockButtonControl();
        break; 
      } 
      m_seq = seq;
      m_next_seq = next_seq;
    }





  }  // namespace app
}  // namespace btl
