//=============================================================================
/**
 * @file IBattleParameterAccessor.h
 * @brief ogɎgpp[^̃ANZXpC^[tF[X
 * @author ito_isao
 * @date 2012.05.14
 */
//=============================================================================
#ifndef __I_BATTLE_PARAMETER_ACCESSOR_H__
#define __I_BATTLE_PARAMETER_ACCESSOR_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN(btl)

class BTL_PARTY;
class POKECON;

GFL_NAMESPACE_BEGIN(app)

class IBattleParameterAccessor
{
public:
  virtual const BTL_PARTY* GetBattleParty_Self( void ) const = 0;
  virtual u8 GetClientID( void ) const = 0;
  virtual u8 GetFriendCleintID( void ) const = 0;
  virtual POKECON* GetBattleContainer( void ) const = 0;
  virtual const BTL_PARTY* GetBattleParty_Enemy( int idx = 0 ) const = 0;
  virtual const BTL_PARTY* GetBattleParty_Friend( void ) const = 0;
  virtual BTL_POKEPARAM* GetBattlePokeParam( BtlvPos pos ) const = 0;
  virtual bool IsPlayerInLeftSide( void ) = 0;
  virtual bool IsMultiMode( void ) = 0;
  virtual BtlRule GetBattleRule( void ) const = 0;
};

GFL_NAMESPACE_END(app)
GFL_NAMESPACE_END(btl)

#endif //__I_BATTLE_PARAMETER_ACCESSOR_H__
