//=============================================================================
/**
 * @file BattleParameterAccessor.h
 * @brief ogɎgpp[^̃ANZXpNX
 *        BattleViewSystemgp
 * @author ito_isao
 * @date 2012.05.14
 */
//=============================================================================
#ifndef __BATTLE_PARAMETER_ACCESSOR_H__
#define __BATTLE_PARAMETER_ACCESSOR_H__

#include <gflib.h>
#include "IBattleParameterAccessor.h"

GFL_NAMESPACE_BEGIN(btl)
GFL_NAMESPACE_BEGIN(app)

class BattleParameterAccessor : public IBattleParameterAccessor
{
public:
  BattleParameterAccessor(BattleViewSystem* btlv_core);
  ~BattleParameterAccessor();
  
  virtual const BTL_PARTY* GetBattleParty_Self( void ) const;
  virtual u8 GetFriendCleintID( void ) const;
  virtual u8 GetClientID( void ) const;
  virtual POKECON* GetBattleContainer( void ) const;
  virtual const BTL_PARTY* GetBattleParty_Enemy( int idx = 0 ) const;
  virtual const BTL_PARTY* GetBattleParty_Friend() const;
  virtual BTL_POKEPARAM* GetBattlePokeParam( BtlvPos pos ) const;
  virtual bool IsPlayerInLeftSide( void );
  virtual bool IsMultiMode( void );
  virtual BtlRule GetBattleRule( void ) const;
  
private:
  BattleViewSystem* m_btlv;
};

GFL_NAMESPACE_END(app)
GFL_NAMESPACE_END(btl)

#endif //__BATTLE_PARAMETER_ACCESSOR_H__
