//=============================================================================
/**
 * @file IBattleParameterAccessor.h
 * @brief ogɎgpp[^̃ANZXpNX
 *        BattleViewSystemgp
 * @author ito_isao
 * @date 2012.05.14
 */
//=============================================================================

#include "BattleParameterAccessor.h"
#include <battle/btlv/btlv_core.h>

GFL_NAMESPACE_BEGIN(btl)
GFL_NAMESPACE_BEGIN(app)


BattleParameterAccessor::BattleParameterAccessor(BattleViewSystem* btlv_core) : m_btlv(btlv_core)
{
}

BattleParameterAccessor::~BattleParameterAccessor()
{
}


const BTL_PARTY* BattleParameterAccessor::GetBattleParty_Self( void ) const
{
  return m_btlv->GetBattleParty_Self();
}
u8 BattleParameterAccessor::GetFriendCleintID( void ) const
{
  return m_btlv->GetFriendCleintID();
}

u8 BattleParameterAccessor::GetClientID( void ) const
{
  return m_btlv->GetClientID();
}
POKECON* BattleParameterAccessor::GetBattleContainer( void ) const
{
  return m_btlv->GetBattleContainer();
}
const BTL_PARTY* BattleParameterAccessor::GetBattleParty_Enemy( int idx ) const
{
  return m_btlv->GetBattleParty_Enemy(idx);
}
const BTL_PARTY* BattleParameterAccessor::GetBattleParty_Friend() const
{
  return m_btlv->GetBattleParty_Friend();
}
BTL_POKEPARAM* BattleParameterAccessor::GetBattlePokeParam( BtlvPos pos ) const
{
  return m_btlv->GetBattlePokeParam(pos);
}
bool BattleParameterAccessor::IsPlayerInLeftSide( void )
{
  return m_btlv->IsPlayerInLeftSide();
}

bool BattleParameterAccessor::IsMultiMode( void )
{
  return m_btlv->IsMultiMode();
}

BtlRule BattleParameterAccessor::GetBattleRule( void ) const
{
  return m_btlv->GetBattleRule();
}


GFL_NAMESPACE_END(app)
GFL_NAMESPACE_END(btl)

