//============================================================================
/**
 *
 *	@file		ScriptFuncSetGymGrass.cpp
 *	@brief  XNvg߃ZbgFW
 *
 */
//============================================================================
#include "ScriptFuncSetGymGrass.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

//=============================================================================
/**
 *					萔錾
*/
//=============================================================================

//-----------------------------------------------------------------------------
/**
 *	@brief  ߃e[uZbg擾
 */
//-----------------------------------------------------------------------------
const GFL_PAWN_FUNC_TABLE* FuncSetGymGrass::GetTable( void )
{
  static const GFL_PAWN_FUNC_TABLE s_FuncTable[] = 
  {
    GFL_PAWN_FUNC( GymGrassHangMoveEvent ) 
  };

  return s_FuncTable;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ^[Uړ
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGymGrass::GymGrassHangMoveEvent( AMX * amx, const cell * ptr )
{
  NOZOMU_PRINT("XNvgR}hďo\n");
  
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymGrass* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymGrass>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  event->SetParameter( p_fieldmap );

  return NULL;
}

GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );
