//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceGymGrass.cpp
 *	@brief  WFj[NV[PX
 *
 */
//============================================================================


// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"

// arc
#include "arc/arc_def.h"                   // ARCID_*
//#include "arc/gym_grass.gaix" @todo
//#include "field/grass_gym_model.h" @todo

namespace field {

//#include "FieldUniqueSequenceGymGrass.cdat"  // fݒt@C @todo

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	*pFieldmap tB[h}bv|C^
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceGymGrass::FieldUniqueSequenceGymGrass(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  m_setup_seq(SETUP_INIT_SEQ),
  mp_work_buffer(NULL),
  m_resource_num(0),
  mp_arcfile(NULL),
  mp_resource_array(NULL),
  mp_compress_buf(NULL),
  mpp_resource_buf_array(NULL),
  m_binLinker()
{
  mp_fieldmap = pFieldmap;
}

//----------------------------------------------------------------------------
/**
 *	@brief@fXgN^
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceGymGrass::~FieldUniqueSequenceGymGrass()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  Wpkff[^̎擾A
 *
 *	@param	none
 *
 *	@retval TRUEŏI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceGymGrass::SetupLast(void)
{
#if 0  
  // q[v擾
  gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
  gfl::heap::HeapBase*     device_memory    = mp_fieldmap->GetDeviceHeapField();
  gfl::heap::NwAllocator*  device_allocator = mp_fieldmap->GetDeviceHeapFieldAllocator();

  switch( m_setup_seq )
  {
  case SETUP_INIT_SEQ:
    {
      // A[JCut@CǍݏ
      mp_arcfile = GFL_NEW( heap_memory ) gfl::fs::ArcFile( heap_memory, ARCID_GYM_GRASS, gfl::fs::ArcFile::OPEN );
      mp_arcfile->StartSetupForFastMode( heap_memory );
      m_setup_seq++;
    }
    break;
  case SETUP_ARC_INIT_SEQ:
    {
      // t@C[hύX҂
      if( mp_arcfile->WaitSetupForFastMode() )
      {
        m_setup_seq++;
      }
      else
      {
        break;
      }
    }
    // through break
  case SETUP_GET_COMPRESS_DATA_SEQ:
    {
      // kf[^擾A𓀂
      m_resource_num = BL_IDX_GRASS_GYM_MODEL_MAX;
      mp_resource_array = GFL_NEW_ARRAY( heap_memory ) gfl::grp::g3d::Resource[ m_resource_num ];
      mpp_resource_buf_array = reinterpret_cast<void**>( GflHeapAllocMemory( heap_memory, sizeof(void*) * m_resource_num ) );

      // kf[^ǂݍ
      u32 size = mp_arcfile->GetDataSize( 0 );
      // m
      mp_compress_buf = GflHeapAllocMemoryLow( gfl::heap::Manager::GetHeapByHeapId( HEAPID_FILEREAD ), size );

      // 񓯊Ǎ݊Jn
      bool ret;
      ret = mp_arcfile->StartAsyncRead( heap_memory, 0,
          mp_compress_buf, MAIN_THREAD_PRIORITY+1 );
      GFL_ASSERT(ret);

      
      // ̃V[PX
      m_setup_seq++;
    }
    // through break
  case SETUP_WAIT_COMPRESS_DATA_SEQ:
    {
      // ǂݍ݊҂
      if( (mp_arcfile->WaitAsyncRead() == true) )
      {
        // ǂݍݑ҂
        NOZOMU_PRINT("kf[^Ǎݑ҂\n");
        break;
      }

      // 𓀏
      {
        // 𓀌̃TCY擾
        u32 size = gfl::cx::GetUncompressedSize( mp_compress_buf );
        // 𓀐惁m
        void* p_buffer = GflHeapAllocMemoryAlign( device_memory , size, 128 );
        // 𓀏
        gfl::cx::Uncompress( mp_compress_buf, p_buffer );
        GflHeapFreeMemory( mp_compress_buf );
        mp_compress_buf = p_buffer;

        // oCiJ̏   
        m_binLinker.Initialize( p_buffer );
      }

      //---------------------------
      /// M~bN[N̏
      gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();

      // ATC̏ԂmFď
      b32 is_assigned = GimmickWorkAccessor::IsAssigned(
          p_gdata, GIMMICK_ID_GYM_GRASS);
      // ATCs
      GimmickWorkAccessor::SecondAssign( p_gdata, GIMMICK_ID_GYM_GRASS);
      // obt@[ۑ
      mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

      // ATCĂȂԂ̏ꍇ̓f[^
      if( is_assigned == FALSE )
      {
        GRASS_GYM_WORK gym_work;
        gfl::std::MemClear( &gym_work, sizeof(GRASS_GYM_WORK) );
        BufferAccessorType<GRASS_GYM_WORK>::SetValue(mp_work_buffer,0,gym_work);
        NOZOMU_PRINT("M~bN[N(%x)\n",sizeof(GRASS_GYM_WORK));
      }
        
      NOZOMU_PRINT("M~bN[NTCY(%x)\n",sizeof(GRASS_GYM_WORK));

      //---------------------------
      /// M~bN[N̏
      m_setup_seq = SETUP_MDL_DATA_SEQ;
      NOZOMU_PRINT("W\[XǍ,[N\n");
    }
    return TRUE;
  }

  NOZOMU_PRINT("W\[Xǂݍݒ\n");
  return FALSE;
#endif //@todo
  return TRUE;
}

void FieldUniqueSequenceGymGrass::ReadyLastOnce(void)
{
#if 0  
  // q[v
  gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();

  //---------------------------
  /// f̃ZbgAbv
  SetupResource();

  //---------------------------
  /// ̑f̃ZbgAbv
  // Aj
  CreateAnime( 
      mp_resource_array[BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_WEB_BCSKLA],
      &m_anim[ANMID_WEB] );
  // f
  CreateModel( 
      &mp_resource_array[ BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_WEB_BCMDL ] ,
      &mp_model[MDLID_WEB],
      &m_anim[ANMID_WEB]
      );

  //---------------------------
  /// CxgpI
  // Aj
  CreateAnime( 
      mp_resource_array[BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_SDEW_BCSKLA],
      &m_anim[ANMID_SDEW] );
  // f
  CreateModel( 
      &mp_resource_array[ BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_SDEW_BCMDL ] ,
      &mp_model[MDLID_SDEW],
      &m_anim[ANMID_SDEW]
      );

  //---------------------------
  /// If̏
  for( int i = 0; i < DEW_NUM; i++ )
  {
    // IAj
    CreateAnime( 
        mp_resource_array[BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_DEW_BCSKLA],
        &m_anim[ANMID_DEW_01+i] );
    // If
    CreateModel( 
        &mp_resource_array[ BL_IDX_INSECT_GYM_MODEL_GYM_INSECT_DEW_BCMDL ] ,
        &mp_model[MDLID_DEW_01+i],
        &m_anim[ANMID_DEW_01+i]
        );
  }

  //---------------------------
  /// tf̏
  for( int i = 0; i < LEAF_DEW_NUM; i++ )
  {
    u32 mdl_idx = leaf_dew_mdl_idx_list[i];
    u32 amm_idx = leaf_dew_anm_idx_list[i];
    // IAj
    CreateAnime( 
        mp_resource_array[amm_idx],
        &m_anim[ANMID_LEAF_DEW_01+i] );
    // If
    CreateModel( 
        &mp_resource_array[ mdl_idx ] ,
        &mp_model[MDLID_LEAF_DEW_01+i],
        &m_anim[ANMID_LEAF_DEW_01+i]
        );
  }

  //---------------------------
  /// Wݒ
  static const gfl::math::VEC3 DEFAULT_POS(0.0f, 0.0f, 0.0f);
  for( int i = 0; i < MDLID_MAX; i++ )
  {
    mp_model[i]->SetTranslate(DEFAULT_POS);
  }

  //---------------------------
  /// Aj[VԂ̕A
  INSECT_GYM_WORK gym_work;
  gym_work = BufferAccessorType<INSECT_GYM_WORK>::GetValue(mp_work_buffer,0 );
  for( int i = 0; i < MDLID_MAX; i++ )
  {
    ANIMATION_STATE state;
    gfl::grp::g3d::Model* p_model = mp_model[i];
    u8 is_play  = gym_work.anm_state[i].is_play;
    if( is_play == true )
    {
      f32 animation_frame = p_model->GetAnimationEndFrame(0);
      NOZOMU_PRINT("It[=%d\n",animation_frame);
      p_model->SetAnimationFrame(animation_frame,0);
    }
  }

  //---------------------------
  /// V[ւ̓o^
  gfl::grp::g3d::Scene* p_scene = mp_fieldmap->GetGraphics()->GetScene();
  
  // ̑o^
  p_scene->AddSceneNode(mp_model[MDLID_WEB]);
 
  // iCxgpfǉ
  p_scene->AddSceneNode(mp_model[MDLID_SDEW]);

  // Io^
  for( int i = 0; i < DEW_NUM ; i ++ )
  {
    p_scene->AddSceneNode(mp_model[MDLID_DEW_01+i],SCENE_CALCULATE_GROUP_INDEX_UNIQ_MAIN);
  }

  // t̘Io^
  for( int i = 0; i < LEAF_DEW_NUM ; i ++ )
  {
    p_scene->AddSceneNode(mp_model[MDLID_LEAF_DEW_01+i],SCENE_CALCULATE_GROUP_INDEX_UNIQ_MAIN);
  }

#endif //@todo  
        
  // ZbgAbvV[PXɐݒ肷
  
  m_setup_seq = SETUP_END_SEQ;

  //NOZOMU_PRINT("{[=%d\n",mp_model[MDLID_WEB]->GetBonesCount());@todo

  NOZOMU_PRINT("Wf\n");
}

void FieldUniqueSequenceGymGrass::UpdateFirst(void)
{
}

//----------------------------------------------------------------------------
/**
 *  @brief   CALCULATĚɌĂ΂֐
 *
 *	@param	none
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymGrass::CalculateAfter(void)
{
}

void FieldUniqueSequenceGymGrass::FreeFirstOnce(void)
{
  //---------------------------
  /// eJ
  GFL_DELETE mp_arcfile;
  mp_arcfile = NULL;

  GFL_DELETE_ARRAY mp_resource_array;
  mp_resource_array = NULL;

  GflHeapFreeMemory( mp_compress_buf );
  mp_compress_buf = NULL;

  GflHeapFreeMemory( mpp_resource_buf_array );
  mpp_resource_buf_array = NULL;

#if 0  
  for( int i = 0; i < MDLID_MAX; i++ )
  {
    GFL_DELETE mp_model[i];
    mp_model[i] = NULL;
  }

  for( int i = 0; i < ANMID_MAX; i++ )
  {
    m_anim[i].Destroy();
  }
#endif //@todo
}

#if 0
//----------------------------------------------------------------------------
/**
 *	@brief  Aj[V̍쐬
 *
 *	@param	res     gp郊\[X
 *	@param	*p_anm    Aj[V擾
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymGrass::CreateAnime(gfl::grp::g3d::Resource& res,gfl::grp::g3d::ResAnim *p_anm )
{
  res.GetResAnim(
      gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL,
      0,
      p_anm);
}

//----------------------------------------------------------------------------
/**
 *	@brief  f쐬
 *
 *	@param	p_res             gp郊\[X
 *	@param	pp_model           f̎擾
 *	@param	p_anm             gpAj[V(ȗ:NULLw)
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymGrass::CreateModel(
    gfl::grp::g3d::Resource*  p_res,
    gfl::grp::g3d::Model**     pp_model,
    gfl::grp::g3d::ResAnim*   p_anm )
{
  // q[v擾
  gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
  gfl::heap::NwAllocator*  device_allocator = mp_fieldmap->GetDeviceHeapFieldAllocator();
  gfl::heap::NwAllocator*  heap_allocator   = mp_fieldmap->GetHeapFieldAllocator();
    
  
  // f
  *pp_model = GFL_NEW(heap_memory) gfl::grp::g3d::Model;

  if( p_anm == NULL )
  {
    // f̂݃ZbgAbv
    (*pp_model)->Create(
        heap_allocator, device_allocator, 
        p_res
        ,0 );
  }
  else
  {
    // f̂݃ZbgAbv{Aj[V̐ݒ
    gfl::grp::g3d::Model::Description model_description;
    model_description.animation_slot_num = 1;

    // f̃ZbgAbv
    (*pp_model)->Create(
        heap_allocator, device_allocator, 
        p_res,
        0,
        &model_description );

    
    //---------------------------
    /// Aj[Vݒ
    (*pp_model)->ChangeAnimation(
        device_allocator,
        p_anm,
        0,
        0,
        gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERS
        );

    // Aj[Vt[
    (*pp_model)->SetAnimationStepFrame(0.0f);

  }

}

//----------------------------------------------------------------------------
/**
 *	@brief  \[X̃ZbgAbv
 *
 *	@param	none
 *
 *	@retval none
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymGrass::SetupResource( void )
{
  // foCXAP[^擾
  gfl::heap::NwAllocator*  device_allocator = mp_fieldmap->GetDeviceHeapFieldAllocator();

  // \[XZbgAbv
  for( u32 i=0; i<m_resource_num; ++i ){

    MDL_SETUP_TYPE  setup_type = sc_model_setup_data[i].setup_type;
    s32  binary_id = sc_model_setup_data[i].binary_id;

    // pbP[WĂt@C̃|C^擾
    mpp_resource_buf_array[ binary_id ] = m_binLinker.GetData( binary_id );

    // fEAj[ṼA^b`AZbgAbv
    switch(setup_type)
    {
    case LOAD_TYPE_MDL:
      mp_resource_array[ binary_id ].AttachBufferAndSetup( 
          device_allocator,
          mpp_resource_buf_array[ binary_id ], 
          NULL, 
          false, 
          gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT );

      break;
    case LOAD_TYPE_ANM:
      // Aj[ṼA^b`AZbgAbv
      mp_resource_array[ binary_id ].AttachBufferAndSetup( 
          device_allocator,
          mpp_resource_buf_array[ binary_id ], 
          NULL, 
          false, 
          gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE );
      break;
    default:
      GFL_ASSERT_MSG( 0,"ZbgAbv^Cv̌\n");
      break;
    }
  }
}
#endif //@todo

} // namespace field

