//#ifdef PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		test_nagi_TouchbarTest.h
 *	@brief  ^b`o[eXg
 *	@author	Toru=Nagihashi
 *	@date		2012.05.16
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __TEST_NAGI_TOUCHBARTEST_H__
#define __TEST_NAGI_TOUCHBARTEST_H__
#pragma once

#include <gflib.h>
#include <gamesystem/GameProc.h>
#include "../obata/test_obata_Base.h"

#include <app/ui/UIView.h>
#include <app/ui/UITouchBarView.h>

GFL_NAMESPACE_BEGIN( test )
GFL_NAMESPACE_BEGIN( nagi )

/**
 *  eXgp^b`o[
 */
class Touchbar : public app::ui::UITouchBarView
{
  GFL_FORBID_COPY_AND_ASSIGN(Touchbar);
public:
  Touchbar( app::util::Heap *heap, gfl::grp::GraphicsSystem* graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work  );
  virtual ~Touchbar();
private:
  static const int BUTTON_NUM = 2;
  static const app::ui::UITouchBarView::SETUP  SETUP_TABLE[BUTTON_NUM];
};

/**
 * TvC^[tF[X
 */
class ITouchbarTestSample
{
public:
  ITouchbarTestSample(){}
  virtual ~ITouchbarTestSample(){}
  virtual void Update(void) = 0;
  virtual void Draw(void) = 0;
};


/**
 *  TvP^b`o[View̃TuViewƂĎgꍇ̐eView
 *  ->g[i[P[XłgpāACAEgf[^QĂ̂
 * QlɂĂiViewControllerƂȂƂĂ܂cj
 */
//ViewꍇA݌vvzIɂ̓Xiׂ
class ParentLisener
{
public:
  virtual bool OnReturnEvent( void ){ return true; }
  virtual bool OnExitEvent( void ){ return true; }
};

//eViewɃ^b`o[ؽłp
//OɃ^b`o[̃XiĂłA炭View̍lɍ킹ƁA
//View͕KOɎ̌ʗp̃Xi[oāÃXi[oׂłȂc͂B
//Ƃ΁A^b`o[{͂IViewłꍇA
//^b`o[Ƃ͂ĨXii͂Î͂ȂǂƂāj͊OŏoA
//ViewVɁA͂AALZ̃XiOłׂ݂Ǝvc
class ParentView : public app::ui::UIView, public app::ui::UITouchBarListener
{
  GFL_FORBID_COPY_AND_ASSIGN(ParentView);
public:
  ParentView( app::util::Heap *heap, gfl::grp::GraphicsSystem* graphics_system, ParentLisener *lisener );
  virtual ~ParentView();
  virtual void Draw( void );

public:
  virtual bool OnSelectedButton( u32 buttonID );
private:
  Touchbar * m_touchbar;
  ParentLisener *m_lisener;

  void CreateLayout( app::util::Heap *heap );
};

/**
 * TvPNX View̎qƂă^b`o[gp
 */
class TouchbarSample1 : public ITouchbarTestSample , public ParentLisener
{
  GFL_FORBID_COPY_AND_ASSIGN(TouchbarSample1);
public:
  TouchbarSample1( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphics_system );
  virtual ~TouchbarSample1();
  virtual void Update(void);
  virtual void Draw(void);
public:
  virtual bool OnReturnEvent( void );
  virtual bool OnExitEvent( void );
private:
  ParentView * m_parentview;
};

/**
 * TvQNX ^b`o[PƎgp
 */
class TouchbarSample2 : public ITouchbarTestSample, public app::ui::UITouchBarListener
{
  GFL_FORBID_COPY_AND_ASSIGN(TouchbarSample2);
public:
  TouchbarSample2( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphics_system );
  virtual ~TouchbarSample2();
  virtual void Update(void);
  virtual void Draw(void);
public:
  virtual bool OnSelectedButton( u32 buttonID );
private:
  gfl::grp::GraphicsSystem* m_graphics_system;
  gfl::grp::g2d::LytSys *m_lyt_sys;
  gfl::grp::g2d::LytWk *m_lyt_wk_down;
  gfl::grp::g2d::LytResID m_lyt_res_id;
  Touchbar * m_touchbar;

  void CreateLayout( app::util::Heap * heap );
  void DeleteLayout( void );
};

/**
 *  ^b`o[eXgC
 */
class TouchbarTest : public test::obata::Base 
{ 
  public: 
    TouchbarTest( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
        gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager );
    virtual ~TouchbarTest(); 
    virtual void UpdateTest( void );
    virtual void DrawTest( void );

  private:
    app::util::Heap * m_heap;
    ITouchbarTestSample * m_sample;
};

GFL_NAMESPACE_END( nagi )
GFL_NAMESPACE_END( test )

#endif //__TEST_NAGI_TOUCHBARTEST_H__

//#endif //GFL_DEBUG
