//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		test_nagi_TouchbarTest.cpp
 *	@brief  ^b`o[eXg
 *	@author	Toru=Nagihashi
 *	@date		2012.05.16
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

//#if PM_DEBUG

//system
#include <gflib.h>
#include <arc/arc_def.h>
#include <arc/message.gaix>

#include <print/system_font.h>
#include "nagi_res.h"
#include <arc/arc_def.h>
#include <arc/nagi_res.gaix>

#include "test_nagi_TouchbarTest.h"

#include "touchbartest_res.h"
#include "touchbartest_res_pane.h"
#include "app/ui/UIView.h"
#include "test_nagi_TouchbarTest.h"
#include <arc/touchbartest_res.gaix>


GFL_NAMESPACE_BEGIN( test )
GFL_NAMESPACE_BEGIN( nagi )

//----------------------------------------------------------------------------
/**
 *	@brief  eXgp^b`o[
 */
//-----------------------------------------------------------------------------
const app::ui::UITouchBarView::SETUP Touchbar::SETUP_TABLE[Touchbar::BUTTON_NUM] =
{
  {
    app::ui::UITouchBarView::BUTTON_ID_EXIT,
    PANENAME_TOUCHBAR_TEST_PANE_EXIT_ICON_POS
    //->^b`o[Exit{^̈ʒu^b`o[̏̃CAEgf[^ɍĖႢÄʒuyCn
  },
  {
    app::ui::UITouchBarView::BUTTON_ID_RETURN,
    PANENAME_TOUCHBAR_TEST_PANE_RETURN_ICON_POS
    //->^b`o[Return{^̈ʒu^b`o[̏̃CAEgf[^ɍĖႢÄʒuyCn
  }
};

//ZbgAbve[un
//KpȂ΂Ȃ킯ł͂܂B

Touchbar::Touchbar( app::util::Heap *heap, gfl::grp::GraphicsSystem* graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work ) :
  UITouchBarView( heap, graphic_system, layout_system, position_layout_work, SETUP_TABLE, Touchbar::BUTTON_NUM )
{
}
Touchbar::~Touchbar()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  TvP@eView
 */
//-----------------------------------------------------------------------------
ParentView::ParentView( app::util::Heap *heap, gfl::grp::GraphicsSystem* graphics_system, ParentLisener *lisener ) :
  app::ui::UIView( heap ),
  m_lisener( lisener )
{
  m_graphicSystem = graphics_system;
  this->CreateLayout( heap );

  //^b`o[쐬
  m_touchbar  = GFL_NEW(heap->GetSystemHeap()) Touchbar( heap, this->GetGraphicSystem(), this->GetLayoutSystem(), this->GetLayoutWork(0) );

  //^b`o[ɃXin
  m_touchbar->SetListener( this );

  //쐬er[ɒǉ
  this->AddSubView( m_touchbar );

  //m_touchbarUpdateDrawParentViewUpdateTreeDrawTree
  //Ă̂łȂĂ悢
}

ParentView::~ParentView()
{
  //OɐeƂ̐ڑ؂
  m_touchbar->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_touchbar );
  this->Delete2D();
}

void ParentView::CreateLayout( app::util::Heap *heap )
{
  static const gfl::fs::ArcFile::ARCID arc_tbl[] =
  {
    ARCID_TOUCHBAR_NAGI, 
  };

  static app::util::G2DUtil::LYTWK_DATA layout_data[] =
  {
    //LAYOUT_ID_UPPER
    { // 
      0,
      LYTRES_TOUCHBARTEST_RES_TOUCHBAR_TEST_BCLYT,     // resID̃CAEgf[^ID
      NULL,            // Aj[Vf[^IDe[u AĵȂꍇNULL
      0,// Aj[Vf[^IDe[u AĵȂꍇ0
      0,          // o^Aj[Vő吔
      false,                              // \yCɍsvZs
      app::util::G2DUtil::SETUP_LOWER,    // fBXvC
      true,                               // \ݒ
    },
  };

  this->Create2D( heap, NULL, 1,
                  arc_tbl, GFL_NELEMS(arc_tbl),
                  layout_data, GFL_NELEMS(layout_data),
                  GARC_message_traner_case_DAT );
}


void ParentView::Draw( void )
{
  m_g2dUtil-> Draw2D( this->GetGraphicSystem(), 0 );
}
bool ParentView::OnSelectedButton( u32 buttonID )
{
  //^b`o[p̃XiI[o[[h
  switch( buttonID )
  {
  default:
    GFL_ASSERT(0);
  case app::ui::UITouchBarView::BUTTON_ID_EXIT:
    m_lisener->OnExitEvent();
    GFL_PRINT( "EXITꂽ\n" );
    // {^Ƃ̏
    break;
  case app::ui::UITouchBarView::BUTTON_ID_RETURN:
    m_lisener->OnReturnEvent();
    GFL_PRINT( "RETURNꂽ\n" );
    // {^Ƃ̏
    break;
  }
  return false;
}

//----------------------------------------------------------------------------
/**
 *	@brief  TvPNX  View̎qƂă^b`o[gp
 */
//----------------------------------------------------------------------------
TouchbarSample1::TouchbarSample1( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphics_system )
{
  m_parentview = GFL_NEW( heap->GetSystemHeap())  ParentView( heap, graphics_system, this );
}
TouchbarSample1::~TouchbarSample1()
{
  GFL_SAFE_DELETE( m_parentview ) ;
}
void TouchbarSample1::Update(void)
{
  m_parentview->UpdateTree();
}
void TouchbarSample1::Draw(void)
{
  m_parentview->DrawTree();
}
bool TouchbarSample1::OnReturnEvent( void )
{
  return false;
}
bool TouchbarSample1::OnExitEvent( void )
{
  return false;
}

//----------------------------------------------------------------------------
/**
 *	@brief  TvPNX  View̎qƂă^b`o[gp
 */
//----------------------------------------------------------------------------
TouchbarSample2::TouchbarSample2( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphics_system ) :
  m_graphics_system(graphics_system)
{
  this->CreateLayout( heap );

  //^b`o[쐬
  m_touchbar  = GFL_NEW(heap->GetSystemHeap()) Touchbar( heap, graphics_system, m_lyt_sys, m_lyt_wk_down );
  m_touchbar->SetListener( this );
}
TouchbarSample2::~TouchbarSample2()
{
  GFL_SAFE_DELETE( m_touchbar );
  
  this->DeleteLayout();
}

void TouchbarSample2::Update(void)
{
  //XV񂷁B
  m_touchbar->Update();

  //̃^b`
  //LifŃAjɑ삳Ȃ邱
  if( m_touchbar->IsButtonAnimation() )
  {
    GFL_PRINT( "^b`o[Aj!\n" );
  }
}
void TouchbarSample2::Draw(void)
{
  gfl::grp::RenderTarget* lower_frame_buffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

  m_lyt_sys->DrawAll( m_graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );

  //`Ă
  m_touchbar->Draw();
}
bool TouchbarSample2::OnSelectedButton( u32 buttonID )
{
  //^b`o[p̃XiI[o[[h
  switch( buttonID )
  {
  default:
    GFL_ASSERT(0);
  case app::ui::UITouchBarView::BUTTON_ID_EXIT:
    // {^Ƃ̏
    GFL_PRINT("EXITꂽ\n");
    break;
  case app::ui::UITouchBarView::BUTTON_ID_RETURN:
    // {^Ƃ̏
    GFL_PRINT("RETURNꂽ\n");
    break;
  }

  return false; 
}
void TouchbarSample2::CreateLayout( app::util::Heap * heap )
{
  //2d
  static const gfl::grp::g2d::LytSysSetUp setup =
  {
    128,2
  };
  m_lyt_sys = GFL_NEW(heap->GetSystemHeap()) gfl::grp::g2d::LytSys(&setup, heap->GetSystemAllocator(), heap->GetDeviceAllocator() );

  gfl::fs::ArcFile* lyt_arc_file  = GFL_NEW(heap->GetSystemHeap()) gfl::fs::ArcFile( heap->GetSystemHeap(), ARCID_TOUCHBAR_NAGI, gfl::fs::ArcFile::OPEN );
  m_lyt_res_id  = m_lyt_sys->LoadLytResComp( heap->GetDeviceAllocator(), lyt_arc_file, GARC_touchbartest_res_touchbartest_res_lz_LYTDAT );

  GFL_SAFE_DELETE( lyt_arc_file );
  m_lyt_sys->TransferAllTexture( m_lyt_res_id, gfl::grp::MEMORY_AREA_FCRAM );

  m_lyt_wk_down = m_lyt_sys->CreateLytWk( m_lyt_res_id, LYTRES_TOUCHBARTEST_RES_TOUCHBAR_TEST_BCLYT, NULL, 0, 0, &gfl::grp::g2d::c_LytWkLowerDefaultSetUp );
  m_lyt_wk_down->SetAutoDrawFlag(true);
  
}
void TouchbarSample2::DeleteLayout( void )
{
  m_lyt_sys->RemoveLytWk( m_lyt_wk_down );
  m_lyt_sys->ReleaseLytRes( m_lyt_res_id );
  GFL_SAFE_DELETE( m_lyt_sys );
}

//----------------------------------------------------------------------------
/**
 *	@brief  ^b`o[eXgCNX
 */
//-----------------------------------------------------------------------------
TouchbarTest::TouchbarTest( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
        gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
  Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{
  m_heap  = GFL_NEW(heap) app::util::Heap();
  //m_heap->Createzg͍쐬Ȃ΂ȂǁAeXgŊOq[vႤ̂
  m_heap->pHeap = heap;
  m_heap->pHeapAllocator = heap_allocator;
  m_heap->pDevHeap  = device_heap;
  m_heap->pDevHeapAllocator   = device_allcator;

  if( m_button->IsHold( gfl::ui::BUTTON_X ) )
  {
    GFL_PRINT( "TvPN\n" );
    m_sample  = GFL_NEW(heap) TouchbarSample1( m_heap, graphics_system );
  }
  else
  {
    GFL_PRINT( "TvQN\n" );
    m_sample  = GFL_NEW(heap) TouchbarSample2( m_heap, graphics_system );
  }
}
TouchbarTest::~TouchbarTest()
{
  GFL_SAFE_DELETE( m_sample );

  //m_heap->delete قƂ͍폜
  m_heap->pHeap = NULL;
  m_heap->pHeapAllocator = NULL;
  m_heap->pDevHeap  = NULL;
  m_heap->pDevHeapAllocator   = NULL;
  GFL_SAFE_DELETE( m_heap );
}


void TouchbarTest::UpdateTest( void )
{
  m_sample->Update();

  if( m_button->IsHold( gfl::ui::BUTTON_START ) )
  {
    this->End();
  }
}

void TouchbarTest::DrawTest( void )
{
  m_sample->Draw();
}


GFL_NAMESPACE_END( nagi )
GFL_NAMESPACE_END( test )


//#endif //PM_DEBUG

