//============================================================================================
/**
 * @brief orrʐMΐp}b`O
 *
 *        PSSŏ҂ꂽΐǗ邽߂̃NX
 */
//============================================================================================

#include <netapp/pss/PssBattleMatchingInfo.h>

namespace netapp {
namespace pss {


//--------------------------------------------------------------------------------------------
/**
* @brief  RXgN^
*/
//--------------------------------------------------------------------------------------------
PssBattleMatchingInfo::PssBattleMatchingInfo( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief  fXgN^
*/
//--------------------------------------------------------------------------------------------
PssBattleMatchingInfo::~PssBattleMatchingInfo( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief  ΐogÎ҂̃thL[擾
*
* @param  hostUser     zXg[U[̃thL[
* @param  ticketID     Î҂s`PbgID
* @param  battleType   og^Cv
* @param  battleRule   og[
* @param  isHandicap   nfBLbv̗LBtrueȂnfL
* @param  guestUserNum Ҏ҂ƂĊm肵Ă郆[U[
* @param  guestUsers   Ҏ҂̃thL[Xg
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void PssBattleMatchingInfo::SetupHost( const gflnet::friends::FriendKey &hostUser,
                                       u32 ticketID,
                                       app::pss::pss_rule_select::E_PSS_BATTLE_TYPE battleType,
                                       app::pss::pss_rule_select::E_PSS_BATTLE_RULE battleRule,
                                       bool isHandicap,
                                       u32 guestUserNum,
                                       gflnet::friends::FriendKey *guestUsers )
{
  m_hostUser = hostUser;
  m_ticketID = ticketID;

  m_battleSetting.m_battleType = battleType;
  m_battleSetting.m_battleRule  = battleRule;
  m_battleSetting.m_isHandicap  = isHandicap;

  m_guestUserNum = guestUserNum;
  GFL_ASSERT( (guestUserNum<=3) );

  for( u32 i = 0; i < guestUserNum; i++ )
  {
    m_guestUser[i] = guestUsers[i];
  }
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ΐog[擾
*
* @param  none
*
* @return ΐog̃[
*/
//--------------------------------------------------------------------------------------------
app::pss::pss_rule_select::PssRuleSettingInfo PssBattleMatchingInfo::GetPssBattleSetting( void ) const
{
  return m_battleSetting;
}

//--------------------------------------------------------------------------------------------
/**
* @brief  ΐogÎ҂̃thL[擾
*
* @param  none
*
* @return ΐog̃[
*/
//--------------------------------------------------------------------------------------------
gflnet::friends::FriendKey PssBattleMatchingInfo::GetHostUser( void ) const
{
  return m_hostUser;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ΐogŏҎ҂ƂĊm肵ĂQXg[U[擾
*
* @param  none
*
* @return ҂ĂQXg[U[
*/
//--------------------------------------------------------------------------------------------
u32  PssBattleMatchingInfo::GetGuestNum( void ) const
{
  return m_guestUserNum;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ΐogŏҎ҂ƂĊm肵ĂQXg[U[擾
*
* @param  none
*
* @return w`Pbg̑ΐ}b`OƈvȂtrueԋp
*/
//--------------------------------------------------------------------------------------------
bool PssBattleMatchingInfo::IsSameTicket( const gflnet::friends::FriendKey &hostUser, u32 ticketID ) const
{
  return (ticketID==m_ticketID) && netapp::pss::PssPersonalData::IsSameFriendKey(m_hostUser, hostUser);
}



}		// pss
}		// netapp

