//======================================================================
/**
 * @file  btlv_preload_data.h
 * @brief og` \[Xǂ݊Ǘ(ZGtFNgp)
 * @author  ariizumi
 * @data  10/11/10
 */
//======================================================================
#ifndef __BTLV_PRELOAD_DATA_H__
#define __BTLV_PRELOAD_DATA_H__

#pragma once

#include "btlv_types.h"
#include "btlv_local_def.h"

namespace btl
{

typedef struct
{
  gfl::fs::ArcFile::ARCID mArcId;
  u32 mDatId;
  void *mBuf;
  
  nw::ut::LinkListNode mNode;
  
}BTLV_PRELOAD_DATA;

typedef nw::ut::LinkList<BTLV_PRELOAD_DATA,offsetof(BTLV_PRELOAD_DATA,mNode)> PreloadDataList;


class BtlvPreLoadSys
{
public:
  BtlvPreLoadSys(BattleViewSystem* core);
  void LoadRequest( gfl::fs::ArcFile::ARCID arcId , u32 datId );
  void ReleaseAll(void);
  
  bool IsFinishLoad(void);
  
  
  void* GetDataBuf( gfl::fs::ArcFile::ARCID arcId , u32 datId );

  void Dump(void);
  
private:

  bool IsLoadReqestData( gfl::fs::ArcFile::ARCID arcId , u32 datId );

  BattleViewSystem* mBtlvCore;
  
  PreloadDataList mList;

};


} //namespace btl

#endif //__BTLV_PRELOAD_DATA_H__
