//======================================================================
/**
 * @file  btlv_preload_data.cpp
 * @brief og` \[Xǂ݊Ǘ(ZGtFNgp)
 * @author  ariizumi
 * @data  10/11/10
 */
//======================================================================
#include <gflib.h>
#include "btlv_core.h"
#include "btlv_model.h"


namespace btl
{

BtlvPreLoadSys::BtlvPreLoadSys(BattleViewSystem* core)
  :mBtlvCore(core)
{
  
}

void BtlvPreLoadSys::LoadRequest( gfl::fs::ArcFile::ARCID arcId , u32 datId )
{
  gfl::fs::FileReadManager *readMng = mBtlvCore->GetFileReadManager();
  
  //荇
  return;
  
  if( IsLoadReqestData( arcId , datId ) == true )
  {
    return;
  }
  
  ARIIZUMI_PRINT("PreLoad[%2d][%3d]\n",arcId,datId);
  
  gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
  gfl::heap::HeapBase *devMem =  mBtlvCore->GetDeviceMem();
  BTLV_PRELOAD_DATA *loadData = GFL_NEW(heapMem)BTLV_PRELOAD_DATA();
  
  loadData->mArcId = arcId;
  loadData->mDatId = datId;
  
  readMng->AddReadRequest( &loadData->mBuf ,
                          NULL ,
                          devMem ,
                          128 ,
                          loadData->mArcId ,
                          loadData->mDatId ,
                          false );
  
/*
  if( loadData->mArcId == ARCID_WAZA_MODEL )
  {
    loadData->mBuf = GflHeapAllocMemoryAlign( devMem , mBtlvCore->GetArcWazaModel()->GetDataSize(loadData->mDatId) , 128);
    mBtlvCore->GetArcWazaModel()->LoadData( loadData->mDatId , loadData->mBuf );
  }
  else
  if( loadData->mArcId == ARCID_WAZA_PARTICLE )
  {
    loadData->mBuf = GflHeapAllocMemoryAlign( devMem , mBtlvCore->GetArcParticle()->GetDataSize(loadData->mDatId) , 128 );
    mBtlvCore->GetArcParticle()->LoadData( loadData->mDatId , loadData->mBuf );
  }
*/
                            
  mList.push_back( loadData );
}

void BtlvPreLoadSys::ReleaseAll(void)
{
  for (PreloadDataList::Iterator it = mList.begin(); it != mList.end();)
  {
    PreloadDataList::Iterator currIt = it++;
    BTLV_PRELOAD_DATA *node = &(*currIt);
    
    GflHeapFreeMemory( node->mBuf );
    
    mList.erase( node );
    GFL_DELETE node;
  }
  
  Dump();
}

bool BtlvPreLoadSys::IsFinishLoad(void)
{
  gfl::fs::FileReadManager *readMng = mBtlvCore->GetFileReadManager();
  //@todo t@CƂ̃`FbNȂĕCH
  return readMng->IsAllReadFinished();
}

void* BtlvPreLoadSys::GetDataBuf( gfl::fs::ArcFile::ARCID arcId , u32 datId )
{
  for (PreloadDataList::Iterator it = mList.begin(); it != mList.end();)
  {
    PreloadDataList::Iterator currIt = it++;
    BTLV_PRELOAD_DATA *node = &(*currIt);
    
    if( node->mArcId == arcId &&
        node->mDatId == datId )
    {
      //@todo ǂݍݏI҂H
      return node->mBuf;
    }
  }
  return NULL;
}


bool BtlvPreLoadSys::IsLoadReqestData( gfl::fs::ArcFile::ARCID arcId , u32 datId )
{
  for (PreloadDataList::Iterator it = mList.begin(); it != mList.end();)
  {
    PreloadDataList::Iterator currIt = it++;
    BTLV_PRELOAD_DATA *node = &(*currIt);
    
    if( node->mArcId == arcId &&
        node->mDatId == datId )
    {
      return true;
    }
  }
  return false;
}

void BtlvPreLoadSys::Dump(void)
{
#if defined(DEBUG_ONLY_FOR_ariizumi_nobuhiko)
  ARIIZUMI_PRINT("Dump PreLoadSys\n");
  for (PreloadDataList::Iterator it = mList.begin(); it != mList.end();)
  {
    PreloadDataList::Iterator currIt = it++;
    BTLV_PRELOAD_DATA *node = &(*currIt);
    
    ARIIZUMI_PRINT("[%2d][%3d][%08x]\n",node->mArcId,node->mDatId,node->mBuf);
  }
  ARIIZUMI_PRINT("Dump PreLoadSys\n");

#endif
}
  

} //namespace btl
