//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceGymRock.h
 *	@brief  WFj[NV[PX
 *
 */
//============================================================================
#ifndef __FIELDUNIQUESEQUENCEGYMROCK_H__
#define __FIELDUNIQUESEQUENCEGYMROCK_H__
#pragma once

// gflib
#include <gflib.h>

#include "trainer/trid_def.h"

// field
#include "field/Fieldmap.h"
#include "field/FieldUniqueSequence.h"

namespace field {

//=============================================================================
/** 
*   Wj[NV[PX
*/ 
//=============================================================================
class FieldUniqueSequenceGymRock : public FieldUniqueSequence
{
  GFL_FORBID_COPY_AND_ASSIGN(FieldUniqueSequenceGymRock);
 
public:
  
  //-------------------------------------
  ///	M~bN[N
  //=====================================
  typedef struct {
    int wall_idx;
  } ROCK_GYM_WORK;

private:

  // Of[^
  Fieldmap* mp_fieldmap;  ///< tB[h}bv
  
  // [N
  void* mp_work_buffer;   ///< M~bN[Nobt@[

public:
  //----------------------------------------------------------------------------
  /**
   *  @brief   RXgN^
   *
   *  @param   pFieldmap  tB[h}bv(̃NXŕێ܂)
   */
  //-----------------------------------------------------------------------------
  FieldUniqueSequenceGymRock(Fieldmap* pFieldmap);

  //----------------------------------------------------------------------------
  /**
   *  @brief   fXgN^
   */
  //-----------------------------------------------------------------------------
  virtual ~FieldUniqueSequenceGymRock();

  //----------------------------------------------------------------------------
  /**
   *  @brief   SETUP̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual b32 SetupLast(void);
 
  //----------------------------------------------------------------------------
  /**
   *  @brief   READY̍Ō1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void ReadyLastOnce(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŏɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateFirst(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateLast(void) 
  {
    return;
  }

  //----------------------------------------------------------------------------
  /**
   *  @brief   CALCULATĚɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void CalculateAfter(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   FREE̍ŏ1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void FreeFirstOnce(void);

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂ̃Zbg
   *
   *	@param	int wall_idx
   *
   *	@retval none
   */
  //-----------------------------------------------------------------------------
  void SetWall( int wall_idx );

  //----------------------------------------------------------------------------
  /**
   *	@brief  fAj[VJn
   *
   *	@param	
   *
   *	@retval
   */
  //-----------------------------------------------------------------------------
  void StartDemoAnimation( void );

  //----------------------------------------------------------------------------
  /**
   *	@brief  f̏I𒲂ׂ
   *
   *	@param	
   *
   *	@retval truêƂAj[VI
   */
  //-----------------------------------------------------------------------------
  b32 CheckDemoAnimationEnd( void );
};

} // namespace field

#endif		// __FIELDUNIQUESEQUENCEGYMROCK_H__

