//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceGymRock.cpp
 *	@brief  WFj[NV[PX
 *
 */
//============================================================================


// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"

// arc
#include "arc/arc_def.h"                   // ARCID_*

namespace field {

#include "climb_data.cdat"  

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	*pFieldmap tB[h}bv|C^
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceGymRock::FieldUniqueSequenceGymRock(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  mp_work_buffer(NULL)
{
  mp_fieldmap = pFieldmap;
}

//----------------------------------------------------------------------------
/**
 *	@brief@fXgN^
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceGymRock::~FieldUniqueSequenceGymRock()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  ZbgAbv
 *
 *	@param	none
 *
 *	@retval TRUEŏI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceGymRock::SetupLast(void)
{
  
  // q[v擾
  gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
  gfl::heap::HeapBase*     device_memory    = mp_fieldmap->GetDeviceHeapField();
  gfl::heap::NwAllocator*  device_allocator = mp_fieldmap->GetDeviceHeapFieldAllocator();

  {
    /// M~bN[N̏
    gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();

    // ATC̏ԂmFď
    b32 is_assigned = GimmickWorkAccessor::IsAssigned(
        p_gdata, GIMMICK_ID_GYM_ROCK);
    // ATCs
    GimmickWorkAccessor::SecondAssign( p_gdata, GIMMICK_ID_GYM_ROCK);
    // obt@[ۑ
    mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

    // ATCĂȂԂ̏ꍇ̓f[^
    if( is_assigned == FALSE )
    {
      ROCK_GYM_WORK gym_work;
      gfl::std::MemClear( &gym_work, sizeof(ROCK_GYM_WORK) );
      BufferAccessorType<ROCK_GYM_WORK>::SetValue(mp_work_buffer,0,gym_work);
    }
        
  }

  return TRUE;
}

void FieldUniqueSequenceGymRock::ReadyLastOnce(void)
{
}

void FieldUniqueSequenceGymRock::UpdateFirst(void)
{
#if 0  
  // ZbgAbvIĂs
  if( m_setup_seq != SETUP_END_SEQ )
  {
    return;
  }
  
  // vC[݂ȂƂsȂ
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
  if( p_player == NULL ){
    return;
  }
#endif  
}

//----------------------------------------------------------------------------
/**
 *  @brief   CALCULATĚɌĂ΂֐
 *
 *	@param	none
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymRock::CalculateAfter(void)
{
}

void FieldUniqueSequenceGymRock::FreeFirstOnce(void)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  ǂ̃Zbg
 *
 *	@param	int wall_idx
 *
 *	@retval none
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymRock::SetWall( int wall_idx )
{
  ROCK_GYM_WORK gym_work;
  if ( wall_idx != -1 )
  {
    //ǃf[^}bp[ɃZbg
    mp_fieldmap->GetMapper()->SetExpData( (void*)&ClimbData[wall_idx] );
  }
  else
  {
    //ǃf[^Zbg
    mp_fieldmap->GetMapper()->SetExpData( NULL );
  }
  gym_work = BufferAccessorType<ROCK_GYM_WORK>::GetValue(mp_work_buffer,0 );
  gym_work.wall_idx = wall_idx;
  BufferAccessorType<ROCK_GYM_WORK>::SetValue(mp_work_buffer,0,gym_work);
}


//----------------------------------------------------------------------------
/**
 *	@brief  ipAj[VĐ
 *
 *	@param	
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceGymRock::StartDemoAnimation( void )
{
  ///ROCK_GYM_WORK gym_work;
  ///gym_work = BufferAccessorType<ROCK_GYM_WORK>::GetValue(mp_work_buffer,0 );
  ///BufferAccessorType<ROCK_GYM_WORK>::SetValue(mp_work_buffer,0,gym_work);
}

//----------------------------------------------------------------------------
/**
 *	@brief  f̏I𒲂ׂ
 *
 *	@param	
 *
 *	@retval truêƂAj[VI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceGymRock::CheckDemoAnimationEnd( void )
{
  return true;
}

} // namespace field

