//============================================================================================
/**
 * @file		shinka_demo_main.h
 * @brief		C
 * @author	tamada
 * @date		12.05.15
 *
 * namespace	app::shinka_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#pragma	once

#include "app/util/app_util_heap.h"
#include "app/shinka_demo/shinka_demo.h"
#include "shinka_demo_graphic.h"
#include "shinka_demo_ui.h"


namespace app {
namespace shinka_demo {

// Tu[NiʑJڎɉj
typedef struct {
	GraphicWork * pGraWork;
	UI * ui;
}SUB_WORK;

// C[N
typedef struct {
	APP_PARAM * prm;

	int	mainSeq;
	int	nextSeq;
	int	fadeNextSeq;
}MAIN_WORK;


class MainSystem {
public:
	// Abvf[g̖߂l
	enum {
		UPDATE_CONTINUE = 0,
		UPDATE_FINISH,
	};

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	
	 */
	//--------------------------------------------------------------------------------------------
	int Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		AvI
	 *
	 * @param		none
	 *
	 * @retval	"true = I"
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool BreakFunc(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hCZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeIn( int next );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hAEgZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeOut( int next );

// CV[PX
public:
	int MainSeq_Init(void);
	int MainSeq_Release(void);
	int MainSeq_Fade(void);
	int MainSeq_Main(void);

private:
	MAIN_WORK	mainWork;		// C[N
	SUB_WORK * subWork;
	app::util::Heap	heap;
};

}		// shinka_demo
}		// app
