//============================================================================================
/**
 * @file		shinka_demo_main.cpp
 * @brief		C
 * @author	tamada
 * @date		12.05.15
 *
 * namespace	app::shinka_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "shinka_demo_main.h"
#include "shinka_demo_ui.h"
#include "gamesystem/ForcedReturnManager.h"


namespace app {
namespace shinka_demo {


//============================================================================================
//	萔`
//============================================================================================
// CV[PX`
enum {
	MAINSEQ_INIT = 0,
	MAINSEQ_RELEASE,
	MAINSEQ_FADE,
	MAINSEQ_MAIN,
	MAINSEQ_END
};

typedef int (MainSystem::*pSeqFunc)(void);


static const u32 SHINKA_DEMO_APP_HEAP_SIZE = 0x50000;			// Avp[Jq[vTCY
static const u32 SHINKA_DEMO_DEVICE_HEAP_SIZE = 0x50000;		// Avp[JfoCXq[vTCY

static const u32 SHINKA_DEMO_FADE_SYNC = 8;		// tF[hx

// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&MainSystem::MainSeq_Init,
	&MainSystem::MainSeq_Release,
	&MainSystem::MainSeq_Fade,
	&MainSystem::MainSeq_Main,
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm ) :
	subWork( NULL )
{
	mainWork.prm = prm;
	mainWork.mainSeq = MAINSEQ_INIT;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem()
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
int MainSystem::Update(void)
{
	MAIN_WORK * mwk = &mainWork;
	SUB_WORK * swk = subWork;

	if( BreakFunc() == true ){
		return UPDATE_FINISH;
	}

	mwk->mainSeq = (this->*MainSeq[mwk->mainSeq])();

	if( mwk->mainSeq == MAINSEQ_END ){
		return UPDATE_FINISH;
	}

	if( swk != NULL ){
		swk->pGraWork->Update();
	}

	return UPDATE_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
	SUB_WORK * swk = subWork;

	if( swk == NULL ){
		return;
	}

	subWork->pGraWork->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		AvI
 *
 * @param		none
 *
 * @retval	"true = I"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::BreakFunc(void)
{
	if( GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn( gamesystem::ForcedReturnManager::FORCERETURN_APP ) == true ){
		if( subWork != NULL ){
			/* ʂŃmۂꍇ͂ɒǉ */
			MainSeq_Release();
		}
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
	heap.Create( HEAPID_SHINKA_DEMO_APP, SHINKA_DEMO_APP_HEAP_SIZE, HEAPID_SHINKA_DEMO_DEVICE, SHINKA_DEMO_DEVICE_HEAP_SIZE );

	subWork = GFL_NEW( heap.pHeap )	SUB_WORK;

	subWork->ui = GFL_NEW( heap.pHeap )	UI( &heap );

	subWork->pGraWork = GFL_NEW( heap.pHeap ) GraphicWork( &heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
	GFL_DELETE	subWork->pGraWork;

	GFL_DELETE	subWork->ui;
	GFL_DELETE	subWork;
	subWork = NULL;

	heap.Delete();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeIn( int next )
{
	gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
	gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
	gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, SHINKA_DEMO_FADE_SYNC );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeOut( int next )
{
	gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, SHINKA_DEMO_FADE_SYNC, false );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Init(void)
{
	CreateSubWork();

	return SetFadeIn( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Release(void)
{
	DeleteSubWork();

	return mainWork.nextSeq;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Fade(void)
{
	if( gfl::grp::Fade_IsEnd() == true ){
		return mainWork.fadeNextSeq;
	}
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Main(void)
{
	if( subWork->ui->DEBUG_GetEndButton() == true ){
		mainWork.nextSeq = MAINSEQ_END;
		return SetFadeOut( MAINSEQ_RELEASE );
	}
	return MAINSEQ_MAIN;
}


}		// shinka_demo
}		// app

