//============================================================================================
/**
 * @file		shinka_demo_graphic.cpp
 * @brief		OtBbN֘A
 * @author	tamada
 * @date		12.05.15
 *
 * namespace	app::shinka_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
//#include "arc/arc_def.h"
#include "shinka_demo_graphic.h"
//#include "message/msg_shinka_demo.h"
//#include "shinka_demo_res.h"
//#include "shinka_demo_res_pane.h"


namespace app {
namespace shinka_demo {

static const u32 SHINKA_DEMO_MODEL_DATA_MAX = 1;		// ff[^o^


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap )
{
	CreateGraphicsSystem( heap );

	Create2D( heap );
	Create3D( heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork()
{
	Delete3D();
	Delete2D();

	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
	pG2dUtil->Update2D();
//	pG3dUtil->Update3D();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
//	pG2dUtil->Draw2D( pGraSystem, 0 );
//	pG3dUtil->Draw3D( pGraSystem );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateGraphicsSystem( app::util::Heap * heap )
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pGraSystem = gm->GetGraphicsSystem();
	pGraSystem->InitializeApplicationMemory( heap->pDevHeapAllocator );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteGraphicsSystem(void)
{
	pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create2D( app::util::Heap * heap )
{
	pG2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );
/*
	// \[Xf[^e[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
	{
	};
	// CAEgf[^
	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
	};
*/
	pG2dUtil->CreateLayoutSystem( heap );
//	pG2dUtil->SetDefaultFont( const char * file );
	pG2dUtil->CreateLayoutEnv( heap );
//	pG2dUtil->CreateLayoutWork( GFL_NELEMS(layoutData), heap );
//	pG2dUtil->CreateLayoutResource( GFL_NELEMS(resTbl), heap );
//	pG2dUtil->LoadLayoutResource( 0, resTbl, GFL_NELEMS(resTbl), heap, true );
//	pG2dUtil->TransferLayoutTexture();
//	pG2dUtil->SetLayoutWork( layoutData, 0, GFL_NELEMS(layoutData) );
//	pG2dUtil->CreateMessageData( const wchar_t * arcFilePath, u32 datID, gfl::str::MsgData::LoadType loadType, Heap * heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete2D(void)
{
//	pG2dUtil->DeleteMessageData();
//	pG2dUtil->DeleteLayoutResource();
//	pG2dUtil->DeleteLayoutWork2();
	pG2dUtil->DeleteLayoutEnv();
	pG2dUtil->DeleteLayoutSystem();

	GFL_DELETE	pG2dUtil;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create3D( app::util::Heap * heap )
{
	pG3dUtil = GFL_NEW( heap->pHeap ) app::util::G3DUtil();

	pG3dUtil->CreateG3dSystem( heap );
//	pG3dUtil->CreateG3dScene( app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, heap );

/*
#if 0		// JvOō쐬
	const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
	{
	};
	pG3dUtil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_DOUBLE, &dat[0], &dat[1] );
#else		// J\[Xǂݍ
	const app::util::G3DUtil::CAMERA_RES_DATA dat[] =
	{
	};
	pG3dUtil->CreateG3dCamera( dat, GFL_NELEMS(dat), heap );
	pG3dUtil->SetupCamera( 0, app::util::G3DUtil::SETUP_CAMERA_UPPER, heap );
	pG3dUtil->SetupCamera( 0, app::util::G3DUtil::SETUP_CAMERA_LOWER, heap );
#endif
*/

//	pG3dUtil->CreateG3dLight( gfl::fs::ArcFile::ARCID arcID, gfl::fs::ArcFile::ARCDATID datID, app::util::Heap * heap );

/*
	pG3dUtil->CreateG3dModelWork( heap, SHINKA_DEMO_MODEL_DATA_MAX );

	const app::util::G3DUtil::ANIME_DATA anmData = {
	};
	gfl::fs::ArcFile * af = GFL_NEW(  heap->pHeap  ) gfl::fs::ArcFile(  heap->pHeap , ARCID_PMAV_GRA, gfl::fs::ArcFile::OPEN );
	pG3dUtil->AddG3dModel( af, GARC_pmav_gra_025_K_idleA_BCMDL, heap, app::util::G3DUtil::ADD_MODEL_ID_FREE, &anmData, 1 );
	GFL_DELETE af;
	pG3dUtil->ChangeG3dModelAnime( 0, 0, heap );
*/

//	pG3dUtil->SetupG3dScene();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete3D(void)
{
/*
	for( int i=0; i<SHINKA_DEMO_MODEL_DATA_MAX; i++ ){
		pG3dUtil->DelG3dModel( i );
	}
	pG3dUtil->DeleteG3dModelWork();
*/
//	pG3dUtil->DeleteG3dLight();
//	pG3dUtil->DeleteG3dCamera();

//	pG3dUtil->DeleteG3dScene();
	pG3dUtil->DeleteG3dSystem();

	GFL_DELETE	pG3dUtil;
}


}	// shinka_demo
}	// app
