//============================================================================================
/**
 * @file		shinka_demo.cpp
 * @brief		Proc֘A
 * @author	tamada
 * @date		12.05.15
 *
 * namespace	app::shinka_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "app/shinka_demo/shinka_demo.h"
#include "shinka_demo_main.h"


namespace app {
namespace shinka_demo {

//============================================================================================
//	萔`
//============================================================================================
#define	SHINKA_DEMO_SYS_HEAP_SIZE		( 0x1000 )		// VXeq[vTCY


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc( APP_PARAM * prm )
{
	CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc()
{
	GFL_DELETE	pMain;
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	switch( pMain->Update() ){
	case MainSystem::UPDATE_CONTINUE:
		return gfl::proc::RES_CONTINUE;

	case MainSystem::UPDATE_FINISH:
		return gfl::proc::RES_FINISH;

	default:
		GFL_ASSERT( 0 );
		break;
	}

	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = GFL_CREATE_HEAP(
						gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
						HEAPID_SHINKA_DEMO_SYS, SHINKA_DEMO_SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}


}	// shinka_demo
}	// app
