//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		EventGymFairy.cpp
 *	@brief  dWpCxg
 *	@author	Masayuki Onoue
 *	@date		2012.05.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "EventGymFairy.h"
#include "field/FieldUniqueSequence.h"

namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//--------------------------------------------------------------
/**
 * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
 * @param   gmgr       Q[}l[W[NX
 * @retval  true  NĂ悢
 * @retval  false NȂ
 */
//--------------------------------------------------------------
bool EventGymFairy::BootChk(gamesystem::GameManager* gmgr)
{
  GFL_UNUSED(gmgr);
  return true;
}

//--------------------------------------------------------------
/**
 * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
 * @param   gmgr       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventGymFairy::InitFunc(gamesystem::GameManager* gmgr)
{
  GFL_UNUSED(gmgr);

  
  // [U[J
  FieldStereoCamera* camera = mp_fieldmap->GetGraphics()->GetCamera();
  camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NORMAL);

  // vC[݂ȂƂsȂ
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
  if( p_player == NULL ){
    return;
  }

}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   gmgr       Q[}l[W[NX
 * @return  GMEVENT_RESULT  Cxg֐̖߂l
 */
//--------------------------------------------------------------
gamesystem::GMEVENT_RESULT EventGymFairy::MainFunc(gamesystem::GameManager* gmgr)
{
  gamesystem::GMEVENT_RESULT res = gamesystem::GMEVENT_RES_CONTINUE;
  FieldStereoCamera* camera = mp_fieldmap->GetGraphics()->GetCamera();

  // vC[݂ȂƂsȂ
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
  if( p_player == NULL ){
    return gamesystem::GMEVENT_RES_FINISH;
  }
  
  // @f擾
  mmodel::MoveModel* p_pmdl = mp_fieldmap->GetFieldPlayer()->GetModel();

  switch( m_seq )
  {
  case 0:
    // GtFNgĐ
    m_seq++;
    break;
  case 1:
    // GtFNgI҂
    m_seq++;
    break;
  case 2:
    // lĈړ
    {
      // \
      p_pmdl->OnStatusBit( mmodel::MoveModelBase::STABIT_VANISH );
      // J̏ʒu擾
      camera->GetCameraPosition( m_cam_start_pos );
      ONOUE_PRINT("JZW=%f\n",m_cam_start_pos.z);
      // ړ
      MovePlayerPos();
      m_seq++;
    }
    break;
  case 3:
    // J
    {
      // ړlݒ
      gfl::math::VEC3 trans;
      GetCamBackTransVec( m_cam_start_pos, m_player_start_pos, trans );

      // JsړR}h𔭍s
      FieldStereoCamera::FldCamAnmTransArg arg;
      arg.liner.frame = 10;
      arg.liner.is_rowdata = true;
      camera->StartFldCamAnmTrans(trans,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);

      m_seq++;
    }
    break;
  case 4:
    // J̈ړ҂
    if (camera->IsExecutingFldCamAnmTrans() == false) {
      m_seq++;
    }
    break;
  case 5:
    {
      // [vɃJړ
      // ړlݒ
      gfl::math::VEC3 trans;
      GetCamLineTransVec( trans );

      // JsړR}h𔭍s
      FieldStereoCamera::FldCamAnmTransArg arg;
      arg.liner.frame = 10;
      arg.liner.is_rowdata = true;
      camera->StartFldCamAnmTrans(trans,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);
      m_seq++;
    }
    break;
  case 6:
    // J̈ړ҂
    if (camera->IsExecutingFldCamAnmTrans() == false) {
      gfl::math::VEC3 camera_now_pos;   // J݂̈ʒu
      camera->GetCameraPosition( camera_now_pos );
      ONOUE_PRINT("%f %f %f\n" ,camera_now_pos.x ,camera_now_pos.y ,camera_now_pos.z);
      m_seq++;
    }
    break;
  case 7:
    {
      // JIʒu܂ňړ
      // ړlݒ
      gfl::math::VEC3 trans;
      gfl::math::VEC3 param_cam_pos;    // p[^vZJʒu
      camera->GetCameraPositionFromParameter( m_player_end_pos ,param_cam_pos );
      GetCamBackTransVec( param_cam_pos, m_player_end_pos , trans );

      // ړ𔽓]
      trans *= -1;

      // JsړR}h𔭍s
      FieldStereoCamera::FldCamAnmTransArg arg;
      arg.liner.frame = 10;
      arg.liner.is_rowdata = true;
      camera->StartFldCamAnmTrans(trans,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);

      m_seq++;
    }
    break;
  case 8:
    // J̈ړ҂
    if (camera->IsExecutingFldCamAnmTrans() == false) {
      m_seq++;
    }
    break;
  case 9:
    // l\
    {
      p_pmdl->OffStatusBit( mmodel::MoveModelBase::STABIT_VANISH );
      m_seq++;
    }
    break;

  case 10:
    // CxgI
    res = gamesystem::GMEVENT_RES_FINISH;
    break;
  }


  return res;
}

//--------------------------------------------------------------
/**
 * @brief   Ăяo֐ z֐
 * @param   gmgr       Q[}l[W[NX
 */
//--------------------------------------------------------------
void EventGymFairy::EndFunc(gamesystem::GameManager* gmgr)
{
  GFL_UNUSED(gmgr);
   
  // [U[JI
  FieldStereoCamera* camera = mp_fieldmap->GetGraphics()->GetCamera();
  camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NONE);

}

//----------------------------------------------------------------------------
/**
 *	@brief @̈ʒup[^ɍ킹Ĉړ
 */
//-----------------------------------------------------------------------------
void EventGymFairy::MovePlayerPos( void )
{
  // vC[Obh擾
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();

  // @̃[vOʒu擾
  p_player->GetPos( &m_player_start_pos );

  // vC[݂̑Obh擾
  gfl::math::VEC3 now_pos;
  const Grid* cp_playergrid = p_player->GetGrid();

  // ObhW擾
  cp_playergrid->GetTranslate( &now_pos );

  // Obh̍쐬
  const mmodel::Manager* cp_manager = mp_fieldmap->GetMoveModelManager();
  const Mapper* cp_mapper = cp_manager->GetMapper();
  Grid grid( cp_mapper->GetRailSystem(), cp_mapper );

  // Obhݒ
  now_pos.x += 8;
  now_pos.z += 3;

  // ʒuݒ
  grid.SetTranslate( &now_pos );

  // Obhf[^ݒ
  mmodel::MoveModel* p_pmdl = mp_fieldmap->GetFieldPlayer()->GetModel();
  p_pmdl->UpdateGridPos( grid );
  
  // [v̈ʒuۑ
  p_player->GetPos( &m_player_end_pos );

}
//----------------------------------------------------------------------------
/**
 *	@brief @̈ړvZ
 */
//-----------------------------------------------------------------------------
void EventGymFairy::GetCamLineTransVec( gfl::math::VEC3& trans )
{
  // [U[J
  gfl::math::VEC3 back_pos;
  gfl::math::VEC3 camera_trans_pos; // JړڕWʒu
  gfl::math::VEC3 camera_now_pos;   // J݂̈ʒu
  gfl::math::VEC3 param_cam_pos;    // p[^vZJʒu
  FieldStereoCamera* camera = mp_fieldmap->GetGraphics()->GetCamera();
  camera->GetCameraPosition( camera_now_pos );

  // ړ̃Jʒuʒu܂ł̃xNg擾
  camera->GetCameraPositionFromParameter( m_player_end_pos ,param_cam_pos );
  GetCamBackTransVec( param_cam_pos, m_player_end_pos , back_pos);

  // J̖ڕWʒu
  param_cam_pos = param_cam_pos + back_pos;
  
  // ݂̃JʒuڕWʒu܂ł̈ړxNg
  trans = param_cam_pos - camera_now_pos;
}

//----------------------------------------------------------------------------
/**
 *	@brief  JԂɂ邽߂̈ړxNg擾
 *
 *	@param	cam_pos     Jʒu
 *	@param	player_pos  vC[ʒu
 *	@param	pos         JړxNg
 */
//-----------------------------------------------------------------------------
void EventGymFairy::GetCamBackTransVec( const gfl::math::VEC3& cam_pos ,const gfl::math::VEC3& player_pos ,gfl::math::VEC3& pos )
{
  gfl::math::VEC3 v = cam_pos - player_pos; // @J
  
  // KAxNg
  v.Normalize();

  // Zlwnɂ邽߂̊glvZ
  f32 rate = (MOVE_CAM_Z_POS - cam_pos.z)/v.z;

  // g債xNgړxNg
  pos = v * rate;
}

}  // namespace field

