#if PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		KawadaDebugUtil.cpp
 *	@brief  fobOp̃[eBeB
 *	@author	Koji Kawada
 *	@date		2012.05.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "system/main.h"           // HEAP_DEFINE

// test/kawada
#include "KawadaDebugUtil.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace test {
namespace kawada {
namespace util {

// 
void AllSystem::CreateMemory(void)
{
  // Y`FbN
  dumpMemory("[Start]");

  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  GFL_PRINT("heap_memory   GetTotalAllocatableSize=%d\n", heap_memory->GetTotalAllocatableSize());
  GFL_PRINT("device_memory GetTotalAllocatableSize=%d\n", device_memory->GetTotalAllocatableSize());
 
  gfl::heap::HeapBase* l_heap_memory   = GFL_CREATE_HEAP(
      heap_memory,   HEAPID_TEST_KAWADA_HEAP,   heap_memory->GetTotalAllocatableSize(),   gfl::heap::HEAP_TYPE_EXP, false );
  gfl::heap::HeapBase* l_device_memory = GFL_CREATE_HEAP(
      device_memory, HEAPID_TEST_KAWADA_DEVICE, device_memory->GetTotalAllocatableSize(), gfl::heap::HEAP_TYPE_EXP, false );
}
// j
void AllSystem::DestroyMemory(void)
{
  gfl::heap::HeapBase* l_heap_memory   = GetHeapMemory();
  gfl::heap::HeapBase* l_device_memory = GetDeviceMemory();

  gfl::heap::Manager::DeleteHeap(l_device_memory);
  gfl::heap::Manager::DeleteHeap(l_heap_memory);

  // Y`FbN
  dumpMemory("[End]");
}

// 擾
gfl::heap::HeapBase* AllSystem::GetHeapMemory(void)
{
  gfl::heap::HeapBase* l_heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_TEST_KAWADA_HEAP );
  return l_heap_memory;
}
gfl::heap::HeapBase* AllSystem::GetDeviceMemory(void)
{
  gfl::heap::HeapBase* l_device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_TEST_KAWADA_DEVICE );
  return l_device_memory;
}

// Y`FbN
void AllSystem::dumpMemory(const char* message)  // s͂Ȃł
{
  // 
  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  // Y`FbN
  GFL_PRINT("%s\n", message);
  GFL_PRINT("heap_memory\n");
  heap_memory->Dump();
  GFL_PRINT("\n");
  GFL_PRINT("device_memory\n");
  device_memory->Dump();
  GFL_PRINT("\n");
}

// RXgN^
AllSystem::AllSystem(void)
{
  gfl::heap::HeapBase* l_heap_memory   = GetHeapMemory();
  gfl::heap::HeapBase* l_device_memory = GetDeviceMemory();

  // AP[^
  {
    m_heap_allocator   = GFL_NEW(l_heap_memory)   gfl::heap::NwAllocator(l_heap_memory);
    m_device_allocator = GFL_NEW(l_device_memory) gfl::heap::NwAllocator(l_device_memory);
  }

  // ui
  m_device_manager = GFL_NEW(l_heap_memory) gfl::ui::CTR_DeviceManager(l_heap_memory);

  // t@C[h}l[W
  {
    m_file_read_manager = GFL_NEW(l_heap_memory) gfl::fs::FileReadManager(
      l_heap_memory,
      ARCID_TABLE_MAX,
      5,
      gfl::base::Thread::DefaultPriority + 1
    );
  }

  // OtBbNXVXe
  gfl::grp::GraphicsSystemSetUp setup = gfl::grp::GraphicsSystemSetupDefault;
  setup.buffer_mode = gfl::grp::MODE_SINGLE_BUFFER;  // obt@O[h
  setup.stereoOn = true;  // ̎On
  m_graphics_system = GFL_NEW(l_heap_memory) gfl::grp::GraphicsSystem( m_heap_allocator, m_device_allocator, &setup );

  // DrawUtil 
  gfl::grp::util::DrawUtil::Initialize( m_graphics_system, m_heap_allocator, m_device_allocator );

  // grp::util
  {
    nn::fs::FileReader	file;
  	nn::fs::FileWriter	wfile;
  	size_t				fileSize;
  	
    file.Initialize( L"rom:/ishiguro/ShaderTest/HgpPop.bcfnt" );
    
    fileSize = file.GetSize();
    m_bcFontBuffer = m_device_allocator->Alloc(fileSize, 128);
    file.Read( m_bcFontBuffer, fileSize );
    file.Finalize();

    //ʏōs܂̂GraphcsSystemʉĂAriizumi11/06/02
    gfl::grp::util::DrawUtil::SetFontResource( m_bcFontBuffer );
  }
}

// fXgN^ 
AllSystem::~AllSystem()
{
  // t@C[h}l[W
  GFL_DELETE m_file_read_manager;

  // grp::util
  {
    m_device_allocator->Free(m_bcFontBuffer);
  }

  // DrawUtil 
  gfl::grp::util::DrawUtil::Terminate();

  // OtBbNXVXe
  GFL_DELETE m_graphics_system;

  // ui
  GFL_DELETE m_device_manager;

  // AP[^
  {
    GFL_DELETE  m_device_allocator;
    GFL_DELETE  m_heap_allocator;
  }
}

// vZ
void AllSystem::Calculate(void)
{
  // ui
  m_device_manager->Main();
  
  // t@C[h}l[W
  m_file_read_manager->UpdateFileRead();
}

// `
void AllSystem::StartRendering(void)
{
  // `Jn
  m_graphics_system->StartRendering();
}

void AllSystem::EndRendering(void)
{
  // `I
  m_graphics_system->EndRendering();

  // `XV
  m_graphics_system->SwapBuffer();

  gfl::grp::GraphicsSystem::WaitVSync(gfl::grp::DISPLAY_BOTH_MAX);
   
  // obt@Xbv
  m_graphics_system->VSyncAfter();
}

void AllSystem::BeginDrawUtil(gfl::grp::DisplayType display_type)
{
  gfl::grp::RenderTarget* render_target = m_graphics_system->GetFrameBufferManager()->\
      GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( display_type ) );
  
  m_graphics_system->BindCurrentCommandList( render_target );

  // ȈՕ`Jn
  gfl::grp::util::DrawUtil::BeginRender( render_target );
}
void AllSystem::EndDrawUtil(void)
{
  // ȈՕ`I
  gfl::grp::util::DrawUtil::EndRender();
}


}  // namespace util
}  // namespace kawada
}  // namespace test

#endif // PM_DEBUG

