#if PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		DressUpCharacterTest.h
 *	@brief  ւLN^}l[W̃eXg
 *	@author	Koji Kawada
 *	@date		2012.05.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "system/main.h"           // HEAP_DEFINE
#include "gamesystem/GameProc.h"

// dress_up
#include "system/dress_up/DressUpInclude.h"

// test/kawada
#include "DressUpCharacterTest.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 

// btlv
#include "../../../../src/battle/btlv/btlv_mdl_trainer.h"  // og[V̒`
#include "../../../../src/field/movemodel/Move3DModelMotion.h"  // tB[h[V̒`
                   // src/field/movemodel/motion/tr0001.h


namespace test {
namespace kawada {
namespace dress_up_character_test {


//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterTestProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  test::kawada::util::AllSystem::CreateMemory();
  
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  m_util_sys = GFL_NEW(heap_memory) test::kawada::util::AllSystem;

  gfl::heap::NwAllocator* heap_allocator   = m_util_sys->GetHeapAllocator();
  gfl::heap::NwAllocator* device_allocator = m_util_sys->GetDeviceAllocator();

  // g3d
  {
    // VXe
    gfl::grp::g3d::System::Description sys_des;
    sys_des.resource_object_num_max = 1024;
    sys_des.model_object_num_max    = 1024;
    m_system = GFL_NEW(heap_memory) gfl::grp::g3d::System( heap_allocator, device_allocator, &sys_des );
    
    // V[ 
    m_scene  = GFL_NEW(heap_memory) gfl::grp::g3d::Scene( device_allocator );
 
    // J
    m_camera = GFL_NEW(heap_memory) gfl::debug::DebugG3dStereoCamera();
    m_camera->Create(
        device_allocator,
        gfl::math::VEC3(0.0f, 0.0f, 45.0f),
        gfl::math::VEC3(0.0f, 0.0f, 0.0f)
    );
    m_camera->SetAspect(400.0f/240.0f);
    m_scene->AddSceneNode( m_camera );
  }

  // DressUpCharacterManager
  initializeDressCharaSeq();

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterTestProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  gfl::ui::DeviceManager* device_manager = m_util_sys->GetDeviceManager();
  gfl::grp::GraphicsSystem* graphics_system = m_util_sys->GetGraphicsSystem();

  gfl::ui::Button*       button    = device_manager->GetButton(0);
  gfl::ui::VectorDevice* cross_key = device_manager->GetCrossKey(0);
  gfl::ui::VectorDevice* stick     = device_manager->GetStick(0);

  //////////////////////
  //////// vZ ////////
  //////////////////////
  m_util_sys->Calculate();

  // g3d  // J
  m_camera->Control(device_manager);

  // DressUpCharacterManager
  updateDressCharaSeqBefore();

  // g3d  // vZ
  m_scene->Calculate();

  // DressUpCharacterManager
  updateDressCharaSeqAfter();

  // g3d  // SubmitView
  m_scene->SubmitView(m_camera, true,  true);

  //////////////////////
  //////// ` //////// 
  //////////////////////
  {
    m_util_sys->StartRendering();

    gfl::grp::RenderTarget* lower_render_target       = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_LOWER ) );
    gfl::grp::RenderTarget* upper_render_target       = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    gfl::grp::RenderTarget* upper_right_render_target = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER_RIGHT ) );

    // g3d
    {
      m_scene->CommandSaveStereoDraw(
          graphics_system,
          m_camera,
          upper_render_target,
          upper_right_render_target
      );
    }

    // ȈՕ`
    {
      m_util_sys->BeginDrawUtil(gfl::grp::DISPLAY_LOWER);
   
      gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
      gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );   // オ(0, 0)
 
      //s32 text_x_pos = 4;
      s32 text_y_pos = 4;
      const s32 text_y_pos_add = 12;
 
      const s32 text_x_pos_page = 16;

      {
        gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_page, text_y_pos, L"[ւLN^}l[W̃eXg]" );
        text_y_pos += text_y_pos_add;
      }
    
      m_util_sys->EndDrawUtil();
    }
    
    m_util_sys->EndRendering();
  }

  //////////////////////////
  //////// I ////////
  //////////////////////////
  if( button->IsTrigger( gfl::ui::BUTTON_START ) )
  {
    if( m_dress_chara_seq < DRESS_CHARA_SEQ_DESTROY_START )
    {
      m_dress_chara_seq = DRESS_CHARA_SEQ_DESTROY_START;
    }
  }
  if( m_dress_chara_seq == DRESS_CHARA_SEQ_DESTROY_END )
  {
    return gfl::proc::RES_FINISH;
  }
  else
  {
    return gfl::proc::RES_CONTINUE;
  }
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterTestProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  // g3d
  {
    m_scene->DestroyOwnObject();
    GFL_DELETE m_camera;
    GFL_DELETE m_scene;
    GFL_DELETE m_system;
  }

  GFL_DELETE m_util_sys;

  test::kawada::util::AllSystem::DestroyMemory();

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  DressUpCharacterManager
 */
//------------------------------------------------------------------
void DressUpCharacterTestProc::initializeDressCharaSeq(void)
{
  m_dress_chara_seq = DRESS_CHARA_SEQ_CREATE_START;
  
  m_dress_up_character_manager = NULL;

  for(s32 i=0; i<DRESS_UP_CHARACTER_MAX_NUM; ++i)
  {
    m_dress_up_character_id[i] = xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE;
    m_dress_chara_state[i] = DRESS_CHARA_STATE_CREATE;
  }


  m_dress_up_chara_env_manager = NULL;
  m_dress_up_chara_env_id = xy_system::dress_up::DressUpCharaEnvManager::CHARA_ENV_ID_NONE;
}

void DressUpCharacterTestProc::updateDressCharaSeqBefore(void)
{
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  gfl::heap::NwAllocator*   heap_allocator    = m_util_sys->GetHeapAllocator();
  gfl::heap::NwAllocator*   device_allocator  = m_util_sys->GetDeviceAllocator();
  gfl::fs::FileReadManager* file_read_manager = m_util_sys->GetFileReadManager();

  switch(m_dress_chara_seq)
  {
  case DRESS_CHARA_SEQ_CREATE_START:
    {
      // }l[W
      m_dress_up_character_manager = GFL_NEW(heap_memory) xy_system::dress_up::DressUpCharacterManager(
          file_read_manager,
          heap_memory,
          heap_memory,
          device_memory,
          heap_memory,
          DRESS_UP_CHARACTER_MAX_NUM
      );

      // L
      {
        m_dress_up_chara_env_manager = GFL_NEW(heap_memory) xy_system::dress_up::DressUpCharaEnvManager(heap_memory, 1);
        
        m_dress_up_chara_env_id = m_dress_up_chara_env_manager->CreateCharaEnv(
          heap_allocator,
          device_allocator,
          0
        );
        m_dress_up_chara_env_manager->AddCharaEnvToScene(
          m_dress_up_chara_env_id,
          m_scene,
          0
        );
        m_dress_up_chara_env_manager->AssignCharaEnv(
          m_dress_up_chara_env_id,
          m_scene
        );
      }
      
      // LN^
      xy_system::dress_up::Individual individual[DRESS_UP_CHARACTER_MAX_NUM];
      for(s32 i=0; i<1; ++i)
      {
        {
          individual[i].section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
          individual[i].model_type   = xy_system::dress_up::MODEL_TYPE_HEROINE;
          individual[i].change_flag  = true;
          individual[i].fashion      = &xy_system::dress_up::HEROINE_FASHION_DEFAULT;
        }
        m_dress_up_character_id[i] = m_dress_up_character_manager->RequestAsyncCreateObject(
            heap_memory,
            heap_allocator,
            heap_allocator,
            device_allocator,
            &(individual[i]),
            heap_memory
        );
        m_dress_chara_state[i] = DRESS_CHARA_STATE_CREATE;
      }

      ++m_dress_chara_seq;
      break;
    }
  case DRESS_CHARA_SEQ_CREATE_NOW:
    {
      b32 create_end = true;
      for(s32 i=0; i<1; ++i)
      {
        if( m_dress_chara_state[i] == DRESS_CHARA_STATE_CREATE )
        {
          // LN^
          if( m_dress_up_character_manager->DoesExistObject(m_dress_up_character_id[i]) )
          {
            // LN^
            // LN^̃fV[ɒǉ
            m_dress_up_character_manager->AddCharacterModelToScene(
              m_dress_up_character_id[i],
              m_scene,
              0,
              0
            );
            // LN^̃[Vݒ肷
            m_dress_up_character_manager->GetCharacterMotion(m_dress_up_character_id[i])->\
              Change( btl::BTLV_TRAINER_MOTION_BALL + gfl::motion::MotionBase::MOTION_BEGIN );  // @todo btlv_mdl_trainer.h̒`͕ς邩܂B
            //m_dress_up_character_manager->GetCharacterMotion(m_dress_up_character_id[i])->\
            //  Change( PLAYER_tr0001_00_fi20_walk01 );  // tB[h̃f̃[Vgp
            m_dress_chara_state[i] = DRESS_CHARA_STATE_ADD_TO_SCENE;
          }
          else
          {
            create_end = false;
          }
        }
      }
      if( create_end )
      {
        ++m_dress_chara_seq;
      }
      break;
    }
  case DRESS_CHARA_SEQ_CREATE_END:
    {
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_START:
    {
      b32 destroy_start = true;
      for(s32 i=0; i<1; ++i)
      {
        if( m_dress_chara_state[i] == DRESS_CHARA_STATE_ADD_TO_SCENE )
        {
          // LN^̃fV[O  // 1t[҂ĂjsƁI
          m_dress_up_character_manager->RemoveCharacterModelFromScene(
              m_dress_up_character_id[i],
              m_scene
          );
          m_dress_chara_state[i] = DRESS_CHARA_STATE_REMOVE_FROM_SCENE;
          destroy_start = false;
        }
        else
        {
          if( m_dress_chara_state[i] != DRESS_CHARA_STATE_DESTROY )
          {
            // LN^j
            m_dress_up_character_manager->RequestAsyncDestroyObject(
                m_dress_up_character_id[i]
            );
            m_dress_chara_state[i] = DRESS_CHARA_STATE_DESTROY;
          }
        }
      }
      if( destroy_start )
      {
        ++m_dress_chara_seq;
      }
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_NOW:
    {
      b32 destroy_end = true;
      for(s32 i=0; i<1; ++i)
      {
        // LN^j
        if( m_dress_up_character_id[i] != xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE )
        {
          if( m_dress_up_character_manager->DoesNotExistObject(m_dress_up_character_id[i]) )
          {
            // LN^j
            m_dress_up_character_id[i] = xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE;
          }
          else
          {
            destroy_end = false;
          }
        }
      }
      if( destroy_end )
      {
        // jł悤ɂȂ܂ő҂
        if( m_dress_up_character_manager->IsAbleToDestroy() )
        {
          // Lj
          {
            GFL_DELETE m_dress_up_chara_env_manager;
            m_dress_up_chara_env_manager = NULL;
          }

          // }l[Wj
          GFL_DELETE m_dress_up_character_manager;
          m_dress_up_character_manager = NULL;
          
          ++m_dress_chara_seq;
        }
      }
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_END:
    {
      break;
    }
  }

  // OvZ
  if( m_dress_up_character_manager )
  {
    m_dress_up_character_manager->CalculateBefore();
  }
}

void DressUpCharacterTestProc::updateDressCharaSeqAfter(void)
{
  // vZ
  if( m_dress_up_character_manager )
  {
    m_dress_up_character_manager->CalculateAfter();
  }
}

}  // namespace dress_up_character_test
}  // namespace kawada
}  // namespace test

#endif // PM_DEBUG

