//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file    DressUpCharacterManager.cpp
 *  @brief   ւLN^}l[W
 *  @author  Koji Kawada
 *  @date    2012.05.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>

// motion
#include "../../../src/system/motion/BaseMotionCharacter.h"

// dress_up
#include "system/dress_up/DressUpDefine.h"
#include "system/dress_up/DressUpFashion.h"
#include "system/dress_up/DressUpManager.h"
#include "system/dress_up/DressUpIModel.h"
#include "system/dress_up/DressUpModelBuilder.h"
#include "system/dress_up/DressUpResourceBuilder.h"
#include "system/dress_up/ObjectManager.h"

#include "system/dress_up/DressUpCharacterManager.h"

// arc
#include "arc/arc_def.h"            // ARCID_
#include "arc/movemodel.gaix"
#include "arc/battle_3d.gaix"


namespace xy_system {
namespace dress_up {


//-----------------------------------------------------------------------------
/**
 *     NX`
 */
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *     @brief  ւLN^}l[W
 */
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// RXgN^ / fXgN^
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  RXgN^
 */
//-----------------------------------------------------------------------------
DressUpCharacterManager::DressUpCharacterManager(
  gfl::fs::FileReadManager* file_read_manager,
  gfl::heap::HeapBase*      manager_instance_heap_memory,
  gfl::heap::HeapBase*      manager_parent_heap_memory,
  gfl::heap::HeapBase*      manager_parent_device_memory,
  gfl::heap::HeapBase*      character_manager_heap_memory,
  s32                       character_max_num
)
{
  CharacterManagerCreateArg arg =
  {
    manager_instance_heap_memory,
    manager_parent_heap_memory,
    manager_parent_device_memory,
    character_manager_heap_memory,
  };

  b32 ret = createObjectManager(
    file_read_manager,
    character_manager_heap_memory,
    character_max_num,
    arg
  );

  GFL_ASSERT_MSG(ret, "ł܂łB\n");
}

//-----------------------------------------------------------------------------
/**
 *     @brief  fXgN^
 */
//-----------------------------------------------------------------------------
DressUpCharacterManager::~DressUpCharacterManager()
{
  destroyObjectManager();
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// LN^ / LN^j
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  LN^NGXg
 */
//-----------------------------------------------------------------------------
s32 DressUpCharacterManager::RequestAsyncCreateObject(
  gfl::heap::HeapBase*    character_manager_heap_memory,     
  gfl::heap::NwAllocator* model_instance_heap_allocator,
  gfl::heap::NwAllocator* model_heap_allocator,          
  gfl::heap::NwAllocator* model_device_allocator,       
  const Individual*       model_individual,             
  gfl::heap::HeapBase*    motion_heap_memory
)
{
  CharacterCreateArg arg =
  {
    model_instance_heap_allocator,
    model_heap_allocator,          
    model_device_allocator,       
    motion_heap_memory
  };

  return DressUpSuperCharacterManager::RequestAsyncCreateObject(
    character_manager_heap_memory,
    arg,
    model_individual
  );
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// 擾 / ݒ
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  LN^̃f擾
 */
//-----------------------------------------------------------------------------
DressUpIModel* DressUpCharacterManager::GetCharacterModel(
  s32 object_id
)
{
  DressUpIModel* model = NULL;
  if( isObjectManagerCreated() )
  {
    CharacterData* object = GetObject(object_id);
    if( object )
    {
      if(object->state == STATE_CREATED)
      {
        model = object->model;
      }
    }
  }
  return model;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  LN^̃[V擾
 */
//-----------------------------------------------------------------------------
proj::motion::BaseMotionCharacter* DressUpCharacterManager::GetCharacterMotion(
  s32 object_id
)
{
  proj::motion::BaseMotionCharacter* motion = NULL;
  if( isObjectManagerCreated() )
  {
    CharacterData* object = GetObject(object_id);
    if( object )
    {
      if(object->state == STATE_CREATED)
      {
        motion = object->motion;
      }
    }
  }
  return motion;
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// V[ɓo^ / V[O
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  V[ɓo^
 */
//-----------------------------------------------------------------------------
b32 DressUpCharacterManager::AddCharacterModelToScene(
  s32 object_id,
  gfl::grp::g3d::Scene* scene,
  s32 scene_calculate_group_index,
  s32 scene_draw_group_index
)
{
  b32 ret = false;
  if( isObjectManagerCreated() )
  {
    CharacterData* object = GetObject(object_id);
    if( object )
    {
      if(object->state == STATE_CREATED)
      {
        object->model->AddToScene(scene, scene_calculate_group_index, scene_draw_group_index);
        ret = true;
      }
    }
  }
  return ret;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  V[O
 */
//-----------------------------------------------------------------------------
void DressUpCharacterManager::RemoveCharacterModelFromScene(
  s32 object_id,
  gfl::grp::g3d::Scene* scene
)
{
  if( isObjectManagerCreated() )
  {
    CharacterData* object = GetObject(object_id);
    if( object )
    {
      if(object->state == STATE_CREATED)
      {
        object->model->RemoveFromScene(scene);
      }
    } 
  }
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// Jo
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
b32 DressUpCharacterManager::subCreateObjectManager(
  CharacterManagerCreateArg arg
)
{
  // ւ}l[W
  xy_system::dress_up::DressUpManagerCreate(
      arg.manager_instance_heap_memory,
      arg.manager_parent_heap_memory,
      arg.manager_parent_device_memory
  );

  // [V߂t@Ct@C[h}l[Wɓo^Ă
  getFileReadManager()->AppendManageFile( 
    arg.character_manager_heap_memory,
    ARCID_MOVEMODEL,
    false
  );
  getFileReadManager()->AppendManageFile( 
    arg.character_manager_heap_memory,
    ARCID_BATTLE_3D,
    false
  );
  return true;
}

void DressUpCharacterManager::subDestroyObjectManager(void)
{
  // [V߂t@Ct@C[h}l[WOĂ
  getFileReadManager()->RemoveManageFile(ARCID_BATTLE_3D);
  getFileReadManager()->RemoveManageFile(ARCID_MOVEMODEL);
  
  // ւ}l[Wj
  xy_system::dress_up::DressUpManagerDestroy();
}

b32 DressUpCharacterManager::subRequestAsyncCreateObject(
  CharacterData*     object,
  CharacterCreateArg arg,
  const Individual*  value
)
{
  // 񓯊
  DressUpResourceBuilder::RequestAsyncLoadResource(
    object->model_heap_allocator->GetHeapBase(),
    object->model_device_allocator,
    &(object->individual_fashion.individual)
  );
  object->state = STATE_MODEL_LOADING;

  return true;
}

void DressUpCharacterManager::subRequestAsyncDestroyObject(
  CharacterData*     object
)
{
  switch(object->state)
  {
  case STATE_MODEL_LOADING:
    {
      // 񓯊
      DressUpResourceBuilder::RequestAsyncUnloadResource(
        &(object->individual_fashion.individual)
      );
      object->state = STATE_MODEL_UNLOADING;
      break;
    }
  case STATE_MOTION_LOADING:
    {
      // [V\[X̃A[hJn
      // I
      object->state = STATE_MOTION_UNLOADING;
      break;
    }
  case STATE_CREATED:
    {
      // [Vj
      GFL_DELETE object->motion;
      object->motion = NULL;
      
      // [V\[X̃A[hJn
      // I
      object->state = STATE_MOTION_UNLOADING;
      break;
    }
  }
}

b32 DressUpCharacterManager::subDoesExistObject(
  CharacterData*     object
) const
{
  return (object->state == STATE_CREATED);
}

b32 DressUpCharacterManager::subIsAbleToDestroyObject(
  CharacterData*     object
) const
{
  return (object->state == STATE_CREATED);
}

void DressUpCharacterManager::subUpdateAsyncLoadResource(void)
{
  // 񓯊
  DressUpResourceBuilder::UpdateAsyncLoadResource();
}

b32 DressUpCharacterManager::subCreateObject(
  CharacterData*     object,
  CharacterCreateArg arg,
  const Individual*  value
)
{
  xy_system::dress_up::CopyIndividualFashion(&(object->individual_fashion), value);
  object->model  = NULL;
  initializeMotion(object);
  object->model_instance_heap_allocator = arg.model_instance_heap_allocator;
  object->model_heap_allocator          = arg.model_heap_allocator;       
  object->model_device_allocator        = arg.model_device_allocator;     
  object->motion_heap_memory            = arg.motion_heap_memory;
  object->state = STATE_NONE;
  return true;
}

void DressUpCharacterManager::subDestroyObject(
  CharacterData*     object
)
{
  GFL_ASSERT_STOP_MSG( ( object->state==STATE_NONE || object->state==STATE_CREATED ), "̂ߔjł܂B\n" );
  destroyMotion(object);
  if(object->model)
  {
    DressUpModelBuilder::DestroyModelUsingResourceManager(object->model);
    object->model = NULL;
  }
}

b32 DressUpCharacterManager::subUpdateObjectAsyncLoadResource(
  CharacterData*     object
)
{
  switch(object->state)
  {
  case STATE_MODEL_LOADING:
    {
      // 񓯊
      b32 ret = DressUpResourceBuilder::DoesExistResource(
          &(object->individual_fashion.individual)
      );
      if( ret )
      {
        // f\[X̓ǂݍ݂B
        // f𐶐
        object->model = DressUpModelBuilder::CreateModelUsingResourceManager(
            object->model_instance_heap_allocator,
            object->model_heap_allocator,
            object->model_device_allocator,
            &(object->individual_fashion.individual)
        );

        // [V\[X̓ǂݍ݂Jn
        requestReadMotion(object);

        object->state = STATE_MOTION_LOADING;
        //breakȂ
      }
      else
      {
        break;
      }
    }
  case STATE_MOTION_LOADING:
    {
      if( isFinishedReadMotion(object) )
      {
        // [V\[X̓ǂݍ݂B
        // [V𐶐
        createMotion(object);
        object->state = STATE_CREATED;
        //breakȂ
      }
      else
      {
        break;
      }
    }
  case STATE_CREATED:
    {
      break;
    }
  case STATE_MOTION_UNLOADING:
    {
      if( isFinishedReadMotion(object) )
      {
        // [V\[X̃A[hB
        // [V\[Xj
        destroyMotion(object);
        
        // fj
        DressUpModelBuilder::DestroyModelUsingResourceManager(object->model);
        object->model = NULL;
        // f\[X̃A[hJn
        DressUpResourceBuilder::RequestAsyncUnloadResource(
            &(object->individual_fashion.individual)
        );

        object->state = STATE_MODEL_UNLOADING;
        //breakȂ
      }
      else
      {
        break;
      }
    }
  case STATE_MODEL_UNLOADING:
    {
      // 񓯊
      b32 ret = DressUpResourceBuilder::DoesNotExistResource(
          &(object->individual_fashion.individual)
      );
      if( ret )
      {
        // f\[X̃A[hB
        // OjĂ炤
        object->state = STATE_NONE;
        break;
      }
      else
      {
        break;
      }
    }
  }

  return ( object->state != STATE_NONE );
}

b32 DressUpCharacterManager::subIsSameObject(
  CharacterData*     object,
  const Individual*  value
) const
{
  return IsSameIndividual( &(object->individual_fashion.individual), value );
}

void DressUpCharacterManager::subCalculateObjectBefore(
  CharacterData*     object
)
{
  if( object->state == STATE_CREATED )
  {
    object->motion->UpdateMotion();
  }
}

void DressUpCharacterManager::subCalculateObjectAfter(
  CharacterData*     object
)
{
  if( object->state == STATE_CREATED )
  {
    object->model->SetMotion(object->motion);
  }
}

void DressUpCharacterManager::initializeMotion(CharacterData* object)
{
  object->motion_buffer = NULL;
  object->motion_size = 0;
  object->motion = NULL;
}
void DressUpCharacterManager::requestReadMotion(CharacterData* object)
{
  gfl::fs::ArcFile::ARCID    arcid    = ARCID_BATTLE_3D;
  gfl::fs::ArcFile::ARCDATID arcdatid = GARC_battle_3d_tr0001_GMP;
  gfl::heap::HeapBase* heap_memory = object->motion_heap_memory;

  switch(object->individual_fashion.individual.section_type)
  {
  case xy_system::dress_up::SECTION_TYPE_FIELD:
    arcid    = ARCID_MOVEMODEL;
    heap_memory = object->motion_heap_memory->GetLowerHandle();  // kꂽt@Cǂݍނ̂Ōmۂ
    switch(object->individual_fashion.individual.model_type)
    {
    case xy_system::dress_up::MODEL_TYPE_HEROINE:
      arcdatid = GARC_movemodel_HEROINE_PACK_LZ;
      break;
    case xy_system::dress_up::MODEL_TYPE_HERO:
      arcdatid = GARC_movemodel_HERO_PACK_LZ;
      break;
    }
    break;
  case xy_system::dress_up::SECTION_TYPE_BATTLE:
    arcid    = ARCID_BATTLE_3D;
    heap_memory = object->motion_heap_memory;
    switch(object->individual_fashion.individual.model_type)
    {
    case xy_system::dress_up::MODEL_TYPE_HEROINE:
      arcdatid = GARC_battle_3d_tr0001_GMP;
      break;
    case xy_system::dress_up::MODEL_TYPE_HERO:
      arcdatid = GARC_battle_3d_tr0001_GMP;
      break;
    }
    break;
  }

  getFileReadManager()->AddReadRequest(
      &(object->motion_buffer), 
      &(object->motion_size),
      heap_memory,
      4, 
      arcid,
      arcdatid,
      false,
      gfl::fs::FileReadManager::REQUEST_PRIORITY_NORMAL
  );
}
b32 DressUpCharacterManager::isFinishedReadMotion(CharacterData* object)
{
  return getFileReadManager()->IsReadFinished(&(object->motion_buffer));
}
void DressUpCharacterManager::createMotion(CharacterData* object)
{
  switch(object->individual_fashion.individual.section_type)
  {
  case xy_system::dress_up::SECTION_TYPE_FIELD:
    {
      GFL_ASSERT_MSG(0, "kakikake aaaaaaaaaaaaaa\n");
      break;
    }
  case xy_system::dress_up::SECTION_TYPE_BATTLE:
    // ǂݍ񂾂܂܂̂̂gOK
    break;
  }

  object->motion = GFL_NEW(object->motion_heap_memory) proj::motion::BaseMotionCharacter;
  object->motion->Initialize( object->motion_buffer, object->motion_heap_memory );
}
void DressUpCharacterManager::destroyMotion(CharacterData* object)
{
  if(object->motion)
  {
    GFL_DELETE object->motion;
    object->motion = NULL;
  }
  if(object->motion_buffer)
  {
    GflHeapFreeMemory(object->motion_buffer);
    object->motion_buffer = NULL;
    object->motion_size = 0;
  }
}


} // namespace dress_up
} // namespace xy_system

