//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file    DressUpCharaEnvManager.cpp
 *  @brief   ւL}l[W
 *  @author  Koji Kawada
 *  @date    2012.05.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>

// dress_up
#include "system/dress_up/DressUpCharaEnvManager.h"


namespace xy_system {
namespace dress_up {


//-----------------------------------------------------------------------------
/**
 *     NX`
 */
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *     @brief  ւL}l[W
 */
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// RXgN^ / fXgN^
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  RXgN^
 */
//-----------------------------------------------------------------------------
DressUpCharaEnvManager::DressUpCharaEnvManager(
  gfl::heap::HeapBase*      heap_memory,
  s32                       chara_env_max_num
)
  : m_chara_env_max_num(0),
    m_chara_env_data_array(NULL)
{
  // mF
  if( chara_env_max_num == CHARA_ENV_MAX_NUM )
  {
    m_chara_env_max_num = chara_env_max_num;
  }
  else
  {
    GFL_ASSERT_MSG( 0, "chara_env_max_num=%dُ͈łB\n", chara_env_max_num );
    m_chara_env_max_num = CHARA_ENV_MAX_NUM;
  }

  // 
  m_chara_env_data_array = GFL_NEW_ARRAY(heap_memory) CharaEnvData*[m_chara_env_max_num];

  for(s32 i=0; i<m_chara_env_max_num; ++i)
  {
    m_chara_env_data_array[i] = NULL;
  }
}

//-----------------------------------------------------------------------------
/**
 *     @brief  fXgN^
 */
//-----------------------------------------------------------------------------
DressUpCharaEnvManager::~DressUpCharaEnvManager()
{
  if( m_chara_env_data_array )
  {
    for(s32 i=0; i<m_chara_env_max_num; ++i)
    {
      DestroyCharaEnv(i);
    }
    GFL_DELETE_ARRAY m_chara_env_data_array;
  }
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// L / Lj
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  L
 */
//-----------------------------------------------------------------------------
s32 DressUpCharaEnvManager::CreateCharaEnv(
  gfl::heap::NwAllocator* heap_allocator,
  gfl::heap::NwAllocator* device_allocator,
  s32                     chara_env_type
)
{
  s32 chara_env_id = CHARA_ENV_ID_NONE;
  
  // mF
  s32 l_chara_env_type = 0;
  if( l_chara_env_type == 0 )
  {
    l_chara_env_type = chara_env_type;
  }
  else
  {
    GFL_ASSERT_MSG( 0, "chara_env_type=%dُ͈łB\n", chara_env_type );
    l_chara_env_type = chara_env_type;
  }
  
  // 
  do
  {
    if( m_chara_env_data_array )
    {
      // ̂ɐĂȂmF
      b32 exist_same = false;
      for(s32 i=0; i<m_chara_env_max_num; ++i)
      {
        if( m_chara_env_data_array[i] )
        {
          if( m_chara_env_data_array[i]->chara_env_type == chara_env_type )
          {
            GFL_ASSERT_MSG(0, "̂܂B\n");
            exist_same = true;
            break;
          }
        }
      }
      if( exist_same ) break;
 
      // 
      for(s32 i=0; i<m_chara_env_max_num; ++i)
      {
        if( !m_chara_env_data_array[i] )
        {
          m_chara_env_data_array[i] = GFL_NEW(heap_allocator->GetHeapBase()) CharaEnvData;
          m_chara_env_data_array[i]->chara_env_type = chara_env_type;
          {
            m_chara_env_data_array[i]->light = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Light;
            gfl::grp::g3d::Light::Description desc;
            gfl::grp::g3d::Light::InitializeDescriptionForFragmentLight(
                &desc,
                gfl::grp::g3d::Light::KIND_DIRECTIONAL
            );
            m_chara_env_data_array[i]->light->Create(
                device_allocator,
                &desc
            );
            m_chara_env_data_array[i]->light->SetDirection(-1.0f, -1.0f, -1.0f);
          }
          chara_env_id = i;
          break;
        }
      }
    }
  }
  while(0);

  return chara_env_id;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  Lj
 */
//-----------------------------------------------------------------------------
void DressUpCharaEnvManager::DestroyCharaEnv(s32 chara_env_id)
{
  if( m_chara_env_data_array )
  {
    if( m_chara_env_data_array[chara_env_id] )
    {
      GFL_DELETE m_chara_env_data_array[chara_env_id]->light;
      GFL_DELETE m_chara_env_data_array[chara_env_id];
      m_chara_env_data_array[chara_env_id] = NULL;
    }
  }
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// 擾 / ݒ
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  L̃Cg擾
 */
//-----------------------------------------------------------------------------
gfl::grp::g3d::Light* DressUpCharaEnvManager::GetCharaEnvLight(
  s32 chara_env_id,
  s32 light_index
)
{
  gfl::grp::g3d::Light* light = NULL;

  // mF
  s32 l_light_index = 0;
  if( light_index == 0 )
  {
    l_light_index = light_index;
  }
  else
  {
    GFL_ASSERT_MSG( 0, "light_index=%dُ͈łB\n", light_index );
    l_light_index = light_index;
  }

  // 擾
  do
  {
    // chara_env_idmF
    if( chara_env_id >= m_chara_env_max_num ) break;

    // 擾
    if( m_chara_env_data_array )
    {
      if( m_chara_env_data_array[chara_env_id] )
      {
        return m_chara_env_data_array[chara_env_id]->light;
      }
    }
  }
  while(0);

  return light;
}


///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//
// V[ɓo^ / V[O
//
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  LV[ɓo^
 */
//-----------------------------------------------------------------------------
b32 DressUpCharaEnvManager::AddCharaEnvToScene(
  s32 chara_env_id,
  gfl::grp::g3d::Scene* scene,
  s32 scene_calculate_group_index
)
{
  b32 ret = false;

  do
  {
    // chara_env_idmF
    if( chara_env_id >= m_chara_env_max_num ) break;

    // 擾
    if( m_chara_env_data_array )
    {
      if( m_chara_env_data_array[chara_env_id] )
      {
        ret = scene->AddNodeToCalc(m_chara_env_data_array[chara_env_id]->light, scene_calculate_group_index);
      }
    }
  }
  while(0);
  
  return ret;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  LV[O
 */
//-----------------------------------------------------------------------------
void DressUpCharaEnvManager::RemoveCharaEnvFromScene(
  s32 chara_env_id,
  gfl::grp::g3d::Scene* scene
)
{
  do
  {
    // chara_env_idmF
    if( chara_env_id >= m_chara_env_max_num ) break;

    // 擾
    if( m_chara_env_data_array )
    {
      if( m_chara_env_data_array[chara_env_id] )
      {
        scene->RemoveNodeFromCalc(m_chara_env_data_array[chara_env_id]->light);
      }
    }
  }
  while(0);
}

//-----------------------------------------------------------------------------
/**
 *   @brief  LV[ɐݒ肷
 */
//-----------------------------------------------------------------------------
void DressUpCharaEnvManager::AssignCharaEnv(
  s32 chara_env_id,
  gfl::grp::g3d::Scene* scene
)
{
  static const s32 CHARA_LIGHT_SET_INDEX = 2;
  do
  {
    // chara_env_idmF
    if( chara_env_id >= m_chara_env_max_num ) break;

    // 擾
    if( m_chara_env_data_array )
    {
      if( m_chara_env_data_array[chara_env_id] )
      {
        gfl::grp::g3d::Light* light_array[1] =
        {
          m_chara_env_data_array[chara_env_id]->light
        };
        scene->AssignLight( CHARA_LIGHT_SET_INDEX, light_array, sizeof(light_array)/sizeof(light_array[0]) );
      }
    }
  }
  while(0);
}


} // namespace dress_up
} // namespace xy_system

