#ifndef __XY_SYSTEM_DRESS_UP_OBJECTMANAGER_H__
#define __XY_SYSTEM_DRESS_UP_OBJECTMANAGER_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file    ObjectManager.h
 *  @brief   IuWFNg}l[W
 *  @author  Koji Kawada
 *  @date    2012.05.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0

http://homepage2.nifty.com/well/Template.html
C++}jAbN 
ev[g

ev[g֐ٌ̈^ ev[g֐ y[W̐擪

ev[g֐̍ŌƂāA C++ ̑gݍ݌^ł悤Ȉٌ^ɂĉ܂BTv͎̂悤ɂȂ܂Bev[gƂ typename ŕϐ^w肷̂ł͂ȂAC++ ̑gݍݕ̕ϐAł int iVAgp܂B

 template<int iV>
int Add(int iValue) {
    return iValue + iV;
}
 
ev[g֐̃Tv TemplateFunction3.cpp

gp@́Â悤ɂȂ܂B

 int main() {
    int iValue = Add<3>(2);            // 2 + 3 Ԃ܂B
    printf("iValue = %d\n", iValue);    //  5 ɂȂ܂B
    return 0;
}
 
ٌ̈^ǂ̂悤Ɏgp邩͎RłAႦ΁A 0, 1, 2, ... ev[gƂė^āAOňقȂe̊֐`Ƃ悤ȂƂołB

#endif


#include <gflib.h>


namespace xy_system {
namespace dress_up {


//-----------------------------------------------------------------------------
/**
 *     NX錾
 */
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *     @brief  IuWFNg}l[W(ev[g)
 */
//-----------------------------------------------------------------------------

// ObjectType              IuWFNǧ^  // 4oCgACgɂĂƁI
// OBJECT_MAX_NUM          IuWFNg̍ő吔(OBJECT_ID_TYPE_MAX_NUMȉ)
// ObjectManagerCreateArg  IuWFNg}l[Wɗp̌^
// ObjectCreateArg         IuWFNgɗp̌^
// ObjectValue             IuWFNgʂl
template <
  typename ObjectType, 
  s32 OBJECT_MAX_NUM, 
  typename ObjectManagerCreateArg, 
  typename ObjectCreateArg, 
  typename ObjectValue
>
class ObjectManager
{
  GFL_FORBID_COPY_AND_ASSIGN(ObjectManager);


  //##########################################################################
  //##########################################################################
  //##########################################################################
  //
  // Jo
  //
  //##########################################################################
  //##########################################################################
  //##########################################################################

public:
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // 萔
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  /// @brief  萔
  enum
  {
    OBJECT_ID_NONE         = -1,  // IuWFNgǗIDȂ
    OBJECT_ID_TYPE_MAX_NUM = 120  // ObjectIdType̓sŌ܂IuWFNg̍ő吔
  };


  //##########################################################################
  //##########################################################################
  //##########################################################################
  //
  // Jo
  //
  //##########################################################################
  //##########################################################################
  //##########################################################################

private:
  // ^
  typedef s8 ObjectIdType;
  // Xgvf  // 4oCgACg
  struct ObjectElement
  {
    ObjectIdType    object_id;
    s8              dummy[3];
    ObjectElement*  next;  // vf̂ƂNULL
    ObjectType      object;  // 4oCgACgɂĂƁI
  };

private:
  // oϐ
  gfl::fs::FileReadManager* m_file_read_manager;  // ̂ƂŐ̂oĂ
  s8                        m_object_max_num;     // ꂪ0̂ƂObjectManager𐶐ĂȂA
                                                  // ꂪ0̂ƂObjectManager𐶐ĂAƔ肷B
  s8                        dummy[3];
  ObjectElement*            m_element_head;  // 擪vfւ̃|C^(1IuWFNgĂȂƂNULL)
  gfl::base::Bit*           m_object_id_bit;  // gp̃IuWFNgǗID1ɂĂ


  //##########################################################################
  //##########################################################################
  //##########################################################################
  //
  // Jo
  //
  //##########################################################################
  //##########################################################################
  //##########################################################################

public:
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // RXgN^ / fXgN^
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  
  //-----------------------------------------------------------------------------
  /**
   *   @brief  RXgN^
   *           
   *   @param[in]  file_read_manager  t@C[h}l[W
   *   @param[in]  heap_memory        IuWFNgǗɎgp郁
   *   @param[in]  object_max_num     őIuWFNg
   *   @param[in]  arg                IuWFNg}l[Wɗp
   */
  //-----------------------------------------------------------------------------
  ObjectManager(void)
    : m_file_read_manager(NULL),
      m_object_max_num(0),
      m_element_head(NULL),
      m_object_id_bit(NULL)
  {
    /////////////////////////////////////
    /////////////////////////////////////
    //
    // ł͉Ȃ̂ŁAhNXcreateObjectManagerĂŉB
    //
    /////////////////////////////////////
    /////////////////////////////////////
  }

  ObjectManager(
    gfl::fs::FileReadManager* file_read_manager,
    gfl::heap::HeapBase*      heap_memory,
    s32                       object_max_num,
    ObjectManagerCreateArg    arg
  )
    : m_file_read_manager(NULL),
      m_object_max_num(0),
      m_element_head(NULL),
      m_object_id_bit(NULL)
  {
    /////////////////////////////////////
    /////////////////////////////////////
    //
    // ł͉Ȃ̂ŁAhNXcreateObjectManagerĂŉB
    //
    /////////////////////////////////////
    /////////////////////////////////////
  }

  //-----------------------------------------------------------------------------
  /**
   *     @brief  fXgN^
   * 
   *             IsAbleToDestroytrueԂ܂ő҂ĂAjĉB
   */
  //-----------------------------------------------------------------------------
  virtual ~ObjectManager()
  {
    /////////////////////////////////////
    /////////////////////////////////////
    //
    // ł͉Ȃ̂ŁAhNXdestroyObjectManagerĂŉB
    //
    /////////////////////////////////////
    /////////////////////////////////////
  }


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // IuWFNg / IuWFNgj
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  IuWFNgNGXg
   *          
   *           IuWFNgɂ(ς݂łłjł\Ȃ)ANGXgs܂B
   *
   *   @param[in]  heap_memory  IuWFNgǗɎgp郁
   *   @param[in]  arg          IuWFNgɗp
   *   @param[in]  value        IuWFNgʂl
   *
   *   @retval  NGXgɐƂA0ȏ̃IuWFNgǗIDԂ
   *            NGXgɎsƂAOBJECT_ID_NONEԂ
   */
  //-----------------------------------------------------------------------------
  s32 RequestAsyncCreateObject(
    gfl::heap::HeapBase*    heap_memory,
    ObjectCreateArg         arg,
    ObjectValue             value
  )
  {
    s32 object_id = OBJECT_ID_NONE;
    if( isObjectManagerCreated() )
    {
      do
      {
        // IuWFNgɂ(ς݂łłjł\Ȃ)AȂ
        if( getObjectId(value) >= 0 )
        {
          GFL_ASSERT_MSG(0, "IuWFNgNotExistł͂܂B\n");
          break;
        }
       
        // IuWFNgȂ̂ŁA
        ObjectElement* element = createObjectElement(
            heap_memory,
            arg,
            value
        );
        if( element )
        {
          // hNX
          b32 ret = subRequestAsyncCreateObject(
            &(element->object),
            arg,
            value
          );

          if( ret )
          {
            ObjectElement** next_pointer = getElementTailNextPointer();
            *next_pointer = element;
            object_id = element->object_id;

            updateAsyncLoadResource();  // NGXg̍XV
          }
          else
          {
            GFL_ASSERT_MSG(0, "ObjectElementObjectTypeNGXgɎs܂B\n");
            destroyObjectElement(
                element
            );
          }
        }
        else
        {
          GFL_ASSERT_MSG(0, "ObjectElement𐶐ł܂B\n");
        }
      }
      while(0);
    }
    return object_id;
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  IuWFNgjNGXg
   *          
   *   @param[in]  object_id  IuWFNgǗID
   */
  //-----------------------------------------------------------------------------
  void RequestAsyncDestroyObject(
    s32 object_id
  )
  {
    if( isObjectManagerCreated() )
    {
      ObjectType* object = GetObject(object_id);
      if( object )
      {
        // hNX
        subRequestAsyncDestroyObject(
          object
        );
        
        updateAsyncLoadResource();  // jNGXg̍XV
      }
    }
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  IuWFNg݂Ă邩mF
   *          
   *   @param[in]  object_id  IuWFNgǗID
   *   
   *   @retval  ς݂ő݂ĂƂtrueԂ
   *            ȊÔƂ(݂ȂAAj)falseԂ
   */
  //-----------------------------------------------------------------------------
  b32 DoesExistObject(
    s32 object_id
  ) const
  {
    b32 ret = false;
    if( isObjectManagerCreated() )
    {
      ObjectType* object = GetObject(object_id);
      if( object )
      {
        // hNX
        ret = subDoesExistObject(
          object
        );
      }
    }
    return ret;
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  IuWFNg݂ĂȂmF
   *          
   *   @param[in]  object_id  IuWFNgǗID
   *   
   *   @retval  ƂȂƂAjς݂ő݂ĂȂƂtrueԂ
   *            ȊÔƂ(݂AAj)falseԂ
   */
  //-----------------------------------------------------------------------------
  b32 DoesNotExistObject(
    s32 object_id
  ) const
  {
    b32 ret = true;
    if( isObjectManagerCreated() )
    {
      ObjectType* object = GetObject(object_id);
      if( object )
      {
        ret = false;
      }
    }
    return ret;
  }


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // 擾 / ݒ
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  IuWFNg擾
   *          
   *   @param[in]  object_id  IuWFNgǗID
   *   
   *   @retval  DoesExistObjecttruêƂAIuWFNgւ̃|C^Ԃ
   *            falsêƂNULLԂ
   */
  //-----------------------------------------------------------------------------
  ObjectType* GetObject(
    s32 object_id
  ) const
  {
    ObjectType* object = NULL;
    if( isObjectManagerCreated() )
    {
      ObjectElement* element = m_element_head;
      while(element)
      {
        if( element->object_id == object_id )
        {
          object = &(element->object);
          break;
        }
        element = element->next;
      }
    }
    return object;
  }


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // vZ
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  OvZ
   *
   *           gfl::grp::g3d::SceneCalculatȇOɁAt[ĂŉB
   *           񓯊[hA񓯊A[h̍XV̊֐ōs܂B
   */
  //-----------------------------------------------------------------------------
  virtual void CalculateBefore(void)
  {
    if( isObjectManagerCreated() )
    {
      // 񓯊[hA񓯊A[h̍XV
      updateAsyncLoadResource();

      // hNX
      ObjectElement* element = m_element_head;
      while(element)
      {
        subCalculateObjectBefore(&(element->object));
        element = element->next;
      }
    }
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  vZ
   *
   *           gfl::grp::g3d::SceneCalculatěɁAt[ĂŉB
   */
  //-----------------------------------------------------------------------------
  virtual void CalculateAfter(void) 
  {
    if( isObjectManagerCreated() )
    {
      // hNX
      ObjectElement* element = m_element_head;
      while(element)
      {
        subCalculateObjectAfter(&(element->object));
        element = element->next;
      }
    }
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  jł邩
   *
   *           jłȂƂ́Ajł悤ɂȂ܂ŉt[CalculateBeforeĂŉB
   *
   *   @retval  jłƂtrueԂB
   */
  //-----------------------------------------------------------------------------
  b32 IsAbleToDestroy(void) const
  {
    b32 ret = true;
    if( isObjectManagerCreated() )
    {
      ObjectElement* element = m_element_head;
      while(element)
      {
        // hNX
        if( !subIsAbleToDestroyObject(&(element->object)) )
        {
          ret = false;
          break;
        }
        
        element = element->next;
      }
    }
    return ret;
  }


  //##########################################################################
  //##########################################################################
  //##########################################################################
  //
  // hNXɂJĂ郁o
  //
  //##########################################################################
  //##########################################################################
  //##########################################################################
protected:
  // @brief  IuWFNg}l[W
  // @param[in]  file_read_manager  t@C[h}l[W
  // @param[in]  heap_memory        IuWFNgǗɎgp郁
  // @param[in]  object_max_num     őIuWFNg
  // @param[in]  arg                IuWFNg}l[Wɗp
  // @retval  IuWFNg}l[W𐶐łƂtrueԂ
  b32 createObjectManager(
    gfl::fs::FileReadManager* file_read_manager,
    gfl::heap::HeapBase*      heap_memory,
    s32                       object_max_num,
    ObjectManagerCreateArg    arg
  )
  {
    b32 ret = true;
    do
    {
      if( m_object_max_num == 0 )
      {
        // `FbN
        if( !( OBJECT_MAX_NUM <= OBJECT_ID_TYPE_MAX_NUM ) )
        {
          GFL_ASSERT_MSG(0, "OBJECT_MAX_NUM=%dُłBő%dłB\n", OBJECT_MAX_NUM, OBJECT_ID_TYPE_MAX_NUM);
          ret = false; 
          break;
        }
        if( !( 0<object_max_num && object_max_num<=OBJECT_MAX_NUM ) )
        {
          GFL_ASSERT_MSG(0, "object_max_num=%dُłBő%dłB\n", object_max_num, OBJECT_MAX_NUM);
          ret = false; 
          break;
        }
 
        // ̂ƂŐ̂oĂ
        m_file_read_manager = file_read_manager;
 
        // 
        m_object_max_num = object_max_num;
        m_element_head = NULL;
        m_object_id_bit = GFL_NEW(heap_memory) gfl::base::Bit(heap_memory, m_object_max_num);
     
        // hNX
        ret = subCreateObjectManager(
            arg
        );
        if( !ret )
        {
          GFL_ASSERT_MSG(0, "ł܂B\n");
          destroyObjectManager();
          break;
        }
      }
      else
      {
        GFL_ASSERT_MSG(0, "ɐς݂łB\n");
        ret = false; 
        break;
      }
    }
    while(0);
    return ret;
  }
  // @brief  IuWFNg}l[W
  //         hNXŎĉB
  // @param[in]  arg                IuWFNg}l[Wɗp
  // @retval  ȂtrueԂ
  virtual b32 subCreateObjectManager(
    ObjectManagerCreateArg    arg
  )
  {
    // trueԂȂƂ́Å֐ł̂͂ƔjāAĂяoɖ߂ĉB
    return true;
  }

  // @brief  IuWFNg}l[Wj
  //         IsAbleToDestroytrueԂ܂ő҂ĂAjĉB
  void destroyObjectManager()
  {
    if( isObjectManagerCreated() )
    {
      GFL_ASSERT_STOP_MSG(IsAbleToDestroy(), "̂ߔjł܂B\n");
     
      // hNX
      subDestroyObjectManager();

      {
        // j
        ObjectElement* element = m_element_head;
        while(element)
        {
          ObjectElement* element_next = element->next;
          destroyObjectElement(element);
          element = element_next;
        }
        GFL_DELETE m_object_id_bit;
       
        {
          // RXgN^Ɠ
          m_file_read_manager = NULL;
          m_object_max_num = 0;
          m_element_head = NULL;
          m_object_id_bit = NULL;
        }
      }
    }
  }
  // @brief  IuWFNg}l[Wj
  //         hNXŎĉB
  virtual void subDestroyObjectManager(void)
  {
  }

  // @brief  IuWFNg}l[Wς݂
  b32 isObjectManagerCreated(void) const
  {
    return ( m_object_max_num > 0 );  // ObjectManager𐶐Ă
  }

  // @brief  IuWFNgNGXg
  //         hNXŎĉB
  // @param[in]  object       ꂽIuWFNg
  // @param[in]  arg          IuWFNgɗp
  // @param[in]  value        IuWFNgʂl
  // @retval  ȂtrueԂ
  virtual b32 subRequestAsyncCreateObject(
    ObjectType*     object,
    ObjectCreateArg arg,
    ObjectValue     value
  )
  {
    // trueԂȂƂ́Å֐ł̂͂ƔjāAĂяoɖ߂ĉB
    return true;
  }

  // @brief  IuWFNgjNGXg
  //         hNXŎĉB
  // @param[in]  object       jIuWFNg
  virtual void subRequestAsyncDestroyObject(
    ObjectType*     object
  )
  {
  }

  // @brief  IuWFNg݂Ă邩mF
  //         hNXŎĉB
  // @param[in]  object       mFIuWFNg
  // @retval  ς݂ő݂ĂƂtrueԂ
  //          ȊÔƂ(݂ȂAAj)falseԂ
  virtual b32 subDoesExistObject(
    ObjectType*     object
  ) const
  {
    return true;
  }

  // @brief  IuWFNgjł邩
  //         hNXŎĉB
  //         jłȂƂ́Ajł悤ɂȂ܂ŉt[CalculateBeforeĂŉB
  // @retval  jłƂtrueԂB
  virtual b32 subIsAbleToDestroyObject(
    ObjectType*     object
  ) const
  {
    return true;
  }

  // @brief  񓯊[hA񓯊A[h̍XV
  void updateAsyncLoadResource(void)
  {
    if( isObjectManagerCreated() )
    {
      // hNX
      subUpdateAsyncLoadResource();

      ObjectElement*  element = m_element_head;
      ObjectElement** prev_element_next_pointer = &m_element_head;
      while(element)
      {
        ObjectElement* element_next = element->next;
        if( updateObjectElementAsyncLoadResource(element) )
        {
          prev_element_next_pointer = &(element->next);
        }
        else
        {
          // Xgvfjꂽ̂ŁAq
          *prev_element_next_pointer = element_next;
        }
        element = element_next;
      }
    }
  }
  // @brief  񓯊[hA񓯊A[h̍XV
  //         hNXŎĉB
  virtual void subUpdateAsyncLoadResource(void)
  {
  }

  // @brief  Xgvf
  // @param[in]  heap_memory  IuWFNgǗɎgp郁
  // @param[in]  arg          IuWFNgɗp
  // @param[in]  value        IuWFNgʂl
  // @retval  łƂXgvfԂB
  //          łȂƂNULLԂB
  ObjectElement* createObjectElement(
    gfl::heap::HeapBase*    heap_memory,
    ObjectCreateArg         arg,
    ObjectValue             value
  )
  {
    ObjectElement* element = NULL;
    if( isObjectManagerCreated() )
    {
      u32 bit_index;
      b32 bit_ret = m_object_id_bit->GetOffBitMinIndex(&bit_index);
      if( bit_ret )
      {
        element = GFL_NEW(heap_memory) ObjectElement;
        element->object_id = static_cast<ObjectIdType>(bit_index);
        m_object_id_bit->On(element->object_id);
        element->next = NULL;

        // hNX
        b32 ret = subCreateObject(
          &(element->object),
          arg,
          value
        );

        if( !ret )
        {
          destroyObjectElement(element);
          element = NULL;
        }
      }
      else
      {
        GFL_ASSERT_MSG(0, "ObjectElement𐶐ł܂B\n");
      }
    }
    return element;
  }

  // @brief  Xgvfj(ǂݍݒǂƂƂ͊mFAj܂)
  // @param[in]  element  Xgvf
  void destroyObjectElement(ObjectElement* element)
  {
    if( isObjectManagerCreated() )
    { 
      // hNX
      subDestroyObject(
        &(element->object)
      );
      
      m_object_id_bit->Off(element->object_id);
      GFL_DELETE element;
    }
  }

  // @brief  XgvfXV
  // @param[in]  element  Xgvf
  // @retval  XVナXgvf݂ꍇtrueԂB
  //          XgvfjꂽfalseԂB
  b32 updateObjectElementAsyncLoadResource(ObjectElement* element)
  {
    b32 ret = true;
    if( isObjectManagerCreated() )
    {
      // hNX
      if( !( subUpdateObjectAsyncLoadResource(&(element->object)) ) )
      {
        destroyObjectElement(element);
        ret = false;
      }
    }
    return ret;
  }
  
  // @brief Xg̖vfnext̃|C^𓾂
  // @retval  Xg̖vfnext̃|C^ԂB
  //          1IuWFNgĂȂƂm_element_head̃|C^ԂB
  ObjectElement** getElementTailNextPointer(void)
  {
    ObjectElement** next_pointer = NULL;
    if( isObjectManagerCreated() )
    {
      ObjectElement* element = m_element_head;
      next_pointer = &m_element_head;
      while(element)
      {
        element = element->next;
        next_pointer = &(element->next);
      }
    }
    return next_pointer;
  }

  // @brief  IuWFNg
  //         hNXŎĉB
  //         object̂͐Ȃ(ς݂łĂ)BObjectTypẽo𐶐B
  // @param[in]  object       ꂽIuWFNg
  // @param[in]  arg          IuWFNgɗp
  // @param[in]  value        IuWFNgʂl
  // @retval  ȂtrueԂ
  virtual b32 subCreateObject(
      ObjectType*      object,
      ObjectCreateArg  arg,
      ObjectValue      value
  )
  {
    // trueԂȂƂ́Å֐ł̂͂ƔjāAĂяoɖ߂ĉB
    return true;
  }

  // @brief  IuWFNgj
  //         hNXŎĉB
  //         object͔̂jȂ(ĂяoŃXgvfƂƂɔj)BObjectTypẽojB
  // @param[in]  object       jIuWFNg
  virtual void subDestroyObject(
      ObjectType* object
  )
  {
    // ̊֐𔲂ČĂяoɖ߂ƁAobject܂ރXgvfĵŁAObjectTypẽoĂKv͂܂B
  }

  // @brief  IuWFNgXV
  //         hNXŎĉB
  // @param[in]  object       IuWFNg
  // @retval  XVXgvfɑė~ꍇtrueԂB
  //          XV̓Xgvfjė~ꍇfalseԂB
  virtual b32 subUpdateObjectAsyncLoadResource(
      ObjectType* object
  )
  {
    return true;
  }

  // @brief  IuWFNg邩(ς݂łłjł\Ȃ)
  // @param[in]  value        IuWFNgʂl
  // @retval  炻̃IuWFNgǗIDԂB
  //          ȂOBJECT_ID_NONEԂB
  s32 getObjectId(
      ObjectValue value
  ) const
  {
    s32 object_id = OBJECT_ID_NONE;
    if( isObjectManagerCreated() )
    {
      ObjectElement* element = m_element_head;
      while(element)
      {
        // hNX
        if( subIsSameObject(&(element->object), value) )
        {
          object_id = element->object_id;
          break;
        }
        element = element->next;
      }
    }
    return object_id;
  }

  // @brief  valueŃIuWFNg𐶐ƁÃIuWFNgobjectƓ̂ł邩
  // @param[in]  object  ̃IuWFNg
  // @param[in]  value   IuWFNgʂl
  // @retval  ̂łƂtrueԂ
  virtual b32 subIsSameObject(
      const ObjectType* object,
      ObjectValue value
  ) const
  {
    return false;
  }

  // @brief  OvZŁAIuWFNgvZ
  //         hNXŎĉB
  // @param[in]  object       IuWFNg
  virtual void subCalculateObjectBefore(
      ObjectType* object
  )
  {
  }

  // @brief  vZŁAIuWFNgvZ
  //         hNXŎĉB
  // @param[in]  object       IuWFNg
  virtual void subCalculateObjectAfter(
      ObjectType* object
  )
  {
  }

  // @brief  t@C[h}l[W擾
  // @retval  t@C[h}l[WԂ
  gfl::fs::FileReadManager* getFileReadManager(void) const
  {
    return m_file_read_manager;
  }


};


} // namespace dress_up
} // namespace xy_system


#endif  // __XY_SYSTEM_DRESS_UP_OBJECTMANAGER_H__

