#ifndef __DRESSUPCHARACTERMANAGER_H__
#define __DRESSUPCHARACTERMANAGER_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file    DressUpCharacterManager.h
 *  @brief   ւLN^}l[W
 *  @author  Koji Kawada
 *  @date    2012.05.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0

[DressUpCharacterManager̐]

DressUpCharacterManager
    DressUpManager
    DressUpResourceBuilder
    DressUpModelBuilder
̋@\ɉ
    [V
ǗAւLN^ȒPɈ悤ɂ}l[WłB

#endif


#include <gflib.h>

// motion
#include "../../../src/system/motion/BaseMotionCharacter.h"

// dress_up
#include "DressUpDefine.h"
#include "DressUpFashion.h"
#include "DressUpManager.h"
#include "DressUpIModel.h"
#include "DressUpModelBuilder.h"
#include "DressUpResourceBuilder.h"
#include "ObjectManager.h"


namespace xy_system {
namespace dress_up {


//-----------------------------------------------------------------------------
/**
 *     NX錾
 */
//-----------------------------------------------------------------------------

// ^

// LN^f[^  // 4oCgACg
struct CharacterData
{
  IndividualFashion                  individual_fashion;
  DressUpIModel*                     model;
  void*                              motion_buffer;
  u32                                motion_size;
  proj::motion::BaseMotionCharacter* motion;
  gfl::heap::NwAllocator*            model_instance_heap_allocator;
  gfl::heap::NwAllocator*            model_heap_allocator;       
  gfl::heap::NwAllocator*            model_device_allocator;     
  gfl::heap::HeapBase*               motion_heap_memory;
  s8                                 state;
  s8                                 dummy[3];
};

// IuWFNg}l[Wɗp
struct CharacterManagerCreateArg
{
  gfl::heap::HeapBase*  manager_instance_heap_memory;
  gfl::heap::HeapBase*  manager_parent_heap_memory;
  gfl::heap::HeapBase*  manager_parent_device_memory;
  gfl::heap::HeapBase*  character_manager_heap_memory;
};
// IuWFNgɗp
struct CharacterCreateArg
{
  gfl::heap::NwAllocator*  model_instance_heap_allocator;
  gfl::heap::NwAllocator*  model_heap_allocator;          
  gfl::heap::NwAllocator*  model_device_allocator;      
  gfl::heap::HeapBase*     motion_heap_memory;    
};

// 萔
enum
{
  CHARACTER_MAX_NUM = 120  // LN^̍ő吔
};


// NX
typedef ObjectManager<CharacterData, CHARACTER_MAX_NUM, CharacterManagerCreateArg, CharacterCreateArg, const Individual*> DressUpSuperCharacterManager;


//-----------------------------------------------------------------------------
/**
 *     @brief  ւLN^}l[W
 */
//-----------------------------------------------------------------------------
class DressUpCharacterManager : public DressUpSuperCharacterManager
{
  GFL_FORBID_COPY_AND_ASSIGN(DressUpCharacterManager);


public:
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // RXgN^ / fXgN^
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  
  //-----------------------------------------------------------------------------
  /**
   *   @brief  RXgN^
   *           
   *           DressUpManager𐶐܂B
   *           DressupManagerCreateQƁB
   *
   *   @param[in]  file_read_manager                        t@C[h}l[W
   *   @param[in]  manager_instance_heap_memory
   *   @param[in]  manager_parent_heap_memory
   *   @param[in]  manager_parent_device_memory
   *   @param[in]  character_manager_character_heap_memory  LN^ǗɎgp郁
   *   @param[in]  character_max_num                        őLN^
   */
  //-----------------------------------------------------------------------------
  DressUpCharacterManager(
    gfl::fs::FileReadManager* file_read_manager,
    gfl::heap::HeapBase*      manager_instance_heap_memory,
    gfl::heap::HeapBase*      manager_parent_heap_memory,
    gfl::heap::HeapBase*      manager_parent_device_memory,
    gfl::heap::HeapBase*      character_manager_heap_memory,
    s32                       character_max_num
  );

  //-----------------------------------------------------------------------------
  /**
   *     @brief  fXgN^
   * 
   *             DressUpManagerj܂B
   *             DressupManagerDestroyQƁB
   *             IsAbleToDestroytrueԂ܂ő҂ĂAjĉB
   */
  //-----------------------------------------------------------------------------
  ~DressUpCharacterManager();


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // LN^ / LN^j
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^NGXg
   *          
   *           DressUpResourceBuilderADressUpModelBuilderĂ邱ƂsB
   *           āA[VB
   *           DressUpResourceBuilderQƁB
   *           DressUpModelBuilderQƁB
   *           LN^ɂ(ς݂łłjł\Ȃ)ANGXgs܂B
   *
   *   @param[in]  character_manager_heap_memory      LN^Ǘ̐Ɏgp郁
   *   @param[in]  model_instance_heap_allocator      CX^XۂɎgp郁
   *   @param[in]  model_heap_allocator               change_flagtruȅꍇAeq[vƂqq[vVɂÂp
   *   @param[in]  model_device_allocator             qq[v烁mۂBqq[ṽ̓fj܂ŕێB
   *   @param[in]  model_individual                   ւfʏ  // Ăяo͔jĂ悢
   *   @param[in]  motion_heap_memory                 [V̐Ɏgp郁
   *
   *   @retval  NGXgɐƂA0ȏ̃LN^ǗIDԂ
   *            NGXgɎsƂAOBJECT_ID_NONEԂ
   */
  //-----------------------------------------------------------------------------
  s32 RequestAsyncCreateObject(
    gfl::heap::HeapBase*    character_manager_heap_memory,     
    gfl::heap::NwAllocator* model_instance_heap_allocator,
    gfl::heap::NwAllocator* model_heap_allocator,          
    gfl::heap::NwAllocator* model_device_allocator,       
    const Individual*       model_individual,                
    gfl::heap::HeapBase*    motion_heap_memory
  );

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^jNGXg
   *          
   *           DressUpResourceBuilderADressUpModelBuilderĂ邱ƂsB
   *           āA[VB
   *           DressUpResourceBuilderQƁB
   *           DressUpModelBuilderQƁB
   *           _uobt@̂Ƃ(R}hobt@dɂĂƂ)
   *               LN^̃fV[OĂ1t[o߂ĂjNGXg𔭍sĉB
   *                   or
   *               `悵ȂƂɔjNGXg𔭍sĉB
   *
   *   @param[in]  object_id  LN^ǗID
   */
  //-----------------------------------------------------------------------------
  //void RequestAsyncDestroyObject(s32 object_id);

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^݂Ă邩mF
   *          
   *           DressUpResourceBuilderADressUpModelBuilderĂ邱ƂsB
   *           āA[VB
   *           DressUpResourceBuilderQƁB
   *           DressUpModelBuilderQƁB
   *
   *   @param[in]  object_id  LN^ǗID 
   *   
   *   @retval  ς݂ő݂ĂƂtrueԂ
   *            ȊÔƂ(݂ȂAAj)falseԂ
   */
  //-----------------------------------------------------------------------------
  //b32 DoesExistObject(s32 object_id);

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^݂ĂȂmF
   *          
   *           DressUpResourceBuilderADressUpModelBuilderĂ邱ƂsB
   *           āA[VB
   *           DressUpResourceBuilderQƁB
   *           DressUpModelBuilderQƁB
   *
   *   @param[in]  object_id  LN^ǗID
   *   
   *   @retval  ƂȂƂAjς݂ő݂ĂȂƂtrueԂ
   *            ȊÔƂ(݂AAj)falseԂ
   */
  //-----------------------------------------------------------------------------
  //b32 DoesNotExistObject(s32 object_id);


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // 擾 / ݒ
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^̃f擾
   *          
   *   @param[in]  object_id  LN^ǗID 
   *   
   *   @retval  DoesExistObjecttruêƂALN^̃fւ̃|C^Ԃ
   *            falsêƂNULLԂ
   */
  //-----------------------------------------------------------------------------
  DressUpIModel* GetCharacterModel(
    s32 object_id
  );

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^̃[V擾
   *          
   *   @param[in]  object_id  LN^ǗID 
   *   
   *   @retval  DoesExistObjecttruêƂALN^̃[Vւ̃|C^Ԃ
   *            falsêƂNULLԂ
   */
  //-----------------------------------------------------------------------------
  proj::motion::BaseMotionCharacter* GetCharacterMotion(
    s32 object_id
  );


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // vZ
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  OvZ
   *
   *           gfl::grp::g3d::SceneCalculatȇOɁAt[ĂŉB
   *           񓯊[hA񓯊A[h̍XV̊֐ōs܂B
   *           [VXV
   */
  //-----------------------------------------------------------------------------
  //void CalculateBefore(void); 

  //-----------------------------------------------------------------------------
  /**
   *   @brief  vZ
   *
   *           gfl::grp::g3d::SceneCalculatěɁAt[ĂŉB
   *           [VfɊ蓖Ă
   */
  //-----------------------------------------------------------------------------
  //void CalculateAfter(void); 

  //-----------------------------------------------------------------------------
  /**
   *   @brief  jł邩
   *
   *           jłȂƂ́Ajł悤ɂȂ܂ŉt[CalculateBeforeĂŉB
   *
   *   @retval  jłƂtrueԂB
   */
  //-----------------------------------------------------------------------------
  //b32 IsAbleToDestroy(void) const;


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // V[ɓo^ / V[O
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^̃fV[ɓo^
   *           
   *   @param[in]  object_id                    LN^ǗID 
   *   @param[in]  scene_calculate_group_index  V[vZO[vCfbNX
   *   @param[in]  scene_draw_group_index       V[`O[vCfbNX
   *
   *   @retval  V[ɓo^łƂtrueԂ
   */
  //-----------------------------------------------------------------------------
  b32 AddCharacterModelToScene(
    s32 object_id,
    gfl::grp::g3d::Scene* scene,
    s32 scene_calculate_group_index,
    s32 scene_draw_group_index
  );

  //-----------------------------------------------------------------------------
  /**
   *   @brief  LN^̃fV[O
   *
   *   @param[in]  object_id  LN^ǗID 
   */
  //-----------------------------------------------------------------------------
  void RemoveCharacterModelFromScene(
    s32 object_id,
    gfl::grp::g3d::Scene* scene
  );


  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  //
  // Jo
  //
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
private:
  // 
  enum
  {
    STATE_NONE,                 // l(fȂA[VȂAǂݍ݂ĂȂ)
                                    // ̏Ԃ璼ɑ̏Ԃɏ̂ŁȀԂŃLN^f[^݂邱Ƃ͂Ȃ
    STATE_MODEL_LOADING,        // f\[Xǂݍݒ(fǂݍݒA[VȂ)
    STATE_MOTION_LOADING,       // [V\[Xǂݍݒ(fς݁A[Vǂݍݒ)
    STATE_CREATED,              // ς(fς݁A[Vς)
    STATE_MOTION_UNLOADING,     // [V\[Xj(fς݁A[VǂݍݒȂ̂j)
    STATE_MODEL_UNLOADING       // f\[Xj(fǂݍݒȂ̂jA[VȂ)
  };
  #if 0
    ԑJ
    OCX^X->STATE_NONE->Ƀf\[X̃[hJn->STATE_MODEL_LOADING
    ->f\[X̃[hAf𐶐A[V\[X̃[hJn->STATE_MOTION_LOADING
    ->[V\[X̃[hA[V𐶐->STATE_CREATED

    STATE_CREATED->[VjA[V\[X̃A[hJn->STATE_MOTION_UNLOADING
    ->[V\[X̃A[hAfjAf\[X̃A[hJn->STATE_MODEL_UNLOADING
    ->f\[X̃A[h->STATE_NONE->OCX^Xj

    STATE_*_LOADINĜƂɔjNGXgA*\[X̃A[hJnSTATE_*_UNLOADINGɂ(*MODEL or MOTION)
  #endif

private:
  b32 subCreateObjectManager(
    CharacterManagerCreateArg arg
  );
  void subDestroyObjectManager(void);
  b32 subRequestAsyncCreateObject(
    CharacterData*     object,
    CharacterCreateArg arg,
    const Individual*  value
  );
  void subRequestAsyncDestroyObject(
    CharacterData*     object
  );
  b32 subDoesExistObject(
    CharacterData*     object
  ) const;
  b32 subIsAbleToDestroyObject(
    CharacterData*     object
  ) const;
  void subUpdateAsyncLoadResource(void);
  b32 subCreateObject(
    CharacterData*     object,
    CharacterCreateArg arg,
    const Individual*  value
  );
  void subDestroyObject(
    CharacterData*     object
  );
  b32 subUpdateObjectAsyncLoadResource(
    CharacterData*     object
  );
  b32 subIsSameObject(
    CharacterData*     object,
    const Individual*  value
  ) const;
  void subCalculateObjectBefore(
    CharacterData*     object
  );
  void subCalculateObjectAfter(
    CharacterData*     object
  );

private:
  // [Vϐ̏
  void initializeMotion(CharacterData* object);
  // [Vǂݍ
  void requestReadMotion(CharacterData* object);
  // [Vǂݍ݂(ƂtrueԂ)
  b32 isFinishedReadMotion(CharacterData* object);
  // [V蓖Ă
  void createMotion(CharacterData* object);
  // [Vj
  void destroyMotion(CharacterData* object);


};


} // namespace dress_up
} // namespace xy_system


#endif  // __DRESSUPCHARACTERMANAGER_H__

