//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		UITouchBarView.cpp
 *	@brief  ^b`o[r[
 *	@author	Toru=Nagihashi
 *	@date		2012.05.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <app/ui/UITouchBarView.h>
#include <common_res/common_res_TouchBar.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(ui)

/**
 * @brief {^Ƃ̃ftHgݒ\
 */
static const struct
{
  u32 bind_key;
  u32 select_se;
}
BUTTON_DEFAULT_DATA[UITouchBarView::BUTTON_ID_MAX]  =
{
   ///<~{^
  {
    gfl::ui::BUTTON_X,
    SEQ_SE_CLOSE1
  },
  ///<߂{^
  {
    gfl::ui::BUTTON_B,
    SEQ_SE_CANCEL1,
  },
};

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param heap  \zpq[v
 * @param graphic_system  쐬OtBbNVXe
 * @param layout_system   쐬CAEgVXeiNULLƓō쐬܂dʎgȂ͂j
 * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
 * @param setup_tbl ǂ̃{^\z邩̐ݒe[u
 * @param tbl_len L̐ݒe[u̔z
 */
UITouchBarView::UITouchBarView( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len ) :
  app::ui::UIView( heap ),
  m_listener( NULL )
{
  //OtBbNVXe͖Ⴄ
  m_graphicSystem = graphic_system;
  
  //Viewւ̃Xio^
  this->SetInputListener( this );

  //쐬
  this->Create( heap, layout_system, position_layout_work, setup_tbl, tbl_len );
}

/**
 * @brief fXgN^
 */
UITouchBarView::~UITouchBarView()
{
}

//-----------------------------------------------------------------------
// XVE`
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void UITouchBarView::Update( void )
{
  this->UIView::Update();
}

/**
 * @brief `揈
 */
void UITouchBarView::Draw( void )
{
   m_g2dUtil->Draw2D( m_graphicSystem, 0 );
}

/**
 * @brief XVǂ
 * @return trueXV  falseȂɂĂȂ
 * 
 * @attension 삪dȂƂ́Å֐pāAKrĂB
 *            ȂƂclassAjɕʂȏʂȏɃXiAĂĂȋɂȂ肷ꍇ܂BUIView̎qƂē삷ꍇ͂܂B
 */
bool UITouchBarView::IsUpdate( void ) const
{
  return m_button_manager->GetUpdateState() != app::tool::ButtonManager::UPDATE_STATE_IDLE;
}

//-----------------------------------------------------------------------
// Xio^
//-----------------------------------------------------------------------
/**
 * @brief Xi[o^
 * @param listener  Xi[NX
 */
void UITouchBarView::SetListener( UITouchBarListener * listener)
{
  m_listener = listener;
}

//-----------------------------------------------------------------------
// ݒE擾
//-----------------------------------------------------------------------
/**
 * @brief \ݒ
 * @param button_id ݒ肷{^ID
 * @param is_visible  trueŕ\(ftHg) falseŔ\
 */
void UITouchBarView::SetVisible( ButtonID button_id, bool is_visible )
{
  if( is_visible )
  {
    m_button_manager->SetButtonVisible( this->GetPaneIDByButtonID(button_id) );
  }
  else
  {
    m_button_manager->SetButtonInvisible( this->GetPaneIDByButtonID(button_id) );
  }
}
/**
 * @brief \擾
 * @param button_id 擾{^ID
 * @return trueŕ\ falseŔ\
 */
bool UITouchBarView::IsVisible( ButtonID button_id ) const
{
  return m_button_manager->IsButtonVisible(this->GetPaneIDByButtonID(button_id));
}

/**
 * @brief ANeBuEpbVuݒ
 * @param button_id ݒ肷{^ID
 * @param is_active treuŃANeBu(ftHg) falseŃpbVu
 */
void UITouchBarView::SetActive( ButtonID button_id, bool is_active )
{
  if( is_active )
  {
    m_button_manager->SetButtonActive( this->GetPaneIDByButtonID(button_id) );
  }
  else
  {
    m_button_manager->SetButtonPassive( this->GetPaneIDByButtonID(button_id) );
  }
}

/**
 * @brief ANeBuEpbVu擾
 * @param button_id 擾{^ID
 * @return trueŃANeBu falseŃpbVu
 */
bool UITouchBarView::IsActive( ButtonID button_id ) const
{
  return m_button_manager->IsButtonActive( this->GetPaneIDByButtonID(button_id));
}

/**
 * @brief {^ɃoChL[ݒ
 * @param button_id ݒ肷{^ID
 * @param bind_key  oChL[igfl::ui::BUTTON_xxj(ftHg->{^ɑΉL[܂Ă̂̓oChĂ܂)
 */
void UITouchBarView::SetBindKey( ButtonID button_id, u32 bind_key )
{
  m_button_manager->SetButtonBindKey( this->GetPaneIDByButtonID(button_id), bind_key );
}

/**
 * @brief Iݒ
 * @param button_id ݒ肷{^ID
 * @param select_se ISEԍiftHg{^ɑΉSEꍇ͐ݒ肳Ă܂j
 */
void UITouchBarView::SetSelectSE( ButtonID button_id, u32 select_se )
{
  m_button_manager->SetButtonSelectSE( this->GetPaneIDByButtonID(button_id), select_se );
}

/**
 * @brief {^I^Cvݒ
 * @param button_id ݒ肷{^ID
 * @param select_type I^CviftHgׂSELECT_TYPE_RELEASEłAƂŃ{^ɂăftHgݒ肩邩j
 */
void UITouchBarView::SetSelectType( ButtonID button_id, app::tool::ButtonManager::SelectType select_type )
{
  m_button_manager->SetSelectType( this->GetPaneIDByButtonID(button_id), select_type );
}

/**
 * @brief {^ʒm^C~Oݒ
 * @param button_id ݒ肷{^ID
 * @param notify_timming  ʒm^C~OiftHgNOTIFY_AFTER_ANIMEłAƂŃ{^ɂăftHgݒ肩邩j
 */
void UITouchBarView::SetNotifyTimming( ButtonID button_id, app::tool::ButtonManager::NotifyTimming notify_timming )
{
  m_button_manager->SetNotifyTimming( this->GetPaneIDByButtonID(button_id), notify_timming ) ;
}

/**
 * @brief {^ʒmt[ݒ
 * @param button_id ݒ肷{^ID
 * @param long_press_frame  ʒmt[iftHgDEFAULT_LONG_PRESS_FRAMEj
 */
void UITouchBarView::SetLongPressFrame( ButtonID button_id, u32 long_press_frame )
{
  m_button_manager->SetButtonLongPressFrame( this->GetPaneIDByButtonID(button_id), long_press_frame );
}

/**
 * @brief ʒuݒ
 * @param pos@ʒu
 */
void UITouchBarView::SetPosition( const gfl::math::VEC3 & pos )
{
  //@todo
}

/**
 * @brief ʒu擾
 * @return ʒu
 */
const gfl::math::VEC3 UITouchBarView::GetPosition( void ) const
{
  return gfl::math::VEC3(0,0,0) ;//@todo
}

/**
 * @brief č\z
 * @param heap  \zpq[v
 * @param layout_system   쐬CAEgVXeiNULLƓō쐬܂dʎgȂ͂j
 * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
 * @param setup_tbl ǂ̃{^\z邩̐ݒe[u
 * @param tbl_len L̐ݒe[u̔z
 */
void UITouchBarView::Reload( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len )
{
  GFL_ASSERT_MSG(0,"쐬!\n" );
  
  this->Delete2D();
  this->Create( heap, layout_system, position_layout_work, setup_tbl, tbl_len );

  //@todo  ButtonManagerReloadł͍\̂킽AjPrivatełłȂ
}

/**
 * @brief View̃CAEgyCXi[I[o[Ch
 * @param pane_id ^b`ꂽsN`yC
 * @return trueȂΑCxg falseȂΑCxgr
 */
bool UITouchBarView::OnLayoutPaneEvent( const u32 pane_id )
{
  if( m_listener )
  {
    ButtonID buttonID = this->GetButtonIDByPaneID( pane_id );
    return m_listener->OnSelectedButton( buttonID );
  }
  return true;
}

/**
 * @brief View̃CAEgyCXi[I[o[Ch
 * @param pane_id ꂽsN`yC
 * @return trueȂΑCxg falseȂΑCxgr
 */
bool UITouchBarView::OnLayoutPaneLongPressEvent( const u32 pane_id )
{
  if( m_listener )
  {
    ButtonID buttonID = this->GetButtonIDByPaneID( pane_id );
    return m_listener->OnLongPressedButton( buttonID );
  }
  return true;
}

/**
 * @brief 쐬
 * @param heap  \zpq[v
 * @param layout_system   쐬CAEgVXeiNULLƓō쐬܂dʎgȂ͂j
 * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
 * @param setup_tbl ǂ̃{^\z邩̐ݒe[u
 * @param tbl_len L̐ݒe[u̔z
 */
void UITouchBarView::Create( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len )
{

  this->Create2D( heap, layout_system, 1, &common::resource::TouchBar::ARCID_TOUCHBAR, 1, &common::resource::TouchBar::LAYOUTWORK_DATA, 1, 0/*@todo*/ );
  //SETUP\̂ɐݒ肳Ă{^̐ݒ쐬
  app::ui::ButtonInfo *button_info = this->CreateButtonInfo( setup_tbl, tbl_len, heap->GetSystemHeap() );
  this->CreateButtonManager( heap, this->GetLayoutWork(0), button_info, tbl_len );
  GflHeapFreeMemory( button_info );

  //{^ݒ
  this->SetupButton(position_layout_work, setup_tbl,tbl_len);
}

/**
 * @brief {^}l[W[ւ̃{^ݒ\̍쐬
 * @param setup_tbl ݒe[u
 * @param tbl_len   e[u̗vf
 * @param heap      q[v
 * @return  {^}l[W[ւ̃{^ݒ\
 */
app::ui::ButtonInfo* UITouchBarView::CreateButtonInfo( const SETUP * setup_tbl, u32 tbl_len, gfl::heap::HeapBase * heap )
{
  app::ui::ButtonInfo* button_info = reinterpret_cast<app::ui::ButtonInfo*>(GflHeapAllocMemory(heap, sizeof(SETUP)*tbl_len) );
  for(int i=0;i<tbl_len;++i)
  {
    button_info[i]  = common::resource::TouchBar::BUTTON_INFO[ setup_tbl[i].button_id ];
  }
  
  return button_info;
}

/**
 * @brief {^ݒ
 * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
 * @param setup_tbl ݒe[u
 * @param tbl_len   e[u̗vf
 */
void UITouchBarView::SetupButton( gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len )
{
  for(int i=0;i<tbl_len;++i)
  {
    ButtonID buttonID = setup_tbl[i].button_id;
    //POS
    gfl::grp::g2d::LytPane* pos_pane = position_layout_work->GetPane( setup_tbl->position_pane );
    gfl::math::VEC3 pos = pos_pane->GetTranslate();
    this->SetPanePos( 0, this->GetPaneIDByButtonID(buttonID), &pos );
    this->SetPanePos( 0, common::resource::TouchBar::BUTTON_INFO[buttonID].bound_pane, &pos );
    //SE
    m_button_manager->SetButtonSelectSE( this->GetPaneIDByButtonID(buttonID), BUTTON_DEFAULT_DATA[buttonID].select_se );
    //KEY
    m_button_manager->SetButtonBindKey( this->GetPaneIDByButtonID(buttonID), BUTTON_DEFAULT_DATA[buttonID].bind_key );
  }
}

/**
 * @brief sN`yC{^ID擾
 * @param pane_id sN`yC
 * @return  {^ID
 */
UITouchBarView::ButtonID UITouchBarView::GetButtonIDByPaneID( u32 pane_id ) const
{
  for(int i=0;i<common::resource::TouchBar::BUTTON_INFO_MAX;++i)
  {
    if( common::resource::TouchBar::BUTTON_INFO[i].picture_pane == pane_id )
    {
      return static_cast<UITouchBarView::ButtonID>(i);
    }
  }

  GFL_ASSERT(0);
  return static_cast<UITouchBarView::ButtonID>(0);
}

/**
 * @brief {^IDsN`yC擾
 * @param button_id {^ID
 * @return sN`yC
 */
u32 UITouchBarView::GetPaneIDByButtonID( ButtonID button_id ) const
{
  return common::resource::TouchBar::BUTTON_INFO[button_id].picture_pane;
}

GFL_NAMESPACE_END(ui)
GFL_NAMESPACE_END(app)
