//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		UITouchBarView.h
 *	@brief  ^b`o[r[
 *	@author	Toru=Nagihashi
 *	@date		2012.05.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __UITOUCHBARVIEW_H__
#define __UITOUCHBARVIEW_H__
#pragma once

#include <app/ui/UIView.h>
#include <app/ui/UITouchBarListener.h>
#include <common_res/common_res_TouchBar.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(ui)

//=============================================================================
/**
 *  @brief ^b`o[r[
 * 
 *  @note ^b`o[dl
 *        PD^b`o[CAEgɂ̓^b`o[Ŏgp{^SĂB
 *            ʂ̃CAEgf[^AO{^o^邱Ƃ͂łȂB
 *          
 *        QD^b`o[geʂł́AʂɃ^b`o[CAEgƊeʗpCAEĝQ\B(Ⴆ΃g[i[J[hȂ΁Aʂɂ̓^b`o[CAEgƃg[i[J[hpCAEĝQ\)
 *            
 *        RD^b`o[ɂ{^ǂɕ\邩́AeʃCAEgɓ\NULLyCōsBi摤ő삳邽߁jiႦ΃g[i[J[h̃CAEgɂ͖߂{^ʒuݒpNULLyCƁ~{^ʒuݒpNULLyC݂Ȃ΂ȂȂj
 *
 */
//=============================================================================
class UITouchBarView : public UIView, public UIInputListener
{
  GFL_FORBID_COPY_AND_ASSIGN(UITouchBarView);
public:
  /**
   *  @brief {^IDiUITouchBarListenerłg܂j
   */
  enum ButtonID
  {
    BUTTON_ID_EXIT    = common::resource::TouchBar::BUTTON_INFO_EXIT,  ///<~{^
    BUTTON_ID_RETURN  = common::resource::TouchBar::BUTTON_INFO_RETURN,///<߂{^

    BUTTON_ID_MAX
  };

  /**
   *  @brief {^̐ݒ\́@̍\̂̔zRXgN^ɓnĂ
   */
  struct SETUP
  {
    ButtonID    button_id;      ///<ݒ肷{^ID
    gfl::grp::g2d::LytPaneIndex position_pane;  ///<ʒupNULLyC(LdlR)
  };
    
public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   * @param heap  \zpq[v
   * @param graphic_system  쐬OtBbNVXe
   * @param layout_system   쐬CAEgVXeiNULLƓō쐬܂dʎgȂ͂j
   * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
   * @param setup_tbl ǂ̃{^\z邩̐ݒe[u
   * @param tbl_len L̐ݒe[u̔z
   */
  UITouchBarView( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len );
  /**
   * @brief fXgN^
   */
  virtual ~UITouchBarView();

  //-----------------------------------------------------------------------
  // XVE`
  //-----------------------------------------------------------------------
  /**
   * @brief XV
   */
  void Update( void );

  /**
   * @brief `揈
   */
  virtual void Draw( void );

  /**
   * @brief XVǂ
   * @return trueXV  falseȂɂĂȂ
   * 
   * @attension 삪dȂƂ́Å֐pāAKrĂB
   *            ȂƂclassAjɕʂȏʂȏɃXiAĂĂȋɂȂ肷ꍇ܂BUIView̎qƂē삷ꍇ͂܂B
   */
  bool IsUpdate( void ) const;

  //-----------------------------------------------------------------------
  // Xio^
  //-----------------------------------------------------------------------
  /**
   * @brief Xi[o^
   * @param listener  Xi[NX
   */
  void SetListener( UITouchBarListener * listener);

  //-----------------------------------------------------------------------
  // ݒE擾
  //-----------------------------------------------------------------------
  /**
   * @brief \ݒ
   * @param button_id ݒ肷{^ID
   * @param is_visible  trueŕ\(ftHg) falseŔ\
   */
  void SetVisible( ButtonID button_id, bool is_visible );
  /**
   * @brief \擾
   * @param button_id 擾{^ID
   * @return trueŕ\ falseŔ\
   */
  bool IsVisible( ButtonID button_id ) const;

  /**
   * @brief ANeBuEpbVuݒ
   * @param button_id ݒ肷{^ID
   * @param is_active treuŃANeBu(ftHg) falseŃpbVu
   */
  void SetActive( ButtonID button_id, bool is_active );

  /**
   * @brief ANeBuEpbVu擾
   * @param button_id 擾{^ID
   * @return trueŃANeBu falseŃpbVu
   */
  bool IsActive( ButtonID button_id ) const;

  /**
   * @brief {^ɃoChL[ݒ
   * @param button_id ݒ肷{^ID
   * @param bind_key  oChL[igfl::ui::BUTTON_xxj(ftHg->{^ɑΉL[܂Ă̂̓oChĂ܂)
   */
  void SetBindKey( ButtonID button_id, u32 bind_key );

  /**
   * @brief Iݒ
   * @param button_id ݒ肷{^ID
   * @param select_se ISEԍiftHg{^ɑΉSEꍇ͐ݒ肳Ă܂j
   */
  void SetSelectSE( ButtonID button_id, u32 select_se );

  /**
   * @brief {^I^Cvݒ
   * @param button_id ݒ肷{^ID
   * @param select_type I^CviftHgׂSELECT_TYPE_RELEASEłAƂŃ{^ɂăftHgݒ肩邩j
   */
  void SetSelectType( ButtonID button_id, app::tool::ButtonManager::SelectType select_type );

  /**
   * @brief {^ʒm^C~Oݒ
   * @param button_id ݒ肷{^ID
   * @param notify_timming  ʒm^C~OiftHgNOTIFY_AFTER_ANIMEłAƂŃ{^ɂăftHgݒ肩邩j
   */
  void SetNotifyTimming( ButtonID button_id, app::tool::ButtonManager::NotifyTimming notify_timming );

  /**
   * @brief {^ʒmt[ݒ
   * @param button_id ݒ肷{^ID
   * @param long_press_frame  ʒmt[iftHgDEFAULT_LONG_PRESS_FRAMEj
   */
  void SetLongPressFrame( ButtonID button_id, u32 long_press_frame );

  /**
   * @brief ʒuݒ
   * @param pos@ʒu
   */
  void SetPosition( const gfl::math::VEC3 & pos );

  /**
   * @brief ʒu擾
   * @return ʒu
   */
  const gfl::math::VEC3 GetPosition( void ) const;

  //-----------------------------------------------------------------------
  // č\z
  //-----------------------------------------------------------------------
  /**
   * @brief č\z
   * @param heap  \zpq[v
   * @param layout_system   쐬CAEgVXeiNULLƓō쐬܂dʎgȂ͂j
   * @param position_layout_work SETUPe[uŎw肵position_paneĂ郌CAEg[N
   * @param setup_tbl ǂ̃{^\z邩̐ݒe[u
   * @param tbl_len L̐ݒe[u̔z
   */
  void Reload( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len );

private:
  virtual bool OnLayoutPaneEvent( const u32 pane_id );
  virtual bool OnLayoutPaneLongPressEvent( const u32 pane_id );
  
protected:
  void Create( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len );
  app::ui::ButtonInfo* CreateButtonInfo( const SETUP * setup_tbl, u32 tbl_len, gfl::heap::HeapBase * heap );
  void SetupButton( gfl::grp::g2d::LytWk *position_layout_work, const SETUP * setup_tbl, u32 tbl_len );
  UITouchBarView::ButtonID GetButtonIDByPaneID( u32 pane_id ) const;
  u32 GetPaneIDByButtonID( ButtonID button_id ) const;
  
private:
  UITouchBarListener * m_listener;
};


GFL_NAMESPACE_END(ui)
GFL_NAMESPACE_END(app)

#endif		// __UITOUCHBARVIEW_H__
