#if PM_DEBUG

//============================================================================================
/**
 * @file    test_tamada_menu.cpp
 * @brief   ^CgfobOu܂vj[
 * @author  tamada@gamefreak.co.jp
 * @date    12.05.13
 *
 * XNN̂Rsyčt@CɃRsy
 */
//============================================================================================
#include <gflib.h>
#include <gfl_Heap.h>
#include <gfl_Base.h>

#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"

#include "test/tamada/test_tamada_menu.h"

#include <dll/DllProc.h>
#include <ro/gfl_RoManager.h>
#include <netapp/tradelist/tradelist.h>




namespace test {
namespace tamada {


Proc*     Proc::m_instance;



// x`
enum SkelUserLabel {
  LAUNCHERLABEL_TRADELIST,
  LAUNCHERLABEL_EXIT,

  LAUNCHERLABEL_MAX,     // xől

  ENUM_FORCE_DWORD(SkelUserLabel)
};

static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap );
static void setTradelistParam( netapp::tradelist::APP_PARAM *prm, gfl::heap::HeapBase* heap );


// N
static const skel::LauncherLabel LauncherLabel[] =
{
    { L"TRADE LIST",   LAUNCHERLABEL_TRADELIST },
    { L"end",          LAUNCHERLABEL_EXIT },
};

// NZbgAbv
static const skel::LauncherSetUp LauncherSetUp = {
  LauncherLabel,
  LAUNCHERLABEL_MAX
};


//--------------------------------------------------------------------------------------------
/**
 * @brief    RXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc(void)
{
  m_isFinish = false;
  m_instance = this;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    Proc
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
//  RcvFlag = false;
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    ProcI
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    ProcAbvf[g
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
  if( m_isFinish ){
    return gfl::proc::RES_FINISH;
  }
  CreateMenu();

  return gfl::proc::RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    Proc`揈
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
}


void Proc::CreateMenu(void)
{
  skel::LauncherProc * pLauncher = GFL_NEW( mpGameProcManager->GetHeap() )  skel::LauncherProc;
  pLauncher->SetGameProcManager( mpGameProcManager );
  mpGameProcManager->CallProc( pLauncher );
  pLauncher->SetParamGM( &LauncherSetUp, SetUpUserProc );
}


void Proc::DeleteMenu(void)
{
}

static void setTradelistParam( netapp::tradelist::APP_PARAM *prm, gfl::heap::HeapBase* heap  )
{
	gamesystem::GameData * gd = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetGameData();

	prm->pSaveBox        = gd->GetBox();						// Z[uf[^F{bNX
	prm->pSaveBoxPokemon = gd->GetBoxPokemon();			// Z[uf[^F{bNX|P
	prm->pPokeParty      = gd->GetPlayerParty();		// 莝|P
	prm->pMyStatus       = gd->GetPlayerStatus();		// vC[Xe[^X

  // K|Pf[^Ă
  {
    pml::pokepara::PokemonParam* poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_ZYUGON, 5, 0 );
    prm->pPokeParty->AddMember( *poke );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_PAUWAU, 5, 0 );
    prm->pPokeParty->AddMember( *poke );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_DAIKENKI, 5, 0 );
    prm->pPokeParty->AddMember( *poke );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_GIARU, 5, 0 );
    prm->pSaveBoxPokemon->PutPokemonEmptyTrayAll( poke, 0, heap );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_GIGIARU, 5, 0 );
    prm->pSaveBoxPokemon->PutPokemonEmptyTrayAll( poke, 0, heap );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_GIGIGIARU, 5, 0 );
    prm->pSaveBoxPokemon->PutPokemonEmptyTrayAll( poke, 0, heap );
    GFL_DELETE poke;
  }

  GFL_PRINT( "pSaveBox       =%8x\n", prm->pSaveBox       );
  GFL_PRINT( "pSaveBoxPokemon=%8x\n", prm->pSaveBoxPokemon);
  GFL_PRINT( "pPokeParty     =%8x\n", prm->pPokeParty     );
  GFL_PRINT( "pMyStatus      =%8x\n", prm->pMyStatus      );

}

// R[obN͂߂Ăق
static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap )
{
  Proc *mainProc = Proc::GetInstance();

  GFL_UNUSED( heap );

  switch( selectNum )
  {

    case LAUNCHERLABEL_EXIT:
      mainProc->SetFinish();
      return skel::LAUNCHER_RET_CHANGE_DEBUGMODE;

    case LAUNCHERLABEL_TRADELIST:
      {
        static netapp::tradelist::APP_PARAM prm;
        setTradelistParam( &prm, heap );
        dll::CallTradelistProc( p_procMan, &prm );
      }
      return skel::LAUNCHER_RET_CALL_NORMAL;
  }

  return skel::LAUNCHER_RET_CALL_DEBUGMODE;
}



}  // tamada
}  // test

#endif // PM_DEBUG
