//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		common_res_TouchBar.cpp
 *	@brief  ^b`o[ʑf
 *	@author	Toru=Nagihashi
 *	@date		2012.05.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>

#include <arc/arc_def.h>
#include "touchbar_common_2d.h"
#include "touchbar_common_2d_pane.h"

#include <common_res/common_res_TouchBar.h>

GFL_NAMESPACE_BEGIN(common)
GFL_NAMESPACE_BEGIN(resource)

/**
  *  @brief ^b`o[ĂARCID
  */
const gfl::fs::ArcFile::ARCID TouchBar::ARCID_TOUCHBAR  = ARCID_TOUCHBAR_COMMON_GRA;

/**
 *  @brief ^b`o[̃CAEgf[^ĂLytArcIndex
 */
const gfl::grp::g2d::LytArcIndex TouchBar::LYTARC_INDEX_TOUCHBAR  = LYTRES_TOUCHBAR_COMMON_2D_TOUCH_BAR_LOWER_BCLYT;

/**
 *  @brief ^b`o[̃Aj[Vf[^
 */
const gfl::grp::g2d::LytArcIndex TouchBar::ANIMATION_DATA_TBL[TouchBar::ANIMATION_ID_MAX] =
{
  LYTRES_TOUCHBAR_COMMON_2D_TOUCH_BAR_LOWER_EXIT_ICON2_BCLAN,
  LYTRES_TOUCHBAR_COMMON_2D_TOUCH_BAR_LOWER_EXIT_ICON3_BCLAN,
  LYTRES_TOUCHBAR_COMMON_2D_TOUCH_BAR_LOWER_RETURN_ICON2_BCLAN,
  LYTRES_TOUCHBAR_COMMON_2D_TOUCH_BAR_LOWER_RETURN_ICON3_BCLAN,
};

/**
 *  @brief ^b`o[̃{^CtH
 */
const app::ui::ButtonInfo TouchBar::BUTTON_INFO[TouchBar::BUTTON_INFO_MAX] =
{
  {
    PANENAME_TOUCH_BAR_LOWER_PANE_EXIT_ICON,
    PANENAME_TOUCH_BAR_LOWER_PANE_EXIT_BOUND,
    TouchBar::ANIMATION_ID_EXIT_TRGGER,
    TouchBar::ANIMATION_ID_EXIT_SELECT,
    TouchBar::ANIMATION_ID_EXIT_SELECT,
    app::tool::ButtonManager::ANIMATION_NULL,
    app::tool::ButtonManager::ANIMATION_NULL,
  },
  {
    PANENAME_TOUCH_BAR_LOWER_PANE_RETURN_ICON,
    PANENAME_TOUCH_BAR_LOWER_PANE_RETURN_BOUND,
    TouchBar::ANIMATION_ID_RETURN_TRGGER,
    TouchBar::ANIMATION_ID_RETURN_SELECT,
    TouchBar::ANIMATION_ID_RETURN_SELECT,
    app::tool::ButtonManager::ANIMATION_NULL,
    app::tool::ButtonManager::ANIMATION_NULL,
  },
};

/**
 *  @brief ^b`o[CAEgǂݍ񂾃CAEg[N쐬
 *  @param layout_system  CAEgVXe
 *  @param resID ARCID_TOUCHBARǂݍ񂾃CAEg\[XID
 *  @retval CAEg[N
 *  @note CreateWorkĂ邾Ȃ̂ő̐ݒ͊OōsȂĂB
 */
gfl::grp::g2d::LytWk* TouchBar::CreateLayoutWork( gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytResID resID )
{
  static const gfl::grp::g2d::LytWkSetUp setup =
  { // 
    gfl::math::VEC3(0,-290,0),  // pos
    gfl::math::VEC2(1,1),       // scale
    gfl::math::VEC3(0,0,0),     // rotate
    1,                          // priority
  };

  return layout_system->CreateLytWk(
      resID,
      LYTARC_INDEX_TOUCHBAR,
      ANIMATION_DATA_TBL,
      ANIMATION_ID_MAX,
      ANIMATION_ID_MAX,
      &setup,
      false ); 
}

/**
 *  @brief {^}l[Wւ̃{^ݒ
 *  @param button_manager {^}l[W
 *  @param heap  q[v
 *  @param layout_work  ^b`o[ǂݍ񂾃CAEg[N
 *  @param buttonID {^ɓo^ID
 *  @param infoID ̃{^ɂǂ̃\[Xo^邩
 *  @param callback_target R[obN
 */
void TouchBar::AddButton( app::tool::ButtonManager *button_manager, gfl::heap::HeapBase* heap, gfl::grp::g2d::LytWk* layout_work, app::tool::ButtonManager::ButtonId buttonID, ButtonInfoIndex infoID, app::tool::ButtonManager::IButtonCallback* callback_target )
{
  GFL_ASSERT( infoID < BUTTON_INFO_MAX );
  const app::ui::ButtonInfo & button_info = BUTTON_INFO[ infoID ];

  button_manager->AddButton( 
          heap, 
          buttonID,
          layout_work,
          button_info.picture_pane,
          button_info.bound_pane,
          button_info.hold_anime_index,
          button_info.release_anime_index,
          button_info.select_anime_index,
          button_info.active_anime_index,
          button_info.passive_anime_index,
          callback_target );
}

GFL_NAMESPACE_END(resource)
GFL_NAMESPACE_END(common)
