//============================================================================================
/**
 * @brief orrTuvZXuvCj[vNX
 */
//============================================================================================
#include "pss_subproc_playmenu.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcPlayMenu::PssSubProcPlayMenu( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   fXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcPlayMenu::~PssSubProcPlayMenu( void )
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr      GameProcManagerւ̃|C^
* @param   execMode         샂[h
* @param   msgData          bZ[Wf[^
* @param   wordset          [hZbg
* @param   paramWork        Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcPlayMenu::Init( gamesystem::GameProcManager *gameProgMgr, E_EXEC_MODE execMode,
                                          gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  app::pss::pss_play_select::E_EXEC_MODE playSelectMode;

  if( E_EXEC_FAR == execMode ){
    playSelectMode = app::pss::pss_play_select::E_MODE_FAR_PLAY;
  }
  else{
    playSelectMode = app::pss::pss_play_select::E_MODE_NEAR_PLAY;
  }

  app::pss::pss_play_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_play_select::APP_PARAM*>(m_paramWork);
  param->m_layout      = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData = msgData;
  param->m_wordset     = wordset;
  param->m_execMode    = playSelectMode;

  m_subProc = dll::CreatePssPlaySelectProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcPlayMenu::Update( void )
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_play_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_play_select::APP_PARAM*>(m_paramWork);

    switch( param->m_resultCode )
    {
      // og[Iʂ
      case  app::pss::pss_play_select::E_RESULT_CODE_BATTLE:
        return RET_MENU_PLAY_BATTLE;

      // ʂ
      case  app::pss::pss_play_select::E_RESULT_CODE_TRADE:
        return RET_MENU_PLAY_TRADE;

      // PSS TOPʂ
      case  app::pss::pss_play_select::E_RESULT_CODE_CLOSE:
        return RET_MENU_PLAY_STOP;

      default:
        return RET_MENU_PLAY_CANCEL;
    }
  }

  return RET_NONE;
}



}		// subproc
}		// pss
}		// subscreen
}		// field

