
//============================================================================================
/**
 * @brief orrTuvZXuog\ݑJځiWifi/Wireless)vNX
 */
//============================================================================================
#include "pss_subproc_battle_request_beacon.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::PssSubProcBattleRequestWithBeacon( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   fXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::~PssSubProcBattleRequestWithBeacon( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr        GameProcManagerւ̃|C^
* @param   beaconResponder    PssBeaconResponderւ̃|C^
* @param   iconMgr            PlayerIconManagerւ̃|C^
* @param   topList            PSSgbvXgvZXւ̃|C^
* @param   topListUIListener  PSSgbvXgpftHgUIXi
* @param   msgData            bZ[Wf[^
* @param   wordset            [hZbg
* @param   paramWork          Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcBattleRequestWithBeacon::Init( gamesystem::GameProcManager *gameProgMgr,
                      netapp::pss::PssBeaconResponder* beaconResponder,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      app::pss::pss_top_list::Proc* topList,
                      app::pss::pss_top_list::PssTopListUIListener* topListUIListener,
                      const gflnet::friends::FriendKey& friendKey,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, beaconResponder, paramWork );

  m_invitePlayer      = friendKey;
  m_topListProc       = topList;
  m_playerIconMgr     = iconMgr;
  m_msgData           = msgData;
  m_wordset           = wordset;
  m_topListUIListener = topListUIListener;
  m_seq               = MAINSEQ_RULE_SELECT;
  m_pssPersonalMgr    = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetPssPersonalDataManager();

  InitRuleSelect();

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcBattleRequestWithBeacon::Update( void )
{
  switch( m_seq )
  {
    case MAINSEQ_RULE_SELECT:
      m_seq = RuleSelect();
      break;
    case MAINSEQ_PLAYER_SELECT:
      m_seq = PlayerSelect();
      break;
    case MAINSEQ_SAVE:
      m_seq = Save();
      break;
    case MAINSEQ_CHECK_USER:
      m_seq = CheckUser();
      break;
    case MAINSEQ_NETWORK_CALLING:
      m_seq = NetworkCalling();
      break;
    case MAINSEQ_REQUEST:
      m_seq = Request();
      break;
    case MAINSEQ_REQUEST_CANCEL:
      m_seq = RequestCancel();
      break;
    case MAINSEQ_REQUEST_FAILED:
      m_seq = RequestFailed();
      break;
  }

  if( m_seq == MAINSEQ_COLOSSEUM_BATTLE )
  {
    // r[Rf[^Zbg
    netapp::pss::PssPersonalData* me = m_pssPersonalMgr->GetMyData();
    me->ResetBattleRequest();
    return RET_MENU_FAR_COMM_COLOSSEUM_BATTLE;
  }
  else if( m_seq == MAINSEQ_STOP ){
    return RET_MENU_FAR_COMM_STOP;
  }
  else if( m_seq == MAINSEQ_CANCEL ){
    return RET_MENU_FAR_COMM_CANCEL;
  }

  return RET_NONE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ탋[Iʂ̏
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::InitRuleSelect(void)
{
  app::pss::pss_rule_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_rule_select::APP_PARAM*>(m_paramWork);
  param->m_layout      = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData = m_msgData;
  param->m_wordset     = m_wordset;

  m_subProc = dll::CreatePssRuleSelectProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ탋[Iʂ̍XV
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::RuleSelect(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_rule_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_rule_select::APP_PARAM*>(m_paramWork);

    // LZ
    if( param->m_resultCode == app::pss::pss_rule_select::E_RESULT_CODE_CANCEL )
    {
      return MAINSEQ_CANCEL;
    }
    // orrgbvʂ
    else if( param->m_resultCode == app::pss::pss_rule_select::E_RESULT_CODE_CLOSE )
    {
      return MAINSEQ_STOP;
    }
    // vC[I
    else
    {
      // Iꂽ[L^
      m_battleRuleSetting = param->m_ruleSetting;

      if( InitPlayerSelect() )
      {
        // vC[I
        return MAINSEQ_PLAYER_SELECT;
      }
      else
      {
        // ʐMڑJn
        if( InitNetworkCalling() ){
          return MAINSEQ_NETWORK_CALLING;
        }
        else{
          CancelMasterBeaconForBattleRequest();
          return MAINSEQ_STOP;
        }
      }
    }
  }
  return MAINSEQ_RULE_SELECT;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   vC[Iʏ
 *
 * @param   none
 *
 * @return  vC[IXLbvȂfalsew
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcBattleRequestWithBeacon::InitPlayerSelect(void)
{
  app::pss::pss_player_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_player_select::APP_PARAM*>(m_paramWork);
  param->m_layout      = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData = m_msgData;
  param->m_wordset     = m_wordset;
  param->m_inviteNum   = (m_battleRuleSetting.m_battleType==app::pss::pss_rule_select::BATTLE_TYPE_MULTI)?3:1;
  param->m_listMenu    = m_topListProc;

  // m胆[U[o^ς݁H
  if( netapp::pss::PssPersonalData::IsValidFriendKey(m_invitePlayer) )
  {
    if( m_battleRuleSetting.m_battleType == app::pss::pss_rule_select::BATTLE_TYPE_MULTI )
    {
      param->m_commitNum = 1;
      param->m_selectedPlayer[0] = m_invitePlayer;
    }
    else
    {
      m_multiBattlePlayer[0] = m_invitePlayer;
      return false; // ܂Ă邩IԕKvȂI
    }
  }
  else{
    param->m_commitNum = 0;
  }

  app::pss::pss_player_select::Proc* subProc = dll::CreatePssPlayerSelectProc( m_gameProgMgr, param );
  m_subProc = subProc;
  m_subProc->InitFunc( m_gameProgMgr );

  // PssTopListUIListener̒ʒmύX
  m_topListProc->SetPssTopListUIListener( subProc->GetPssTopListUIListener() );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		vC[I
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::PlayerSelect(void)
{
  if( m_topListProc )
  {
    m_topListProc->UpdateFunc( m_gameProgMgr );
  }

  if( !UpdateSubProc() )
  {
    app::pss::pss_player_select::APP_PARAM *param = reinterpret_cast<app::pss::pss_player_select::APP_PARAM*>(m_paramWork);

    // LXg̃CxgXiCɖ߂
    m_topListProc->SetPssTopListUIListener( m_topListUIListener );

    if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_CANCEL )
    {
      InitRuleSelect();
      return MAINSEQ_RULE_SELECT;
    }
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_CLOSE )
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      return MAINSEQ_STOP;
    }
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_SELECTED_ALL )
    {
      memcpy( m_multiBattlePlayer, param->m_selectedPlayer, sizeof(m_multiBattlePlayer) );
      m_multiBattlePlayerNum = param->m_selectedPlayerNum;

      //InitSave();
      //return MAINSEQ_SAVE;

      // SROMł̓Z[uȂ
      InitCheckUser();
      return MAINSEQ_CHECK_USER;
    }
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_INVITE )
    {
      // ݂Ȃΐɏ
      InitSave();
      return MAINSEQ_SAVE;
    }
  }
  return MAINSEQ_PLAYER_SELECT;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  uQҊmFv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::InitCheckUser( void )
{
  app::pss::pss_user_notify::APP_PARAM *param = reinterpret_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);
  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_ruleSetting   = m_battleRuleSetting;
  param->m_playerIconMgr = m_playerIconMgr;

  std::memcpy( param->m_targetPlayer, m_multiBattlePlayer, sizeof(m_multiBattlePlayer) );

  // VOog
  if( m_multiBattlePlayerNum == 1 ){
    param->m_execMode = app::pss::pss_user_notify::E_MODE_SINGLE_BATTLE_REQUEST;
  }
  // }`og
  else{
    param->m_execMode = app::pss::pss_user_notify::E_MODE_MULTI_BATTLE_REQUEST;
  }

  m_subProc = dll::CreatePssUserNotifyProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  uQҊmFvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::CheckUser(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_user_notify::APP_PARAM *param = reinterpret_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);

    // łnjI
    if( param->m_isSelectYes )
    {
      m_multiBattlePlayer[0] = param->m_targetPlayer[0];

      // VOog
      //if( m_battleRuleSetting.m_battleType != app::pss::pss_rule_select::BATTLE_TYPE_MULTI )
      {
        if( InitNetworkCalling() ){
          return MAINSEQ_NETWORK_CALLING;
        }
        else{
          CancelMasterBeaconForBattleRequest();
          return MAINSEQ_STOP;
        }
      }
      // }`og
      //else{
      //
      //}
    }
    // ₾AȂI
    else
    {
      InitPlayerSelect();
      return MAINSEQ_PLAYER_SELECT;
    }
  }

  return MAINSEQ_CHECK_USER;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Z[uʏ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::InitSave(void)
{
  app::report::APP_PARAM *param = reinterpret_cast<app::report::APP_PARAM*>(m_paramWork);
  param->m_layout       = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_isEnableFade = false;

  m_subProc = dll::CreateReportMenuProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Z[u
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::Save(void)
{
  if( !UpdateSubProc() )
  {
    app::report::APP_PARAM *param = reinterpret_cast<app::report::APP_PARAM*>(m_paramWork);

    // Z[u
    if( param->m_isSaveSuccess )
    {
      if( InitNetworkCalling() ){
        return MAINSEQ_NETWORK_CALLING;
      }
      else{
        CancelMasterBeaconForBattleRequest();
        return MAINSEQ_STOP;
      }
    }
    // Z[uȂ
    else
    {
      if( InitPlayerSelect() ){
        return MAINSEQ_PLAYER_SELECT;
      }
      else
      {
        InitRuleSelect();
        return MAINSEQ_RULE_SELECT;
      }
    }
  }

  return MAINSEQ_SAVE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑ҂ʏ
 *
 * @param   none
 *
 * @return  ɏŒȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcBattleRequestWithBeacon::InitNetworkCalling(void)
{
  netapp::pss::PssPersonalData* targetPerson = m_pssPersonalMgr->GetPersonalData( m_multiBattlePlayer[0] );

  if( targetPerson == NULL ){
    return false;
  }
  app::pss::pss_message_window::APP_PARAM* param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_targetPlayer  = m_multiBattlePlayer[0];
  param->m_type          = app::pss::pss_message_window::E_TYPE_CHAR_MESSAGE;
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = true;
  param->m_inputLock     = false;

  // PSS[U[ʕʂɃbZ[WύX
  if( targetPerson->IsFriend() ){
    param->m_messageText = msg_pss_02_09;     // Ƃ́ɐ\ł܂
  }
  else if( targetPerson->IsAcquaintance() ){
    param->m_messageText = msg_pss_02_09_02;  // m荇́ɐ\ł܂
  }
  else{
    param->m_messageText = msg_pss_02_09_03;  // ʂ肷́ɐ\ł܂
  }
  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  // ʐMJnԂL^
  gfl::std::DateTime::GetNow( &m_connectStartingTime );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʐMĂяo
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::NetworkCalling(void)
{
  if(m_beaconResponder->GetEachOther())
  {
    //ʐM e@ɂȂ > Ăяo悤Ƀr[RύX
    netapp::beacon::GFEachOther*  pEach        = m_beaconResponder->GetEachOther();
    netapp::pss::PssPersonalData* targetPerson = m_pssPersonalMgr->GetPersonalData( m_multiBattlePlayer[0] );
    netapp::pss::PssPersonalData* myInfo       = m_pssPersonalMgr->GetMyData();
    gflnet::friends::FriendKey    friendKey    = targetPerson->GetFriendKey();

    myInfo->SetRequestTargetUser( &friendKey, 1 );
    myInfo->SetRequestBattle( m_battleRuleSetting.m_battleRule, m_battleRuleSetting.m_battleType, m_battleRuleSetting.m_isHandicap );
    m_beaconResponder->SendMyData();

    // P2PʐMJn
    if( pEach->ConnectStart( targetPerson->GetTransferedID() ) ){
      return MAINSEQ_REQUEST;
    }
  }

  // P2PʐMG[I
  ReleaseProc( &m_subProc );
  InitBattleCancelAction();
  return MAINSEQ_REQUEST_FAILED;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ڑ҂
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::Request(void)
{
  //ڑꍇɃV[PXi
  if(m_beaconResponder->GetEachOther())
  {
    if(m_beaconResponder->GetEachOther()->IsConnect())
    {
      ReleaseProc( &m_subProc );
      m_beaconResponder->GetEachOther()->ResetConnect();
      m_beaconResponder->GetEachOther()->NetworkContinue();
      return MAINSEQ_COLOSSEUM_BATTLE;
    }
  }

  if( !UpdateSubProc() )
  {
    InitRequestCancel();
    return MAINSEQ_REQUEST_CANCEL;
  }

  // PԂŃ^CAEg
  if( IsTimeout(60000) )
  {
    ReleaseProc( &m_subProc );
    InitBattleCancelAction();
    return MAINSEQ_REQUEST_FAILED;
  }
  return MAINSEQ_REQUEST;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑG[
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::RequestFailed(void)
{
  if( !UpdateSubProc() )
  {
    // P2PʐMLZ
    CancelMasterBeaconForBattleRequest();
    return MAINSEQ_STOP;
  }

  return MAINSEQ_REQUEST_FAILED;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ󂯓ʁFuڑLZv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::InitBattleCancelAction( void )
{
  app::pss::pss_message_window::APP_PARAM *param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_05_06_01;  // sȂ܂Bΐ𒆎~܂B
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑ҂LZʏ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::InitRequestCancel(void)
{
  app::pss::pss_yesno_dialog::APP_PARAM *param = reinterpret_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);
  param->m_layout       = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData  = m_msgData;
  param->m_wordset      = m_wordset;
  param->m_messageId    = msg_pss_02_10;

  m_subProc = dll::CreatePssYesNoDialog( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑLZ
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleRequestWithBeacon::E_BATTLE_REQUEST_SEQUENCE PssSubProcBattleRequestWithBeacon::RequestCancel(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_yesno_dialog::APP_PARAM *param = reinterpret_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);

    // ~
    if( param->m_isSelectYes )
    {
      // r[Rʏ탂[hɖ߂
      CancelMasterBeaconForBattleRequest();
      GFL_PRINT( "Reboot Beacon1\n" );
      return MAINSEQ_STOP;
    }
    // ~Ȃ
    else
    {
      if( InitNetworkCalling() ){
        return MAINSEQ_REQUEST;
      }
      else{
        CancelMasterBeaconForBattleRequest();
        return MAINSEQ_STOP;
      }
    }
  }

  return MAINSEQ_REQUEST_CANCEL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ʐMLZ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleRequestWithBeacon::CancelMasterBeaconForBattleRequest( void )
{
  // P2P~
  if(m_beaconResponder->GetEachOther() != NULL )
  {
    m_beaconResponder->GetEachOther()->MasterFinalize();
  }
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );

  // r[Rf[^Zbg
  netapp::pss::PssPersonalData* me = m_pssPersonalMgr->GetMyData();
  me->ResetBattleRequest();
}



}		// subproc
}		// pss
}		// subscreen
}		// field

