//============================================================================================
/**
 * @file		test_pokeicon_graphic_2d.cpp
 * @brief		OtBbN֘Ai2D̂݁j
 * @author	Hiroyuki Nakamura
 * @date		12.05.11
 *
 * namespace	app::test_pokeicon::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "test_PokeIcon_graphic.h"
//#include "message/msg_test_pokeicon.h"
#include "test_pokeicon_res.h"
#include "test_pokeicon_res_pane.h"


namespace app {
namespace test_pokeicon {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap )
{
	CreateGraphicsSystem( heap );

	Create2D( heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork()
{
	Delete2D();

	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
	pG2dUtil->Update2D();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
	pG2dUtil->Draw2D( pGraSystem, 0 );
	pG2dUtil->Draw2D( pGraSystem, 1 );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateGraphicsSystem( app::util::Heap * heap )
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pGraSystem = gm->GetGraphicsSystem();
	pGraSystem->InitializeApplicationMemory( heap->pDevHeapAllocator );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteGraphicsSystem(void)
{
	pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create2D( app::util::Heap * heap )
{
	pG2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );

	// \[Xf[^e[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
	{
		{ ARCID_POKEICON_VIEW, 0 },
	};
	// CAEgf[^
	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
    { // 
      0,
      LYTRES_TEST_POKEICON_RES_PI_VIEW_UPPER_BCLYT,     // resID̃CAEgf[^ID
      NULL,                               // Aj[Vf[^IDe[u AĵȂꍇNULL
      0,                                  // Aj[Vf[^IDe[u AĵȂꍇ0
      0,                                  // o^Aj[Vő吔
      false,                              // \yCɍsvZs
      app::util::G2DUtil::SETUP_UPPER,    // fBXvC
      true,                               // \ݒ
    },
    { // 
      0,
      LYTRES_TEST_POKEICON_RES_PI_VIEW_LOWER_BCLYT,
			NULL,
			0,
			0,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
	};

	pG2dUtil->CreateLayoutSystem( heap );
	pG2dUtil->SetDefaultFont( "cbf_std.bcfnt" );
	pG2dUtil->CreateLayoutEnv( heap, false );
	pG2dUtil->CreateLayoutWork( GFL_NELEMS(layoutData), heap );
	pG2dUtil->CreateLayoutResource( GFL_NELEMS(resTbl), heap );
	pG2dUtil->LoadLayoutResource( 0, resTbl, GFL_NELEMS(resTbl), heap, true );
	pG2dUtil->TransferLayoutTexture();
	pG2dUtil->SetLayoutWork( layoutData, 0, GFL_NELEMS(layoutData) );
//	pG2dUtil->CreateMessageData( const wchar_t * arcFilePath, u32 datID, gfl::str::MsgData::LoadType loadType, Heap * heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete2D(void)
{
//	pG2dUtil->DeleteMessageData();
	pG2dUtil->DeleteLayoutResource();
	pG2dUtil->DeleteLayoutWork2();
	pG2dUtil->DeleteLayoutEnv();
	pG2dUtil->DeleteLayoutSystem();

	GFL_DELETE	pG2dUtil;
}


}	// test_pokeicon
}	// app
