#=============================================================================================
#
#	bclimpbgɕύX
#	2012/01/26 by nakahiro
#
#=============================================================================================

#---------------------------------------------------------------------------------------------
#	O錾
#---------------------------------------------------------------------------------------------
use File::Find;		# t@CW[


#---------------------------------------------------------------------------------------------
#	萔`
#---------------------------------------------------------------------------------------------
$BCLIM_FOOTER_SIZE = 40;		# tb^[TCY

$ERR_CODE_NONE = 0;				# G[R[h: G[Ȃ
$ERR_CODE_PALETTE_OVER = 1;		# G[R[h: pbgI[o[
$ERR_CODE_FORMAT_FALSE = 2;		# G[R[h: tH[}bgΉ


#---------------------------------------------------------------------------------------------
#	O[o
#---------------------------------------------------------------------------------------------
$FileName = $ARGV[0];			# t@C
$FileSize;						# t@CTCY
$FileFormat = $ARGV[1];			# t@CtH[}bg
$TexBuff;						# ǂݍݏꏊ
$PalBuff;						# pbg쐬ꏊ
$PalSize = 0;					# pbgTCY
$CnvBuff;						# Ro[gf[^쐬ꏊ
$ErrorCode = $ERR_CODE_NONE;	# G[R[h


#---------------------------------------------------------------------------------------------
#	C
#---------------------------------------------------------------------------------------------
&SUB_Main();

exit;


#---------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------
sub SUB_Main {
	$ErrorCode = $ERR_CODE_FORMAT_FALSE;
	if( $FileFormat == 2 ){
		$ErrorCode = $ERR_CODE_NONE;
	}
	if( $FileFormat == 4 ){
		$ErrorCode = $ERR_CODE_NONE;
	}
	
	if( $ErrorCode == $ERR_CODE_NONE ){
		&SUB_TexLoad();
	}
	if( $ErrorCode == $ERR_CODE_NONE ){
		&SUB_TexConvert();
	}
	if( $ErrorCode == $ERR_CODE_NONE ){
		&SUB_TexSave();
	}

	# pbgI[o[
	if( $ErrorCode == $ERR_CODE_PALETTE_OVER ){
		print( "ERROR: palette size [" . $PalSize . "] over 256\n" );
	# tH[}bgΉ
	}elsif( $ErrorCode == $ERR_CODE_FORMAT_FALSE ){
		print( "ERROR: pixel format\n" );
	}
}


#---------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------
sub SUB_TexLoad {
	$FileSize = -s $FileName;

	open( FP_SRC, "<" . $FileName );
	binmode( FP_SRC );

	for( $i=0; $i<$FileSize; $i++ ){
		my $d;
		read( FP_SRC, $d, 1 );
		$TexBuff[$i] = unpack( "C", $d );
#		if( $i < ($FileSize-$BCLIM_FOOTER_SIZE) ){
#			$TexBuff[$i] = $TexBuff[$i] ^ 0xff;
#		}
	}

	close( FP_SRC );
}

#---------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------
sub SUB_TexSave {
	open( FP_SRC, ">" . $FileName );
	binmode( FP_SRC );

	# sNZtH[}bg
	my $fmt = pack( "S", $FileFormat );
	print( FP_SRC $fmt );
	$pb_siz = 2;

	# pbgTCY
	my $siz = pack( "S", $PalSize );
	print( FP_SRC $siz );
	$pb_siz += 2;
		
	# pbg
	if( $FileFormat == 2 ){
		for( $i=0; $i<$PalSize; $i++ ){
			my $col = pack( "S", $PalBuff[$i] );
			print( FP_SRC $col );
		}
		$pb_siz += ( $PalSize * 2 );
	}else{
		for( $i=0; $i<$PalSize; $i++ ){
			my $col = pack( "L", $PalBuff[$i] );
			print( FP_SRC $col );
		}
		$pb_siz += ( $PalSize * 4 );
	}

	# hbg
	for( $i=0; $i<($FileSize-$BCLIM_FOOTER_SIZE-$pb_siz); $i++ ){
		my $dot = pack( "C", $CnvBuff[$i] );
		print( FP_SRC $dot );
	}
		
	# tb^[
	for( $i=($FileSize-$BCLIM_FOOTER_SIZE); $i<$FileSize; $i++ ){
		my $f = pack( "C", $TexBuff[$i] );
		print( FP_SRC $f );
	}

	close( FP_SRC );
}


#---------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------
sub SUB_TexConvert {
	# pbg쐬
	for( $i=0; $i<($FileSize-$BCLIM_FOOTER_SIZE); $i+=$FileFormat ){
		$col = 0;
		for( $j=$FileFormat-1; $j>=0; $j-- ){
			$col <<= 8;
			$col += $TexBuff[$i+$j];
		}
		for( $j=0; $j<$PalSize; $j++ ){
			if( $PalBuff[$j] == $col ){
				last;
			}
		}
		if( $j == $PalSize ){
			$PalBuff[$j] = $col;
			$PalSize += 1;
		}
	}
	# TCY`FbN
	if( $PalSize > 256 ){
		$ErrorCode = $ERR_CODE_PALETTE_OVER;
		return;
	}
	
	# hbgf[^ύX
	$pos = 0;
	# pbg16ȉ̂Ƃ
	if( $PalSize <= 16 ){
		$bit = 0;
		for( $i=0; $i<($FileSize-$BCLIM_FOOTER_SIZE); $i+=$FileFormat ){
			$col = 0;
			for( $j=$FileFormat-1; $j>=0; $j-- ){
				$col <<= 8;
				$col += $TexBuff[$i+$j];
			}
			for( $j=0; $j<$PalSize; $j++ ){
				if( $PalBuff[$j] == $col ){
					if( $bit == 0 ){
						$CnvBuff[$pos] = ( $j << 4 );
					}else{
						$CnvBuff[$pos] = ( $CnvBuff[$pos] & 0xf0 ) | $j;
						$pos += 1;
					}
					$bit ^= 1;
					last;
				}
			}
		}
		if( $bit == 1 ){
			$pos++;
		}
	}else{
		for( $i=0; $i<($FileSize-$BCLIM_FOOTER_SIZE); $i+=$FileFormat ){
			$col = 0;
			for( $j=$FileFormat-1; $j>=0; $j-- ){
				$col <<= 8;
				$col += $TexBuff[$i+$j];
			}
			for( $j=0; $j<$PalSize; $j++ ){
				if( $PalBuff[$j] == $col ){
					$CnvBuff[$pos] = $j;
					$pos += 1;
					last;
				}
			}
		}
	}
	# 󂫂0tB
	for( $i=$pos; $i<($FileSize-$BCLIM_FOOTER_SIZE); $i++ ){
		$CnvBuff[$i] = 0;
	}
}
