
#include "pss_subproc_regist_favorite.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcRegistFavorite::PssSubProcRegistFavorite( void ) : PssSubProcBase()
{

}




//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr           GameProcManagerւ̃|C^
* @param   texSystem             LytTexReplaceSystemւ̃|C^
* @param   isEnableSelectingIcon ACRҏWʂւ̑Jڂ\Ȃtruew
* @param   isFavoriteMenu        Cɓꗗ̑JڂȂtruew
* @param   friendKey             \vC[̃thL[
* @param   iconMgr               PlayerIconManagerւ̃|C^
* @param   msgData               bZ[Wf[^
* @param   wordset               [hZbg
* @param   paramWork             Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcRegistFavorite::Init( gamesystem::GameProcManager *gameProgMgr,
                      const gflnet::friends::FriendKey& friendKey,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  m_targetPlayer = friendKey;

  // Cɓ܂
  if( savedata::pss_favorite::IsExistPssFavoriteSaveData(friendKey) )
  {
    app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(paramWork);

    param->m_layout          = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
    param->m_messageData     = msgData;
    param->m_wordset         = wordset;
    param->m_targetPlayer[0] = friendKey;
    param->m_execMode        = app::pss::pss_user_notify::E_MODE_FAVORITE_RESIGN;
    param->m_playerIconMgr   = iconMgr;

    m_subProc = dll::CreatePssUserNotifyProc( m_gameProgMgr, param );
  }
  // Cɓ胆[U[ςłI
  else if( savedata::pss_favorite::IsFullPssFavoriteSaveData() )
  {
    app::pss::pss_message_window::APP_PARAM *param = static_cast<app::pss::pss_message_window::APP_PARAM*>(paramWork);

    param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
    param->m_messageData   = msgData;
    param->m_wordset       = wordset;
    param->m_targetPlayer  = friendKey;
    param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
    param->m_messageText   = msg_pss_20_01_02;  // Cɓ肪ς
    param->m_playerIconMgr = iconMgr;
    param->m_isDispLoading = false;
    param->m_inputLock     = false;

    m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
    m_subProc->InitFunc( m_gameProgMgr );
  }
  // Cɓo^H
  else
  {
    app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(paramWork);

    param->m_layout          = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
    param->m_messageData     = msgData;
    param->m_wordset         = wordset;
    param->m_targetPlayer[0] = friendKey;
    param->m_execMode        = app::pss::pss_user_notify::E_MODE_FAVORITE_REGIST;
    param->m_playerIconMgr   = iconMgr;

    m_subProc = dll::CreatePssUserNotifyProc( m_gameProgMgr, param );
  }

  m_subProc->InitFunc( m_gameProgMgr );


  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcRegistFavorite::Update( void )
{
  if( !UpdateSubProc() )
  {
    bool isExistUser = savedata::pss_favorite::IsExistPssFavoriteSaveData(m_targetPlayer);

    // o^Esꍇ̂݁I
    if( isExistUser || !savedata::pss_favorite::IsFullPssFavoriteSaveData() )
    {
      app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);

      if( param->m_isSelectYes )
      {
        if( isExistUser )
        {
          bool isSuccess = savedata::pss_favorite::RemovePersonalFromPssFavoriteSaveData( param->m_targetPlayer[0] );
          GFL_PRINT( "Cɓ[isSucess=%d]\n",isSuccess );
        }
        else
        {
          bool isSuccess = savedata::pss_favorite::AddPersonalToPssFavoriteSaveData( param->m_targetPlayer[0] );
          GFL_PRINT( "Cɓo^[isSucess=%d]\n",isSuccess );
        }
      }
    }
    gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );

    return RET_FAVORITE_END;
  }

  return RET_NONE;
}






}		// subproc
}		// pss
}		// subscreen
}		// field

