
#include "pss_subproc_profile.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcProfile::PssSubProcProfile( void ) : PssSubProcBase()
{

}




//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr           GameProcManagerւ̃|C^
* @param   texSystem             LytTexReplaceSystemւ̃|C^
* @param   isEnableSelectingIcon ACRҏWʂւ̑Jڂ\Ȃtruew
* @param   isFavoriteMenu        Cɓꗗ̑JڂȂtruew
* @param   friendKey             \vC[̃thL[
* @param   iconMgr               PlayerIconManagerւ̃|C^
* @param   msgData               bZ[Wf[^
* @param   wordset               [hZbg
* @param   paramWork             Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcProfile::Init( gamesystem::GameProcManager *gameProgMgr,
                      app::tool::LytTexReplaceSystem* texSystem,
                      bool isEnableSelectingIcon, bool isFavoriteMenu,
                      const gflnet::friends::FriendKey& friendKey,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  app::pss::pss_profile::APP_PARAM *param = static_cast<app::pss::pss_profile::APP_PARAM*>(m_paramWork);

  param->m_layout           = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_playerIconMgr    = iconMgr;
  param->m_textureSystem    = texSystem;
  param->m_targetPlayer     = friendKey;
  param->m_isEnableIcon     = isEnableSelectingIcon;
  param->m_isFavoritePlayer = isFavoriteMenu;
  param->m_pssMessageData   = msgData;
  param->m_pssWordset       = wordset;

  m_subProc  = dll::CreatePssProfileProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
  m_subProc->UpdateFunc( m_gameProgMgr );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcProfile::Update( void )
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_profile::APP_PARAM *param = static_cast<app::pss::pss_profile::APP_PARAM*>(m_paramWork);

    if( param->m_endMode == app::pss::pss_profile::PSS_PROFILE_END_MODE_ICON_SELECT ){
      return RET_PROFILE_ICONSEL;
    }
    else if( param->m_endMode == app::pss::pss_profile::PSS_PROFILE_END_MODE_BACK ){
      return RET_PROFILE_CANCEL;
    }
    else if( param->m_endMode == app::pss::pss_profile::PSS_PROFILE_END_MODE_RETURN ){
      return RET_PROFILE_RETURN;
    }
  }

  return RET_NONE;
}






}		// subproc
}		// pss
}		// subscreen
}		// field

