
#include "pss_subproc_mainmenu.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcMainMenu::PssSubProcMainMenu( void ) : PssSubProcBase()
{

}




//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr      GameProcManagerւ̃|C^
* @param   beaconResponder  PssBeaconResponderւ̃|C^
* @param   paramWork        Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcMainMenu::Init( gamesystem::GameProcManager *gameProgMgr, netapp::pss::PssBeaconResponder* beaconResponder, void* paramWork )
{
  InitBase( gameProgMgr, beaconResponder, paramWork );

  app::pss::pss_mainmenu::APP_PARAM *param = static_cast<app::pss::pss_mainmenu::APP_PARAM*>(m_paramWork);
  param->m_layout       = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData  = NULL;
  param->m_wordset      = NULL;

  m_subProc = dll::CreatePssMainMenuProc( gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcMainMenu::Update( void )
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_mainmenu::APP_PARAM *param = static_cast<app::pss::pss_mainmenu::APP_PARAM*>(m_paramWork);

    if( param->m_resultCode == app::pss::pss_mainmenu::E_RET_HAPPY )
    {
      netapp::pss::PssPersonalDataManager* pssPersonalMgr = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetPssPersonalDataManager();
      netapp::pss::PssPersonalData*        myInfo         = pssPersonalMgr->GetMyData();

      myInfo->SetRequestHappyIcon();
      m_beaconResponder->SendMyData();

      return RET_MENU_CANCEL;
    }
    else if( param->m_resultCode == app::pss::pss_mainmenu::E_RET_PROFILE ){
      return RET_MENU_PROFILE;
    }
    else if( param->m_resultCode == app::pss::pss_mainmenu::E_RET_NEAR_PLAY ){
      return RET_MENU_NEAR_COMMUNICATION;
    }
    else if( param->m_resultCode == app::pss::pss_mainmenu::E_RET_FAR_PLAY ){
      return RET_MENU_FAR_COMMUNICATION;
    }
    else if( param->m_resultCode == app::pss::pss_mainmenu::E_RET_FAVORITE ){
      return RET_MENU_FAVORITE;
    }
    else{
      return  RET_MENU_CANCEL;
    }
  }

  return RET_NONE;
}






}		// subproc
}		// pss
}		// subscreen
}		// field

