
#include "pss_subproc_iconselect.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcIconSelect::PssSubProcIconSelect( void ) : PssSubProcBase()
{

}




//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr     GameProcManagerւ̃|C^
* @param   beaconResponder PssBeaconResponderւ̃|C^
* @param   texSystem       LytTexReplaceSystemւ̃|C^
* @param   iconMgr         PlayerIconManagerւ̃|C^
* @param   friendKey       \Ώۃ[U[̃thL[
* @param   paramWork       Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcIconSelect::Init( gamesystem::GameProcManager *gameProgMgr,
                                            netapp::pss::PssBeaconResponder* beaconResponder,
                                            app::tool::LytTexReplaceSystem* texSystem,
                                            xy_system::player_icon::PlayerIconManager* iconMgr,
                                            gflnet::friends::FriendKey& friendKey,
                                            void* paramWork )
{
  InitBase( gameProgMgr, beaconResponder, paramWork );

  app::pss::pss_icon_select::APP_PARAM *param = static_cast<app::pss::pss_icon_select::APP_PARAM*>(m_paramWork);
  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_textureSystem = texSystem;
  param->m_playerIconMgr = iconMgr;
  param->m_targetPlayer  = friendKey;

  m_subProc  = dll::CreatePssIconSelectProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
  m_subProc->UpdateFunc( m_gameProgMgr );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcIconSelect::Update( void )
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_icon_select::APP_PARAM *param = static_cast<app::pss::pss_icon_select::APP_PARAM*>(m_paramWork);

    // ACR̍XVꍇ͑҂ɒʒm
    if( param->m_isChanged )
    {
      netapp::pss::PssPersonalDataManager* pssPersonalMgr = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetPssPersonalDataManager();
      netapp::pss::PssPersonalData*        targetPerson   = pssPersonalMgr->GetPersonalData( param->m_targetPlayer );
      netapp::pss::PssPersonalData*        myInfo         = pssPersonalMgr->GetMyData();
      myInfo->SetRequestIconChange();

      m_beaconResponder->SendMyData();

      // Z[uf[^̓eXV
      savedata::MyStatus* myStatus = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetGameData()->GetPlayerStatus();
      myStatus->SetPssIconForFriend( myInfo->GetFriendIconID() );
      myStatus->SetPssIconForStranger( myInfo->GetStrangerIconID() );
    }

    if( param->m_resultCode == app::pss::pss_icon_select::E_RET_CANCEL ){
      return RET_ICONSELECT_CANCEL;
    }
    return RET_ICONSELECT_RETURN;
  }

  return RET_NONE;

}






}		// subproc
}		// pss
}		// subscreen
}		// field

