
#include "pss_subproc_edit_favorite.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcEditFavorite::PssSubProcEditFavorite( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr     GameProcManagerւ̃|C^
* @param   beaconResponder PssBeaconResponderւ̃|C^
* @param   texSystem       LytTexReplaceSystemւ̃|C^
* @param   iconMgr         PlayerIconManagerւ̃|C^
* @param   msgData         bZ[Wf[^
* @param   wordset         [hZbg
* @param   paramWork       Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcEditFavorite::Init( gamesystem::GameProcManager *gameProgMgr,
                                            app::tool::LytTexReplaceSystem* texSystem,
                                            xy_system::player_icon::PlayerIconManager* iconMgr,
                                            gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  InitFavoriteMenu( texSystem, iconMgr, msgData, wordset );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcEditFavorite::Update( void )
{
  if( !UpdateSubProc() )
  {
    // Cɓ胊Xg
    if( m_seq == E_FAV_SEQ_LIST_MENU )
    {
      app::pss::pss_favorite::APP_PARAM *param = static_cast<app::pss::pss_favorite::APP_PARAM*>(m_paramWork);

      if( param->m_resultCode == app::pss::pss_favorite::E_RET_CANCEL ){
        return RET_FAVORITE_BACK;
      }
      else if( param->m_resultCode == app::pss::pss_favorite::E_RET_RETURN ){
        return RET_FAVORITE_RETURN;
      }
      else
      {
        InitProfileMenu( param->m_textureSystem, false, true,
                         param->m_selectedPlayer, param->m_playerIconMgr,
                         param->m_messageData, param->m_wordset );
      }
    }
    // vtB[
    else
    {
      app::pss::pss_profile::APP_PARAM *param = static_cast<app::pss::pss_profile::APP_PARAM*>(m_paramWork);

      InitFavoriteMenu( param->m_textureSystem, param->m_playerIconMgr, param->m_pssMessageData, param->m_pssWordset );
    }
  }
  return RET_NONE;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   Cɓꗗʂ̏
*
* @param   texSystem       LytTexReplaceSystemւ̃|C^
* @param   iconMgr         PlayerIconManagerւ̃|C^
* @param   msgData         bZ[Wf[^
* @param   wordset         [hZbg
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcEditFavorite::InitFavoriteMenu(app::tool::LytTexReplaceSystem* texSystem,
                                              xy_system::player_icon::PlayerIconManager* iconMgr,
                                              gfl::str::MsgData* msgData, WordSet* wordset )
{
  app::pss::pss_favorite::APP_PARAM *param = reinterpret_cast<app::pss::pss_favorite::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_textureSystem = texSystem;
  param->m_messageData   = msgData;
  param->m_wordset       = wordset;
  param->m_playerIconMgr = iconMgr;

  m_subProc = dll::CreatePssFavoriteProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  m_seq = E_FAV_SEQ_LIST_MENU;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   vtB[ʂ̏
*
* @brief   
*
* @param   texSystem             LytTexReplaceSystemւ̃|C^
* @param   isEnableSelectingIcon ACRҏWʂւ̑Jڂ\Ȃtruew
* @param   isFavoriteMenu        Cɓꗗ̑JڂȂtruew
* @param   friendKey             \vC[̃thL[
* @param   iconMgr               PlayerIconManagerւ̃|C^
* @param   msgData               bZ[Wf[^
* @param   wordset               [hZbg
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcEditFavorite::InitProfileMenu( app::tool::LytTexReplaceSystem* texSystem,
                                              bool isEnableSelectingIcon, bool isFavoriteMenu,
                                              const gflnet::friends::FriendKey& friendKey,
                                              xy_system::player_icon::PlayerIconManager* iconMgr,
                                              gfl::str::MsgData* msgData, WordSet* wordset )
{
  app::pss::pss_profile::APP_PARAM *param = static_cast<app::pss::pss_profile::APP_PARAM*>(m_paramWork);

  param->m_layout           = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_playerIconMgr    = iconMgr;
  param->m_textureSystem    = texSystem;
  param->m_targetPlayer     = friendKey;
  param->m_isEnableIcon     = isEnableSelectingIcon;
  param->m_isFavoritePlayer = isFavoriteMenu;
  param->m_pssMessageData   = msgData;
  param->m_pssWordset       = wordset;

  m_subProc  = dll::CreatePssProfileProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
  m_subProc->UpdateFunc( m_gameProgMgr );

  m_seq = E_FAV_SEQ_PROFILE_MENU;
}




}		// subproc
}		// pss
}		// subscreen
}		// field

