#ifndef __PSS_SUBPROC_CONNECT_WIFI_H__
#define __PSS_SUBPROC_CONNECT_WIFI_H__


#include "pss_subproc_base.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


class PssSubProcConnectWifi : public PssSubProcBase
{
public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   RXgN^
  *
  * @param   none
  *
  * @return  none
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcConnectWifi( void );

public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   
  *
  * @param   isWifiConnecting      WifiڑԂȂtrueAڑԂȂfalsew
  * @param   gameProgMgr           GameProcManagerւ̃|C^
  * @param   iconMgr               PlayerIconManagerւ̃|C^
  * @param   msgData               bZ[Wf[^
  * @param   wordset               [hZbg
  * @param   paramWork             Procp[^p̈
  *
  * @return  PssSubProcBaseւ̃|C^
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcBase* Init( bool isWifiConnecting, gamesystem::GameProcManager *gameProgMgr,
                        xy_system::player_icon::PlayerIconManager* iconMgr,
                        gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   XV
  *
  * @param   none
  *
  * @return  sʃR[h
  */
  //--------------------------------------------------------------------------------------------
  virtual field::subscreen::pss::E_PSS_PROC_RESULT Update( void );

private:
  void InitWifiStarting( bool isWifiConnecting );
  void InitWifiConnecting( void );
  void InitWifiFinishing( void );


private:
  typedef enum
  {
    E_WIFI_CON_SEQ_ASK,
    E_WIFI_CON_SEQ_CONNECTING,
    E_WIFI_CON_SEQ_FINISH
  }E_WIFI_CONNECTION_SEQUENCE;


private:
  E_WIFI_CONNECTION_SEQUENCE                 m_seq;               // V[PX
  bool                                       m_isWifiConnecting;  //
  xy_system::player_icon::PlayerIconManager* m_playerIconMgr;     // vC[ACR}l[W
  gfl::str::MsgData*                         m_msgData;           //
  WordSet*                                   m_wordset;           //
};




}		// subproc
}		// pss
}		// subscreen
}		// field


#endif

